/*
 * Decompiled with CFR 0.152.
 */
package net.gpedro.integrations.slack;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SlackField {
    private List<String> allowMarkdown = null;
    private boolean shorten = false;
    private String title = null;
    private String value = null;

    public SlackField(String title, String value) {
        this.title = title;
        this.value = value;
    }

    public void addAllowedMarkdown(String field) {
        if (this.allowMarkdown == null) {
            this.allowMarkdown = new ArrayList<String>();
        }
        if (!field.matches("^(pretext|text|title|fields|fallback)$")) {
            throw new IllegalArgumentException(field + " is not allowed. Allowed: pretext, text, title, fields and fallback");
        }
        this.allowMarkdown.add(field);
    }

    public boolean isShorten() {
        return this.shorten;
    }

    private JsonArray prepareMarkdown() {
        JsonArray data = new JsonArray();
        for (String item : this.allowMarkdown) {
            data.add((JsonElement)new JsonPrimitive(item));
        }
        return data;
    }

    public SlackField setAllowedMarkdown(ArrayList<String> allowMarkdown) {
        this.allowMarkdown = new ArrayList<String>(allowMarkdown);
        return this;
    }

    public SlackField setShorten(boolean shorten) {
        this.shorten = shorten;
        return this;
    }

    public SlackField setTitle(String title) {
        this.title = title;
        return this;
    }

    public SlackField setValue(String value) {
        this.value = value;
        return this;
    }

    public JsonObject toJson() {
        JsonObject data = new JsonObject();
        data.addProperty("title", this.title);
        data.addProperty("value", this.value);
        data.addProperty("short", Boolean.valueOf(this.shorten));
        if (this.allowMarkdown != null && this.allowMarkdown.size() > 0) {
            data.add("mrkdwn_in", (JsonElement)this.prepareMarkdown());
        }
        return data;
    }
}

