/*
 * Decompiled with CFR 0.152.
 */
package net.gotev.uploadservice.schemehandlers;

import java.lang.reflect.InvocationTargetException;
import java.util.LinkedHashMap;
import java.util.Map;
import net.gotev.uploadservice.schemehandlers.ContentSchemeHandler;
import net.gotev.uploadservice.schemehandlers.FileSchemeHandler;
import net.gotev.uploadservice.schemehandlers.SchemeHandler;

public class SchemeHandlerFactory {
    private LinkedHashMap<String, Class<? extends SchemeHandler>> handlers = new LinkedHashMap();

    public static SchemeHandlerFactory getInstance() {
        return LazyHolder.INSTANCE;
    }

    private SchemeHandlerFactory() {
        this.handlers.put("/", FileSchemeHandler.class);
        this.handlers.put("content://", ContentSchemeHandler.class);
    }

    public SchemeHandler get(String path) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        for (Map.Entry<String, Class<? extends SchemeHandler>> handler : this.handlers.entrySet()) {
            if (!path.startsWith(handler.getKey())) continue;
            SchemeHandler schemeHandler = handler.getValue().newInstance();
            schemeHandler.init(path);
            return schemeHandler;
        }
        throw new UnsupportedOperationException("No handlers for " + path);
    }

    public boolean isSupported(String path) {
        for (String scheme : this.handlers.keySet()) {
            if (!path.startsWith(scheme)) continue;
            return true;
        }
        return false;
    }

    private static class LazyHolder {
        private static final SchemeHandlerFactory INSTANCE = new SchemeHandlerFactory();

        private LazyHolder() {
        }
    }
}

