/*
 * Decompiled with CFR 0.152.
 */
package net.gotev.uploadservice.http;

import java.io.IOException;
import java.io.InputStream;
import net.gotev.uploadservice.UploadService;

public abstract class BodyWriter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writeStream(InputStream stream, OnStreamWriteListener listener) throws IOException {
        if (listener == null) {
            throw new IllegalArgumentException("listener MUST not be null!");
        }
        byte[] buffer = new byte[UploadService.BUFFER_SIZE];
        try {
            int bytesRead;
            while (listener.shouldContinueWriting() && (bytesRead = stream.read(buffer, 0, buffer.length)) > 0) {
                this.write(buffer, bytesRead);
                this.flush();
                listener.onBytesWritten(bytesRead);
            }
        }
        finally {
            stream.close();
        }
    }

    public abstract void write(byte[] var1) throws IOException;

    public abstract void write(byte[] var1, int var2) throws IOException;

    public abstract void flush() throws IOException;

    public static interface OnStreamWriteListener {
        public boolean shouldContinueWriting();

        public void onBytesWritten(int var1);
    }
}

