/*
 * Decompiled with CFR 0.152.
 */
package net.gotev.uploadservice;

import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.content.Context;
import android.content.Intent;
import android.media.RingtoneManager;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.support.v4.app.NotificationCompat;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import net.gotev.uploadservice.BroadcastData;
import net.gotev.uploadservice.Logger;
import net.gotev.uploadservice.Placeholders;
import net.gotev.uploadservice.ServerResponse;
import net.gotev.uploadservice.UploadFile;
import net.gotev.uploadservice.UploadInfo;
import net.gotev.uploadservice.UploadNotificationConfig;
import net.gotev.uploadservice.UploadNotificationStatusConfig;
import net.gotev.uploadservice.UploadService;
import net.gotev.uploadservice.UploadStatusDelegate;
import net.gotev.uploadservice.UploadTaskParameters;

public abstract class UploadTask
implements Runnable {
    private static final String LOG_TAG = UploadTask.class.getSimpleName();
    protected static final int TASK_COMPLETED_SUCCESSFULLY = 200;
    protected static final byte[] EMPTY_RESPONSE = "".getBytes(Charset.forName("UTF-8"));
    protected UploadService service;
    protected UploadTaskParameters params = null;
    private final List<String> successfullyUploadedFiles = new ArrayList<String>();
    protected boolean shouldContinue = true;
    private int notificationId;
    private long lastProgressNotificationTime;
    private NotificationManager notificationManager;
    private Handler mainThreadHandler;
    private long notificationCreationTimeMillis;
    protected long totalBytes;
    protected long uploadedBytes;
    private final long startTime = new Date().getTime();
    private int attempts;

    protected abstract void upload() throws Exception;

    protected void onSuccessfulUpload() {
    }

    protected void init(UploadService service, Intent intent) throws IOException {
        this.notificationManager = (NotificationManager)service.getSystemService("notification");
        this.params = (UploadTaskParameters)intent.getParcelableExtra("taskParameters");
        this.service = service;
        this.mainThreadHandler = new Handler(service.getMainLooper());
        if (Build.VERSION.SDK_INT >= 26 && this.params.notificationConfig != null) {
            String notificationChannelId = this.params.notificationConfig.getNotificationChannelId();
            if (notificationChannelId == null) {
                this.params.notificationConfig.setNotificationChannelId(UploadService.NAMESPACE);
                notificationChannelId = UploadService.NAMESPACE;
            }
            if (this.notificationManager.getNotificationChannel(notificationChannelId) == null) {
                NotificationChannel channel = new NotificationChannel(notificationChannelId, (CharSequence)"Upload Service channel", 4);
                this.notificationManager.createNotificationChannel(channel);
            }
        }
    }

    @Override
    public final void run() {
        this.createNotification(new UploadInfo(this.params.id));
        this.attempts = 0;
        int errorDelay = UploadService.INITIAL_RETRY_WAIT_TIME;
        while (this.attempts <= this.params.getMaxRetries() && this.shouldContinue) {
            ++this.attempts;
            try {
                this.upload();
                break;
            }
            catch (Exception exc) {
                if (!this.shouldContinue) break;
                if (this.attempts > this.params.getMaxRetries()) {
                    this.broadcastError(exc);
                    continue;
                }
                Logger.error(LOG_TAG, "Error in uploadId " + this.params.id + " on attempt " + this.attempts + ". Waiting " + errorDelay / 1000 + "s before next attempt. ", exc);
                long beforeSleepTs = System.currentTimeMillis();
                while (this.shouldContinue && System.currentTimeMillis() < beforeSleepTs + (long)errorDelay) {
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (Throwable ignored) {}
                }
                if ((errorDelay *= UploadService.BACKOFF_MULTIPLIER) <= UploadService.MAX_RETRY_WAIT_TIME) continue;
                errorDelay = UploadService.MAX_RETRY_WAIT_TIME;
            }
        }
        if (!this.shouldContinue) {
            this.broadcastCancelled();
        }
    }

    protected final UploadTask setLastProgressNotificationTime(long lastProgressNotificationTime) {
        this.lastProgressNotificationTime = lastProgressNotificationTime;
        return this;
    }

    protected final UploadTask setNotificationId(int notificationId) {
        this.notificationId = notificationId;
        return this;
    }

    protected final void broadcastProgress(long uploadedBytes, long totalBytes) {
        long currentTime = System.currentTimeMillis();
        if (uploadedBytes < totalBytes && currentTime < this.lastProgressNotificationTime + 166L) {
            return;
        }
        this.setLastProgressNotificationTime(currentTime);
        Logger.debug(LOG_TAG, "Broadcasting upload progress for " + this.params.id + ": " + uploadedBytes + " bytes of " + totalBytes);
        final UploadInfo uploadInfo = new UploadInfo(this.params.id, this.startTime, uploadedBytes, totalBytes, this.attempts - 1, this.successfullyUploadedFiles, UploadTask.pathStringListFrom(this.params.files));
        BroadcastData data = new BroadcastData().setStatus(BroadcastData.Status.IN_PROGRESS).setUploadInfo(uploadInfo);
        final UploadStatusDelegate delegate = UploadService.getUploadStatusDelegate(this.params.id);
        if (delegate != null) {
            this.mainThreadHandler.post(new Runnable(){

                @Override
                public void run() {
                    delegate.onProgress((Context)UploadTask.this.service, uploadInfo);
                }
            });
        } else {
            this.service.sendBroadcast(data.getIntent());
        }
        this.updateNotificationProgress(uploadInfo);
    }

    protected final void broadcastCompleted(final ServerResponse response) {
        UploadStatusDelegate delegate;
        boolean successfulUpload;
        boolean bl = successfulUpload = response.getHttpCode() >= 200 && response.getHttpCode() < 400;
        if (successfulUpload) {
            this.onSuccessfulUpload();
            if (this.params.autoDeleteSuccessfullyUploadedFiles && !this.successfullyUploadedFiles.isEmpty()) {
                for (String filePath : this.successfullyUploadedFiles) {
                    this.deleteFile(new File(filePath));
                }
            }
        }
        Logger.debug(LOG_TAG, "Broadcasting upload " + (successfulUpload ? "completed" : "error") + " for " + this.params.id);
        final UploadInfo uploadInfo = new UploadInfo(this.params.id, this.startTime, this.uploadedBytes, this.totalBytes, this.attempts - 1, this.successfullyUploadedFiles, UploadTask.pathStringListFrom(this.params.files));
        UploadNotificationConfig notificationConfig = this.params.notificationConfig;
        if (notificationConfig != null) {
            if (successfulUpload && notificationConfig.getCompleted().message != null) {
                this.updateNotification(uploadInfo, notificationConfig.getCompleted());
            } else if (notificationConfig.getError().message != null) {
                this.updateNotification(uploadInfo, notificationConfig.getError());
            }
        }
        if ((delegate = UploadService.getUploadStatusDelegate(this.params.id)) != null) {
            this.mainThreadHandler.post(new Runnable(){

                @Override
                public void run() {
                    if (successfulUpload) {
                        delegate.onCompleted((Context)UploadTask.this.service, uploadInfo, response);
                    } else {
                        delegate.onError((Context)UploadTask.this.service, uploadInfo, response, null);
                    }
                }
            });
        } else {
            BroadcastData data = new BroadcastData().setStatus(successfulUpload ? BroadcastData.Status.COMPLETED : BroadcastData.Status.ERROR).setUploadInfo(uploadInfo).setServerResponse(response);
            this.service.sendBroadcast(data.getIntent());
        }
        this.service.taskCompleted(this.params.id);
    }

    protected final void broadcastCancelled() {
        Logger.debug(LOG_TAG, "Broadcasting cancellation for upload with ID: " + this.params.id);
        final UploadInfo uploadInfo = new UploadInfo(this.params.id, this.startTime, this.uploadedBytes, this.totalBytes, this.attempts - 1, this.successfullyUploadedFiles, UploadTask.pathStringListFrom(this.params.files));
        UploadNotificationConfig notificationConfig = this.params.notificationConfig;
        if (notificationConfig != null && notificationConfig.getCancelled().message != null) {
            this.updateNotification(uploadInfo, notificationConfig.getCancelled());
        }
        BroadcastData data = new BroadcastData().setStatus(BroadcastData.Status.CANCELLED).setUploadInfo(uploadInfo);
        final UploadStatusDelegate delegate = UploadService.getUploadStatusDelegate(this.params.id);
        if (delegate != null) {
            this.mainThreadHandler.post(new Runnable(){

                @Override
                public void run() {
                    delegate.onCancelled((Context)UploadTask.this.service, uploadInfo);
                }
            });
        } else {
            this.service.sendBroadcast(data.getIntent());
        }
        this.service.taskCompleted(this.params.id);
    }

    protected final void addSuccessfullyUploadedFile(UploadFile file) {
        if (!this.successfullyUploadedFiles.contains(file.path)) {
            this.successfullyUploadedFiles.add(file.path);
            this.params.files.remove(file);
        }
    }

    protected final void addAllFilesToSuccessfullyUploadedFiles() {
        Iterator<UploadFile> iterator = this.params.files.iterator();
        while (iterator.hasNext()) {
            UploadFile file = iterator.next();
            if (!this.successfullyUploadedFiles.contains(file.path)) {
                this.successfullyUploadedFiles.add(file.path);
            }
            iterator.remove();
        }
    }

    protected final List<String> getSuccessfullyUploadedFiles() {
        return this.successfullyUploadedFiles;
    }

    private void broadcastError(final Exception exception) {
        Logger.info(LOG_TAG, "Broadcasting error for upload with ID: " + this.params.id + ". " + exception.getMessage());
        final UploadInfo uploadInfo = new UploadInfo(this.params.id, this.startTime, this.uploadedBytes, this.totalBytes, this.attempts - 1, this.successfullyUploadedFiles, UploadTask.pathStringListFrom(this.params.files));
        UploadNotificationConfig notificationConfig = this.params.notificationConfig;
        if (notificationConfig != null && notificationConfig.getError().message != null) {
            this.updateNotification(uploadInfo, notificationConfig.getError());
        }
        BroadcastData data = new BroadcastData().setStatus(BroadcastData.Status.ERROR).setUploadInfo(uploadInfo).setException(exception);
        final UploadStatusDelegate delegate = UploadService.getUploadStatusDelegate(this.params.id);
        if (delegate != null) {
            this.mainThreadHandler.post(new Runnable(){

                @Override
                public void run() {
                    delegate.onError((Context)UploadTask.this.service, uploadInfo, null, exception);
                }
            });
        } else {
            this.service.sendBroadcast(data.getIntent());
        }
        this.service.taskCompleted(this.params.id);
    }

    private void createNotification(UploadInfo uploadInfo) {
        if (this.params.notificationConfig == null || this.params.notificationConfig.getProgress().message == null) {
            return;
        }
        UploadNotificationStatusConfig statusConfig = this.params.notificationConfig.getProgress();
        this.notificationCreationTimeMillis = System.currentTimeMillis();
        NotificationCompat.Builder notification = new NotificationCompat.Builder((Context)this.service, this.params.notificationConfig.getNotificationChannelId()).setWhen(this.notificationCreationTimeMillis).setContentTitle((CharSequence)Placeholders.replace(statusConfig.title, uploadInfo)).setContentText((CharSequence)Placeholders.replace(statusConfig.message, uploadInfo)).setContentIntent(statusConfig.getClickIntent((Context)this.service)).setSmallIcon(statusConfig.iconResourceID).setLargeIcon(statusConfig.largeIcon).setColor(statusConfig.iconColorResourceID).setGroup(UploadService.NAMESPACE).setProgress(100, 0, true).setOngoing(true);
        statusConfig.addActionsToNotificationBuilder(notification);
        Notification builtNotification = notification.build();
        if (this.service.holdForegroundNotification(this.params.id, builtNotification)) {
            this.notificationManager.cancel(this.notificationId);
        } else {
            this.notificationManager.notify(this.notificationId, builtNotification);
        }
    }

    private void updateNotificationProgress(UploadInfo uploadInfo) {
        if (this.params.notificationConfig == null || this.params.notificationConfig.getProgress().message == null) {
            return;
        }
        UploadNotificationStatusConfig statusConfig = this.params.notificationConfig.getProgress();
        NotificationCompat.Builder notification = new NotificationCompat.Builder((Context)this.service, this.params.notificationConfig.getNotificationChannelId()).setWhen(this.notificationCreationTimeMillis).setContentTitle((CharSequence)Placeholders.replace(statusConfig.title, uploadInfo)).setContentText((CharSequence)Placeholders.replace(statusConfig.message, uploadInfo)).setContentIntent(statusConfig.getClickIntent((Context)this.service)).setSmallIcon(statusConfig.iconResourceID).setLargeIcon(statusConfig.largeIcon).setColor(statusConfig.iconColorResourceID).setGroup(UploadService.NAMESPACE).setProgress((int)uploadInfo.getTotalBytes(), (int)uploadInfo.getUploadedBytes(), false).setOngoing(true);
        statusConfig.addActionsToNotificationBuilder(notification);
        Notification builtNotification = notification.build();
        if (this.service.holdForegroundNotification(this.params.id, builtNotification)) {
            this.notificationManager.cancel(this.notificationId);
        } else {
            this.notificationManager.notify(this.notificationId, builtNotification);
        }
    }

    private void setRingtone(NotificationCompat.Builder notification) {
        if (this.params.notificationConfig.isRingToneEnabled() && Build.VERSION.SDK_INT < 26) {
            Uri sound = RingtoneManager.getActualDefaultRingtoneUri((Context)this.service, (int)2);
            notification.setSound(sound);
        }
    }

    private void updateNotification(UploadInfo uploadInfo, UploadNotificationStatusConfig statusConfig) {
        if (this.params.notificationConfig == null) {
            return;
        }
        this.notificationManager.cancel(this.notificationId);
        if (statusConfig.message == null) {
            return;
        }
        if (!statusConfig.autoClear) {
            NotificationCompat.Builder notification = new NotificationCompat.Builder((Context)this.service, this.params.notificationConfig.getNotificationChannelId()).setContentTitle((CharSequence)Placeholders.replace(statusConfig.title, uploadInfo)).setContentText((CharSequence)Placeholders.replace(statusConfig.message, uploadInfo)).setContentIntent(statusConfig.getClickIntent((Context)this.service)).setAutoCancel(statusConfig.clearOnAction).setSmallIcon(statusConfig.iconResourceID).setLargeIcon(statusConfig.largeIcon).setColor(statusConfig.iconColorResourceID).setGroup(UploadService.NAMESPACE).setProgress(0, 0, false).setOngoing(false);
            statusConfig.addActionsToNotificationBuilder(notification);
            this.setRingtone(notification);
            uploadInfo.setNotificationID(this.notificationId + 1);
            this.notificationManager.notify(this.notificationId + 1, notification.build());
        }
    }

    private boolean deleteFile(File fileToDelete) {
        boolean deleted = false;
        try {
            deleted = fileToDelete.delete();
            if (!deleted) {
                Logger.error(LOG_TAG, "Unable to delete: " + fileToDelete.getAbsolutePath());
            } else {
                Logger.info(LOG_TAG, "Successfully deleted: " + fileToDelete.getAbsolutePath());
            }
        }
        catch (Exception exc) {
            Logger.error(LOG_TAG, "Error while deleting: " + fileToDelete.getAbsolutePath() + " Check if you granted: android.permission.WRITE_EXTERNAL_STORAGE", exc);
        }
        return deleted;
    }

    private static List<String> pathStringListFrom(List<UploadFile> files) {
        ArrayList<String> filesLeft = new ArrayList<String>(files.size());
        for (UploadFile f : files) {
            filesLeft.add(f.getPath());
        }
        return filesLeft;
    }

    public final void cancel() {
        this.shouldContinue = false;
    }
}

