/*
 * Decompiled with CFR 0.152.
 */
package net.gotev.uploadservice;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import net.gotev.uploadservice.BroadcastData;
import net.gotev.uploadservice.Logger;
import net.gotev.uploadservice.ServerResponse;
import net.gotev.uploadservice.UploadInfo;
import net.gotev.uploadservice.UploadService;
import net.gotev.uploadservice.UploadStatusDelegate;

public class UploadServiceBroadcastReceiver
extends BroadcastReceiver
implements UploadStatusDelegate {
    public void onReceive(Context context, Intent intent) {
        if (intent == null || !UploadService.getActionBroadcast().equals(intent.getAction())) {
            return;
        }
        BroadcastData data = (BroadcastData)intent.getParcelableExtra("broadcastData");
        if (data == null) {
            Logger.error(this.getClass().getSimpleName(), "Missing intent parameter: broadcastData");
            return;
        }
        UploadInfo uploadInfo = data.getUploadInfo();
        if (!this.shouldAcceptEventFrom(uploadInfo)) {
            return;
        }
        switch (data.getStatus()) {
            case ERROR: {
                this.onError(context, uploadInfo, data.getServerResponse(), data.getException());
                break;
            }
            case COMPLETED: {
                this.onCompleted(context, uploadInfo, data.getServerResponse());
                break;
            }
            case IN_PROGRESS: {
                this.onProgress(context, uploadInfo);
                break;
            }
            case CANCELLED: {
                this.onCancelled(context, uploadInfo);
                break;
            }
        }
    }

    protected boolean shouldAcceptEventFrom(UploadInfo uploadInfo) {
        return true;
    }

    public void register(Context context) {
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction(UploadService.getActionBroadcast());
        context.registerReceiver((BroadcastReceiver)this, intentFilter);
    }

    public void unregister(Context context) {
        context.unregisterReceiver((BroadcastReceiver)this);
    }

    @Override
    public void onProgress(Context context, UploadInfo uploadInfo) {
    }

    @Override
    public void onError(Context context, UploadInfo uploadInfo, ServerResponse serverResponse, Exception exception) {
    }

    @Override
    public void onCompleted(Context context, UploadInfo uploadInfo, ServerResponse serverResponse) {
    }

    @Override
    public void onCancelled(Context context, UploadInfo uploadInfo) {
    }
}

