/*
 * Decompiled with CFR 0.152.
 */
package net.gotev.uploadservice;

import android.content.Context;
import android.content.Intent;
import android.os.Parcelable;
import java.util.UUID;
import net.gotev.uploadservice.Logger;
import net.gotev.uploadservice.UploadNotificationConfig;
import net.gotev.uploadservice.UploadService;
import net.gotev.uploadservice.UploadStatusDelegate;
import net.gotev.uploadservice.UploadTask;
import net.gotev.uploadservice.UploadTaskParameters;

public abstract class UploadRequest<B extends UploadRequest<B>> {
    private static final String LOG_TAG = UploadRequest.class.getSimpleName();
    protected final Context context;
    protected final UploadTaskParameters params = new UploadTaskParameters();
    protected UploadStatusDelegate delegate;

    public UploadRequest(Context context, String uploadId, String serverUrl) throws IllegalArgumentException {
        if (context == null) {
            throw new IllegalArgumentException("Context MUST not be null!");
        }
        if (serverUrl == null || "".equals(serverUrl)) {
            throw new IllegalArgumentException("Server URL cannot be null or empty");
        }
        this.context = context;
        if (uploadId == null || uploadId.isEmpty()) {
            Logger.debug(LOG_TAG, "null or empty upload ID. Generating it");
            this.params.id = UUID.randomUUID().toString();
        } else {
            Logger.debug(LOG_TAG, "setting provided upload ID");
            this.params.id = uploadId;
        }
        this.params.serverUrl = serverUrl;
        Logger.debug(LOG_TAG, "Created new upload request to " + this.params.serverUrl + " with ID: " + this.params.id);
    }

    public String startUpload() {
        UploadService.setUploadStatusDelegate(this.params.id, this.delegate);
        Intent intent = new Intent(this.context, UploadService.class);
        this.initializeIntent(intent);
        intent.setAction(UploadService.getActionUpload());
        this.context.startService(intent);
        return this.params.id;
    }

    protected void initializeIntent(Intent intent) {
        intent.putExtra("taskParameters", (Parcelable)this.params);
        Class<UploadTask> taskClass = this.getTaskClass();
        if (taskClass == null) {
            throw new RuntimeException("The request must specify a task class!");
        }
        intent.putExtra("taskClass", taskClass.getName());
    }

    protected final B self() {
        return (B)this;
    }

    public B setNotificationConfig(UploadNotificationConfig config) {
        this.params.notificationConfig = config;
        return this.self();
    }

    public B setAutoDeleteFilesAfterSuccessfulUpload(boolean autoDeleteFiles) {
        this.params.autoDeleteSuccessfullyUploadedFiles = autoDeleteFiles;
        return this.self();
    }

    public B setMaxRetries(int maxRetries) {
        this.params.setMaxRetries(maxRetries);
        return this.self();
    }

    public B setDelegate(UploadStatusDelegate delegate) {
        this.delegate = delegate;
        return this.self();
    }

    protected abstract Class<? extends UploadTask> getTaskClass();
}

