/*
 * Decompiled with CFR 0.152.
 */
package net.gotev.uploadservice;

import android.app.PendingIntent;
import android.graphics.Bitmap;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import net.gotev.uploadservice.UploadNotificationAction;
import net.gotev.uploadservice.UploadNotificationStatusConfig;

public final class UploadNotificationConfig
implements Parcelable {
    private boolean ringToneEnabled;
    private String notificationChannelId;
    private UploadNotificationStatusConfig progress;
    private UploadNotificationStatusConfig completed;
    private UploadNotificationStatusConfig error;
    private UploadNotificationStatusConfig cancelled;
    public static final Parcelable.Creator<UploadNotificationConfig> CREATOR = new Parcelable.Creator<UploadNotificationConfig>(){

        public UploadNotificationConfig createFromParcel(Parcel source) {
            return new UploadNotificationConfig(source);
        }

        public UploadNotificationConfig[] newArray(int size) {
            return new UploadNotificationConfig[size];
        }
    };

    public UploadNotificationConfig() {
        this.ringToneEnabled = true;
        this.progress = new UploadNotificationStatusConfig();
        this.progress.message = "Uploading at [[UPLOAD_RATE]] ([[PROGRESS]])";
        this.completed = new UploadNotificationStatusConfig();
        this.completed.message = "Upload completed successfully in [[ELAPSED_TIME]]";
        this.error = new UploadNotificationStatusConfig();
        this.error.message = "Error during upload";
        this.cancelled = new UploadNotificationStatusConfig();
        this.cancelled.message = "Upload cancelled";
    }

    public final UploadNotificationConfig setTitleForAllStatuses(String title) {
        this.progress.title = title;
        this.completed.title = title;
        this.error.title = title;
        this.cancelled.title = title;
        return this;
    }

    public final UploadNotificationConfig setIconForAllStatuses(int resourceID) {
        this.progress.iconResourceID = resourceID;
        this.completed.iconResourceID = resourceID;
        this.error.iconResourceID = resourceID;
        this.cancelled.iconResourceID = resourceID;
        return this;
    }

    public final UploadNotificationConfig setIconColorForAllStatuses(int iconColorResourceID) {
        this.progress.iconColorResourceID = iconColorResourceID;
        this.completed.iconColorResourceID = iconColorResourceID;
        this.error.iconColorResourceID = iconColorResourceID;
        this.cancelled.iconColorResourceID = iconColorResourceID;
        return this;
    }

    public final UploadNotificationConfig setLargeIconForAllStatuses(Bitmap largeIcon) {
        this.progress.largeIcon = largeIcon;
        this.completed.largeIcon = largeIcon;
        this.error.largeIcon = largeIcon;
        this.cancelled.largeIcon = largeIcon;
        return this;
    }

    public final UploadNotificationConfig setClickIntentForAllStatuses(PendingIntent clickIntent) {
        this.progress.clickIntent = clickIntent;
        this.completed.clickIntent = clickIntent;
        this.error.clickIntent = clickIntent;
        this.cancelled.clickIntent = clickIntent;
        return this;
    }

    public final UploadNotificationConfig addActionForAllStatuses(UploadNotificationAction action) {
        this.progress.actions.add(action);
        this.completed.actions.add(action);
        this.error.actions.add(action);
        this.cancelled.actions.add(action);
        return this;
    }

    public final UploadNotificationConfig setClearOnActionForAllStatuses(boolean clearOnAction) {
        this.progress.clearOnAction = clearOnAction;
        this.completed.clearOnAction = clearOnAction;
        this.error.clearOnAction = clearOnAction;
        this.cancelled.clearOnAction = clearOnAction;
        return this;
    }

    public final UploadNotificationConfig setRingToneEnabled(Boolean enabled) {
        this.ringToneEnabled = enabled;
        return this;
    }

    public final UploadNotificationConfig setNotificationChannelId(@NonNull String channelId) {
        this.notificationChannelId = channelId;
        return this;
    }

    public boolean isRingToneEnabled() {
        return this.ringToneEnabled;
    }

    public UploadNotificationStatusConfig getProgress() {
        return this.progress;
    }

    public UploadNotificationStatusConfig getCompleted() {
        return this.completed;
    }

    public UploadNotificationStatusConfig getError() {
        return this.error;
    }

    public UploadNotificationStatusConfig getCancelled() {
        return this.cancelled;
    }

    public String getNotificationChannelId() {
        return this.notificationChannelId;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.notificationChannelId);
        dest.writeByte(this.ringToneEnabled ? (byte)1 : 0);
        dest.writeParcelable((Parcelable)this.progress, flags);
        dest.writeParcelable((Parcelable)this.completed, flags);
        dest.writeParcelable((Parcelable)this.error, flags);
        dest.writeParcelable((Parcelable)this.cancelled, flags);
    }

    protected UploadNotificationConfig(Parcel in) {
        this.notificationChannelId = in.readString();
        this.ringToneEnabled = in.readByte() != 0;
        this.progress = (UploadNotificationStatusConfig)in.readParcelable(UploadNotificationStatusConfig.class.getClassLoader());
        this.completed = (UploadNotificationStatusConfig)in.readParcelable(UploadNotificationStatusConfig.class.getClassLoader());
        this.error = (UploadNotificationStatusConfig)in.readParcelable(UploadNotificationStatusConfig.class.getClassLoader());
        this.cancelled = (UploadNotificationStatusConfig)in.readParcelable(UploadNotificationStatusConfig.class.getClassLoader());
    }
}

