/*
 * Decompiled with CFR 0.152.
 */
package net.gotev.uploadservice;

import java.lang.ref.WeakReference;
import net.gotev.uploadservice.DefaultLoggerDelegate;

public class Logger {
    private LogLevel mLogLevel = LogLevel.OFF;
    private static LoggerDelegate mDefaultLogger = new DefaultLoggerDelegate();
    private WeakReference<LoggerDelegate> mDelegate = new WeakReference<LoggerDelegate>(mDefaultLogger);

    private Logger() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetLoggerDelegate() {
        Class<Logger> clazz = Logger.class;
        synchronized (Logger.class) {
            SingletonHolder.instance.mDelegate = new WeakReference<LoggerDelegate>(mDefaultLogger);
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setLoggerDelegate(LoggerDelegate delegate) {
        if (delegate == null) {
            throw new IllegalArgumentException("delegate MUST not be null!");
        }
        Class<Logger> clazz = Logger.class;
        synchronized (Logger.class) {
            SingletonHolder.instance.mDelegate = new WeakReference<LoggerDelegate>(delegate);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setLogLevel(LogLevel level) {
        Class<Logger> clazz = Logger.class;
        synchronized (Logger.class) {
            SingletonHolder.instance.mLogLevel = level;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private static boolean delegateIsDefinedAndLogLevelIsAtLeast(LogLevel level) {
        return SingletonHolder.instance.mDelegate.get() != null && SingletonHolder.instance.mLogLevel.compareTo(level) <= 0;
    }

    public static void error(String tag, String message) {
        if (Logger.delegateIsDefinedAndLogLevelIsAtLeast(LogLevel.ERROR)) {
            ((LoggerDelegate)SingletonHolder.instance.mDelegate.get()).error(tag, message);
        }
    }

    public static void error(String tag, String message, Throwable exception) {
        if (Logger.delegateIsDefinedAndLogLevelIsAtLeast(LogLevel.ERROR)) {
            ((LoggerDelegate)SingletonHolder.instance.mDelegate.get()).error(tag, message, exception);
        }
    }

    public static void info(String tag, String message) {
        if (Logger.delegateIsDefinedAndLogLevelIsAtLeast(LogLevel.INFO)) {
            ((LoggerDelegate)SingletonHolder.instance.mDelegate.get()).info(tag, message);
        }
    }

    public static void debug(String tag, String message) {
        if (Logger.delegateIsDefinedAndLogLevelIsAtLeast(LogLevel.DEBUG)) {
            ((LoggerDelegate)SingletonHolder.instance.mDelegate.get()).debug(tag, message);
        }
    }

    private static class SingletonHolder {
        private static final Logger instance = new Logger();

        private SingletonHolder() {
        }
    }

    public static interface LoggerDelegate {
        public void error(String var1, String var2);

        public void error(String var1, String var2, Throwable var3);

        public void debug(String var1, String var2);

        public void info(String var1, String var2);
    }

    public static enum LogLevel {
        DEBUG,
        INFO,
        ERROR,
        OFF;

    }
}

