/*
 * Decompiled with CFR 0.152.
 */
package net.gotev.uploadservice;

import android.annotation.SuppressLint;
import android.content.Intent;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import net.gotev.uploadservice.HttpUploadTaskParameters;
import net.gotev.uploadservice.Logger;
import net.gotev.uploadservice.ServerResponse;
import net.gotev.uploadservice.UploadService;
import net.gotev.uploadservice.UploadTask;
import net.gotev.uploadservice.http.BodyWriter;
import net.gotev.uploadservice.http.HttpConnection;

public abstract class HttpUploadTask
extends UploadTask
implements HttpConnection.RequestBodyDelegate,
BodyWriter.OnStreamWriteListener {
    private static final String LOG_TAG = HttpUploadTask.class.getSimpleName();
    protected HttpUploadTaskParameters httpParams = null;
    private HttpConnection connection;

    @Override
    protected void init(UploadService service, Intent intent) throws IOException {
        super.init(service, intent);
        this.httpParams = (HttpUploadTaskParameters)intent.getParcelableExtra("httpTaskParameters");
    }

    @Override
    @SuppressLint(value={"NewApi"})
    protected void upload() throws Exception {
        Logger.debug(LOG_TAG, "Starting upload task with ID " + this.params.id);
        try {
            this.getSuccessfullyUploadedFiles().clear();
            this.uploadedBytes = 0L;
            this.totalBytes = this.getBodyLength();
            if (this.httpParams.isCustomUserAgentDefined()) {
                this.httpParams.addHeader("User-Agent", this.httpParams.customUserAgent);
            } else {
                this.httpParams.addHeader("User-Agent", "AndroidUploadService/3.4.1");
            }
            this.connection = UploadService.HTTP_STACK.createNewConnection(this.httpParams.method, this.params.serverUrl).setHeaders(this.httpParams.getRequestHeaders()).setTotalBodyBytes(this.totalBytes, this.httpParams.usesFixedLengthStreamingMode);
            ServerResponse response = this.connection.getResponse(this);
            Logger.debug(LOG_TAG, "Server responded with HTTP " + response.getHttpCode() + " to upload with ID: " + this.params.id);
            if (this.shouldContinue) {
                this.broadcastCompleted(response);
            }
        }
        finally {
            if (this.connection != null) {
                this.connection.close();
            }
        }
    }

    protected abstract long getBodyLength() throws UnsupportedEncodingException;

    @Override
    public boolean shouldContinueWriting() {
        return this.shouldContinue;
    }

    @Override
    public void onBytesWritten(int bytesWritten) {
        this.uploadedBytes += (long)bytesWritten;
        this.broadcastProgress(this.uploadedBytes, this.totalBytes);
    }
}

