/*
 * Decompiled with CFR 0.152.
 */
package net.gotev.uploadservice;

import android.content.Intent;
import android.os.Parcel;
import android.os.Parcelable;
import java.io.Serializable;
import net.gotev.uploadservice.Logger;
import net.gotev.uploadservice.ServerResponse;
import net.gotev.uploadservice.UploadInfo;
import net.gotev.uploadservice.UploadService;

class BroadcastData
implements Parcelable {
    private Status status;
    private Exception exception;
    private UploadInfo uploadInfo;
    private ServerResponse serverResponse;
    public static final Parcelable.Creator<BroadcastData> CREATOR = new Parcelable.Creator<BroadcastData>(){

        public BroadcastData createFromParcel(Parcel in) {
            return new BroadcastData(in);
        }

        public BroadcastData[] newArray(int size) {
            return new BroadcastData[size];
        }
    };

    public BroadcastData() {
    }

    public Intent getIntent() {
        Intent intent = new Intent(UploadService.getActionBroadcast());
        intent.setPackage(UploadService.NAMESPACE);
        intent.putExtra("broadcastData", (Parcelable)this);
        return intent;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        parcel.writeInt(this.status.ordinal());
        parcel.writeSerializable((Serializable)this.exception);
        parcel.writeParcelable((Parcelable)this.uploadInfo, flags);
        parcel.writeParcelable((Parcelable)this.serverResponse, flags);
    }

    private BroadcastData(Parcel in) {
        this.status = Status.values()[in.readInt()];
        this.exception = (Exception)in.readSerializable();
        this.uploadInfo = (UploadInfo)in.readParcelable(UploadInfo.class.getClassLoader());
        this.serverResponse = (ServerResponse)in.readParcelable(ServerResponse.class.getClassLoader());
    }

    public int describeContents() {
        return 0;
    }

    public Status getStatus() {
        if (this.status == null) {
            Logger.error(this.getClass().getSimpleName(), "Status not defined! Returning " + (Object)((Object)Status.CANCELLED));
            return Status.CANCELLED;
        }
        return this.status;
    }

    public BroadcastData setStatus(Status status) {
        this.status = status;
        return this;
    }

    public Exception getException() {
        return this.exception;
    }

    public BroadcastData setException(Exception exception) {
        this.exception = exception;
        return this;
    }

    public UploadInfo getUploadInfo() {
        return this.uploadInfo;
    }

    public BroadcastData setUploadInfo(UploadInfo uploadInfo) {
        this.uploadInfo = uploadInfo;
        return this;
    }

    public ServerResponse getServerResponse() {
        return this.serverResponse;
    }

    public BroadcastData setServerResponse(ServerResponse serverResponse) {
        this.serverResponse = serverResponse;
        return this;
    }

    public static enum Status {
        IN_PROGRESS,
        ERROR,
        COMPLETED,
        CANCELLED;

    }
}

