/*
 * Decompiled with CFR 0.152.
 */
package net.gotev.uploadservice;

import android.content.Context;
import java.io.FileNotFoundException;
import java.net.MalformedURLException;
import java.util.List;
import net.gotev.uploadservice.BinaryUploadTask;
import net.gotev.uploadservice.HttpUploadRequest;
import net.gotev.uploadservice.Logger;
import net.gotev.uploadservice.UploadFile;
import net.gotev.uploadservice.UploadTask;

public class BinaryUploadRequest
extends HttpUploadRequest<BinaryUploadRequest> {
    public BinaryUploadRequest(Context context, String uploadId, String serverUrl) throws IllegalArgumentException, MalformedURLException {
        super(context, uploadId, serverUrl);
    }

    public BinaryUploadRequest(Context context, String serverUrl) throws MalformedURLException, IllegalArgumentException {
        this(context, null, serverUrl);
    }

    @Override
    protected Class<? extends UploadTask> getTaskClass() {
        return BinaryUploadTask.class;
    }

    public BinaryUploadRequest setFileToUpload(String path) throws FileNotFoundException {
        this.params.files.clear();
        this.params.files.add(new UploadFile(path));
        return this;
    }

    @Override
    public BinaryUploadRequest addParameter(String paramName, String paramValue) {
        this.logDoesNotSupportParameters();
        return this;
    }

    @Override
    public BinaryUploadRequest addArrayParameter(String paramName, String ... array) {
        this.logDoesNotSupportParameters();
        return this;
    }

    @Override
    public BinaryUploadRequest addArrayParameter(String paramName, List<String> list) {
        this.logDoesNotSupportParameters();
        return this;
    }

    @Override
    public String startUpload() {
        if (this.params.files.isEmpty()) {
            throw new IllegalArgumentException("Set the file to be used in the request body first!");
        }
        return super.startUpload();
    }

    private void logDoesNotSupportParameters() {
        Logger.error(this.getClass().getSimpleName(), "This upload method does not support adding parameters");
    }
}

