/*
 * Decompiled with CFR 0.152.
 */
package net.gjerull.etherpad.client;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import net.gjerull.etherpad.client.EPLiteConnection;

public class EPLiteClient {
    private static final String DEFAULT_API_VERSION = "1.2.13";
    private static final String DEFAULT_ENCODING = "UTF-8";
    private final EPLiteConnection connection;

    public EPLiteClient(String url, String apiKey) {
        this.connection = new EPLiteConnection(url, apiKey, DEFAULT_API_VERSION, DEFAULT_ENCODING);
    }

    public EPLiteClient(String url, String apiKey, String apiVersion, String encoding) {
        this.connection = new EPLiteConnection(url, apiKey, apiVersion, encoding);
    }

    public Map createGroup() {
        return this.connection.post("createGroup");
    }

    public Map createGroupIfNotExistsFor(String groupMapper) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("groupMapper", groupMapper);
        return this.connection.post("createGroupIfNotExistsFor", args);
    }

    public void deleteGroup(String groupID) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("groupID", groupID);
        this.connection.post("deleteGroup", args);
    }

    public Map listPads(String groupID) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("groupID", groupID);
        return this.connection.get("listPads", args);
    }

    public Map createGroupPad(String groupID, String padName) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("groupID", groupID);
        args.put("padName", padName);
        return this.connection.post("createGroupPad", args);
    }

    public Map createGroupPad(String groupID, String padName, String text) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("groupID", groupID);
        args.put("padName", padName);
        args.put("text", text);
        return this.connection.post("createGroupPad", args);
    }

    public Map listAllGroups() {
        return this.connection.get("listAllGroups");
    }

    public Map createAuthor() {
        return this.connection.get("createAuthor");
    }

    public Map createAuthor(String name) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("name", name);
        return this.connection.post("createAuthor", args);
    }

    public Map createAuthorIfNotExistsFor(String authorMapper) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("authorMapper", authorMapper);
        return this.connection.post("createAuthorIfNotExistsFor", args);
    }

    public Map createAuthorIfNotExistsFor(String authorMapper, String name) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("authorMapper", authorMapper);
        args.put("name", name);
        return this.connection.post("createAuthorIfNotExistsFor", args);
    }

    public Map listPadsOfAuthor(String authorId) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("authorID", authorId);
        return this.connection.get("listPadsOfAuthor", args);
    }

    public String getAuthorName(String authorId) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("authorID", authorId);
        return (String)this.connection.getObject("getAuthorName", args);
    }

    public Map createSession(String groupID, String authorID, long validUntil) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("groupID", groupID);
        args.put("authorID", authorID);
        args.put("validUntil", String.valueOf(validUntil));
        return this.connection.post("createSession", args);
    }

    public Map createSession(String groupID, String authorID, int sessionDuration) {
        long inNHours = (new Date().getTime() + (long)sessionDuration * 60L * 60L * 1000L) / 1000L;
        return this.createSession(groupID, authorID, inNHours);
    }

    public Map createSession(String groupID, String authorID, Date validUntil) {
        long seconds = validUntil.getTime() / 1000L;
        return this.createSession(groupID, authorID, seconds);
    }

    public void deleteSession(String sessionID) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("sessionID", sessionID);
        this.connection.post("deleteSession", args);
    }

    public Map getSessionInfo(String sessionID) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("sessionID", sessionID);
        return this.connection.get("getSessionInfo", args);
    }

    public Map listSessionsOfGroup(String groupID) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("groupID", groupID);
        return this.connection.get("listSessionsOfGroup", args);
    }

    public Map listSessionsOfAuthor(String authorID) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("authorID", authorID);
        return this.connection.get("listSessionsOfAuthor", args);
    }

    public Map getText(String padId) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("padID", padId);
        return this.connection.get("getText", args);
    }

    public Map getText(String padId, long rev) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("padID", padId);
        args.put("rev", rev);
        return this.connection.get("getText", args);
    }

    public void setText(String padId, String text) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("padID", padId);
        args.put("text", text);
        this.connection.post("setText", args);
    }

    public void appendText(String padId, String text) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("padID", padId);
        args.put("text", text);
        this.connection.post("appendText", args);
    }

    public Map getHTML(String padId) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("padID", padId);
        return this.connection.get("getHTML", args);
    }

    public Map getHTML(String padId, long rev) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("padID", padId);
        args.put("rev", rev);
        return this.connection.get("getHTML", args);
    }

    public void setHTML(String padId, String html) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("padID", padId);
        args.put("html", html);
        this.connection.post("setHTML", args);
    }

    public Map getAttributePool(String padId) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("padID", padId);
        return this.connection.get("getAttributePool", args);
    }

    public String getRevisionChangeset(String padId) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("padID", padId);
        return (String)this.connection.getObject("getRevisionChangeset", args);
    }

    public String getRevisionChangeset(String padId, long rev) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("padID", padId);
        args.put("rev", rev);
        return (String)this.connection.getObject("getRevisionChangeset", args);
    }

    public Map createDiffHTML(String padId, long startRev, long endRev) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("padID", padId);
        args.put("startRev", startRev);
        args.put("endRev", endRev);
        return this.connection.get("createDiffHTML", args);
    }

    public Map getChatHistory(String padId) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("padID", padId);
        return this.connection.get("getChatHistory", args);
    }

    public Map getChatHistory(String padId, long start, long end) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("padID", padId);
        args.put("start", start);
        args.put("end", end);
        return this.connection.get("getChatHistory", args);
    }

    public Map getChatHead(String padId) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("padID", padId);
        return this.connection.get("getChatHead", args);
    }

    public Map appendChatMessage(String padId, String text, String authorId) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("padID", padId);
        args.put("text", text);
        args.put("authorID", authorId);
        return this.connection.post("appendChatMessage", args);
    }

    public Map appendChatMessage(String padId, String text, String authorId, long time) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("padID", padId);
        args.put("text", text);
        args.put("authorID", authorId);
        args.put("time", time);
        return this.connection.post("appendChatMessage", args);
    }

    public Map listAllPads() {
        return this.connection.get("listAllPads");
    }

    public void createPad(String padId) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("padID", padId);
        this.connection.post("createPad", args);
    }

    public void createPad(String padId, String text) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("padID", padId);
        args.put("text", text);
        this.connection.post("createPad", args);
    }

    public Map getRevisionsCount(String padId) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("padID", padId);
        return this.connection.get("getRevisionsCount", args);
    }

    public Map getSavedRevisionsCount(String padId) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("padID", padId);
        return this.connection.get("getSavedRevisionsCount", args);
    }

    public Map listSavedRevisions(String padId) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("padID", padId);
        return this.connection.get("listSavedRevisions", args);
    }

    public void saveRevision(String padId) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("padID", padId);
        this.connection.post("saveRevision", args);
    }

    public void saveRevision(String padId, long rev) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("padID", padId);
        args.put("rev", rev);
        this.connection.post("saveRevision", args);
    }

    public Map padUsersCount(String padId) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("padID", padId);
        return this.connection.get("padUsersCount", args);
    }

    public Map padUsers(String padId) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("padID", padId);
        return this.connection.get("padUsers", args);
    }

    public void deletePad(String padId) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("padID", padId);
        this.connection.post("deletePad", args);
    }

    public void copyPad(String sourcePadId, String destinationPadId) {
        this.copyPad(sourcePadId, destinationPadId, false);
    }

    public void copyPad(String sourcePadId, String destinationPadId, boolean force) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("sourceID", sourcePadId);
        args.put("destinationID", destinationPadId);
        args.put("force", force);
        this.connection.post("copyPad", args);
    }

    public void movePad(String sourcePadId, String destinationPadId) {
        this.copyPad(sourcePadId, destinationPadId, false);
    }

    public void movePad(String sourcePadId, String destinationPadId, boolean force) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("sourceID", sourcePadId);
        args.put("destinationID", destinationPadId);
        args.put("force", force);
        this.connection.post("movePad", args);
    }

    public Map getReadOnlyID(String padId) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("padID", padId);
        return this.connection.get("getReadOnlyID", args);
    }

    public Map getPadID(String readOnlyPadId) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("roID", readOnlyPadId);
        return this.connection.get("getPadID", args);
    }

    public void setPublicStatus(String padId, Boolean publicStatus) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("padID", padId);
        args.put("publicStatus", publicStatus);
        this.connection.post("setPublicStatus", args);
    }

    public Map getPublicStatus(String padId) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("padID", padId);
        return this.connection.get("getPublicStatus", args);
    }

    public void setPassword(String padId, String password) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("padID", padId);
        args.put("password", password);
        this.connection.post("setPassword", args);
    }

    public Map isPasswordProtected(String padId) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("padID", padId);
        return this.connection.get("isPasswordProtected", args);
    }

    public Map listAuthorsOfPad(String padId) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("padID", padId);
        return this.connection.get("listAuthorsOfPad", args);
    }

    public Map getLastEdited(String padId) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("padID", padId);
        return this.connection.get("getLastEdited", args);
    }

    public void sendClientsMessage(String padId, String msg) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("padID", padId);
        args.put("msg", msg);
        this.connection.post("sendClientsMessage", args);
    }

    public void checkToken() {
        this.connection.get("checkToken");
    }

    public boolean isSecure() {
        return this.connection.uri.getPort() == 443;
    }
}

