/*
 * Decompiled with CFR 0.152.
 */
package com.kelin.mvvmlight.messenger;

import com.kelin.mvvmlight.command.consumer.Consumer0;
import com.kelin.mvvmlight.messenger.WeakAction;
import io.reactivex.functions.Consumer;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Messenger {
    private static Messenger defaultInstance;
    private HashMap<Type, List<WeakActionAndToken>> recipientsOfSubclassesAction;
    private HashMap<Type, List<WeakActionAndToken>> recipientsStrictAction;

    public static Messenger getDefault() {
        if (defaultInstance == null) {
            defaultInstance = new Messenger();
        }
        return defaultInstance;
    }

    public static void overrideDefault(Messenger newMessenger) {
        defaultInstance = newMessenger;
    }

    public static void reset() {
        defaultInstance = null;
    }

    public void register(Object recipient, Consumer0 consumer) {
        this.register(recipient, null, false, consumer);
    }

    public void register(Object recipient, boolean receiveDerivedMessagesToo, Consumer0 consumer) {
        this.register(recipient, null, receiveDerivedMessagesToo, consumer);
    }

    public void register(Object recipient, Object token, Consumer0 consumer) {
        this.register(recipient, token, false, consumer);
    }

    public void register(Object recipient, Object token, boolean receiveDerivedMessagesToo, Consumer0 consumer) {
        List<Object> list;
        HashMap<Type, List<WeakActionAndToken>> recipients;
        Class<NotMsgType> messageType = NotMsgType.class;
        if (receiveDerivedMessagesToo) {
            if (this.recipientsOfSubclassesAction == null) {
                this.recipientsOfSubclassesAction = new HashMap();
            }
            recipients = this.recipientsOfSubclassesAction;
        } else {
            if (this.recipientsStrictAction == null) {
                this.recipientsStrictAction = new HashMap();
            }
            recipients = this.recipientsStrictAction;
        }
        if (!recipients.containsKey(messageType)) {
            list = new ArrayList();
            recipients.put((Type)((Object)messageType), (List<WeakActionAndToken>)list);
        } else {
            list = recipients.get(messageType);
        }
        WeakAction weakAction = new WeakAction(recipient, consumer);
        WeakActionAndToken item = new WeakActionAndToken(weakAction, token);
        list.add(item);
        this.cleanup();
    }

    public <T> void register(Object recipient, Class<T> tClass, Consumer<T> consumer) {
        this.register(recipient, null, false, consumer, tClass);
    }

    public <T> void register(Object recipient, boolean receiveDerivedMessagesToo, Class<T> tClass, Consumer<T> consumer) {
        this.register(recipient, null, receiveDerivedMessagesToo, consumer, tClass);
    }

    public <T> void register(Object recipient, Object token, Class<T> tClass, Consumer<T> consumer) {
        this.register(recipient, token, false, consumer, tClass);
    }

    public <T> void register(Object recipient, Object token, boolean receiveDerivedMessagesToo, Consumer<T> consumer, Class<T> tClass) {
        List<Object> list;
        HashMap<Type, List<WeakActionAndToken>> recipients;
        Class<T> messageType = tClass;
        if (receiveDerivedMessagesToo) {
            if (this.recipientsOfSubclassesAction == null) {
                this.recipientsOfSubclassesAction = new HashMap();
            }
            recipients = this.recipientsOfSubclassesAction;
        } else {
            if (this.recipientsStrictAction == null) {
                this.recipientsStrictAction = new HashMap();
            }
            recipients = this.recipientsStrictAction;
        }
        if (!recipients.containsKey(messageType)) {
            list = new ArrayList();
            recipients.put(messageType, list);
        } else {
            list = recipients.get(messageType);
        }
        WeakAction<T> weakAction = new WeakAction<T>(recipient, consumer);
        WeakActionAndToken item = new WeakActionAndToken(weakAction, token);
        list.add(item);
        this.cleanup();
    }

    private void cleanup() {
        Messenger.cleanupList(this.recipientsOfSubclassesAction);
        Messenger.cleanupList(this.recipientsStrictAction);
    }

    public void sendNoMsg(Object token) {
        this.sendToTargetOrType(null, token);
    }

    public void sendNoMsgToTarget(Object target) {
        this.sendToTargetOrType(target.getClass(), null);
    }

    public void sendNoMsgToTargetWithToken(Object token, Object target) {
        this.sendToTargetOrType(target.getClass(), token);
    }

    public <T> void send(T message) {
        this.sendToTargetOrType(message, null, null);
    }

    public <T> void send(T message, Object token) {
        this.sendToTargetOrType(message, null, token);
    }

    public <T, R> void sendToTarget(T message, R target) {
        this.sendToTargetOrType(message, target.getClass(), null);
    }

    public void unregister(Object recipient) {
        Messenger.unregisterFromLists(recipient, this.recipientsOfSubclassesAction);
        Messenger.unregisterFromLists(recipient, this.recipientsStrictAction);
        this.cleanup();
    }

    public <T> void unregister(Object recipient, Object token) {
        Messenger.unregisterFromLists(recipient, token, null, this.recipientsStrictAction);
        Messenger.unregisterFromLists(recipient, token, null, this.recipientsOfSubclassesAction);
        this.cleanup();
    }

    private static <T> void sendToList(T message, Collection<WeakActionAndToken> list, Type messageTargetType, Object token) {
        if (list != null) {
            ArrayList<WeakActionAndToken> listClone = new ArrayList<WeakActionAndToken>();
            listClone.addAll(list);
            for (WeakActionAndToken item : listClone) {
                WeakAction executeAction = item.getAction();
                if (executeAction == null || !item.getAction().isLive() || item.getAction().getTarget() == null || messageTargetType != null && item.getAction().getTarget().getClass() != messageTargetType && !Messenger.classImplements(item.getAction().getTarget().getClass(), messageTargetType) || (item.getToken() != null || token != null) && (item.getToken() == null || !item.getToken().equals(token))) continue;
                executeAction.execute(message);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void unregisterFromLists(Object recipient, HashMap<Type, List<WeakActionAndToken>> lists) {
        if (recipient == null || lists == null || lists.size() == 0) {
            return;
        }
        HashMap<Type, List<WeakActionAndToken>> hashMap = lists;
        synchronized (hashMap) {
            for (Type messageType : lists.keySet()) {
                for (WeakActionAndToken item : lists.get(messageType)) {
                    WeakAction weakAction = item.getAction();
                    if (weakAction == null || recipient != weakAction.getTarget()) continue;
                    weakAction.markForDeletion();
                }
            }
        }
        Messenger.cleanupList(lists);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> void unregisterFromLists(Object recipient, Consumer<T> consumer, HashMap<Type, List<WeakActionAndToken>> lists, Class<T> tClass) {
        Class<T> messageType = tClass;
        if (recipient == null || lists == null || lists.size() == 0 || !lists.containsKey(messageType)) {
            return;
        }
        HashMap<Type, List<WeakActionAndToken>> hashMap = lists;
        synchronized (hashMap) {
            for (WeakActionAndToken item : lists.get(messageType)) {
                WeakAction weakActionCasted = item.getAction();
                if (weakActionCasted == null || recipient != weakActionCasted.getTarget() || consumer != null && consumer != weakActionCasted.getConsumer()) continue;
                item.getAction().markForDeletion();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void unregisterFromLists(Object recipient, Consumer0 consumer0, HashMap<Type, List<WeakActionAndToken>> lists) {
        Class<NotMsgType> messageType = NotMsgType.class;
        if (recipient == null || lists == null || lists.size() == 0 || !lists.containsKey(messageType)) {
            return;
        }
        HashMap<Type, List<WeakActionAndToken>> hashMap = lists;
        synchronized (hashMap) {
            for (WeakActionAndToken item : lists.get(messageType)) {
                WeakAction weakActionCasted = item.getAction();
                if (weakActionCasted == null || recipient != weakActionCasted.getTarget() || consumer0 != null && consumer0 != weakActionCasted.getConsumer0()) continue;
                item.getAction().markForDeletion();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> void unregisterFromLists(Object recipient, Object token, Consumer<T> consumer, HashMap<Type, List<WeakActionAndToken>> lists, Class<T> tClass) {
        Class<T> messageType = tClass;
        if (recipient == null || lists == null || lists.size() == 0 || !lists.containsKey(messageType)) {
            return;
        }
        HashMap<Type, List<WeakActionAndToken>> hashMap = lists;
        synchronized (hashMap) {
            for (WeakActionAndToken item : lists.get(messageType)) {
                WeakAction weakActionCasted = item.getAction();
                if (weakActionCasted == null || recipient != weakActionCasted.getTarget() || consumer != null && consumer != weakActionCasted.getConsumer() || token != null && !token.equals(item.getToken())) continue;
                item.getAction().markForDeletion();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void unregisterFromLists(Object recipient, Object token, Consumer0 consumer0, HashMap<Type, List<WeakActionAndToken>> lists) {
        Class<NotMsgType> messageType = NotMsgType.class;
        if (recipient == null || lists == null || lists.size() == 0 || !lists.containsKey(messageType)) {
            return;
        }
        HashMap<Type, List<WeakActionAndToken>> hashMap = lists;
        synchronized (hashMap) {
            for (WeakActionAndToken item : lists.get(messageType)) {
                WeakAction weakActionCasted = item.getAction();
                if (weakActionCasted == null || recipient != weakActionCasted.getTarget() || consumer0 != null && consumer0 != weakActionCasted.getConsumer0() || token != null && !token.equals(item.getToken())) continue;
                item.getAction().markForDeletion();
            }
        }
    }

    private static boolean classImplements(Type instanceType, Type interfaceType) {
        Class<?>[] interfaces;
        if (interfaceType == null || instanceType == null) {
            return false;
        }
        for (Class<?> currentInterface : interfaces = ((Class)instanceType).getInterfaces()) {
            if (currentInterface != interfaceType) continue;
            return true;
        }
        return false;
    }

    private static void cleanupList(HashMap<Type, List<WeakActionAndToken>> lists) {
        if (lists == null) {
            return;
        }
        for (Map.Entry<Type, List<WeakActionAndToken>> key : lists.entrySet()) {
            List<WeakActionAndToken> itemList = lists.get(key);
            if (itemList == null) continue;
            for (WeakActionAndToken item : itemList) {
                if (item.getAction() != null && item.getAction().isLive()) continue;
                itemList.remove(item);
            }
            if (itemList.size() != 0) continue;
            lists.remove(key);
        }
    }

    private void sendToTargetOrType(Type messageTargetType, Object token) {
        Class<NotMsgType> messageType = NotMsgType.class;
        if (this.recipientsOfSubclassesAction != null) {
            ArrayList<Type> listClone = new ArrayList<Type>();
            listClone.addAll(this.recipientsOfSubclassesAction.keySet());
            for (Type type : listClone) {
                List<WeakActionAndToken> list = null;
                if (messageType == type || ((Class)type).isAssignableFrom(messageType) || Messenger.classImplements(messageType, type)) {
                    list = this.recipientsOfSubclassesAction.get(type);
                }
                Messenger.sendToList(list, messageTargetType, token);
            }
        }
        if (this.recipientsStrictAction != null && this.recipientsStrictAction.containsKey(messageType)) {
            List<WeakActionAndToken> list = this.recipientsStrictAction.get(messageType);
            Messenger.sendToList(list, messageTargetType, token);
        }
        this.cleanup();
    }

    private static void sendToList(Collection<WeakActionAndToken> list, Type messageTargetType, Object token) {
        if (list != null) {
            ArrayList<WeakActionAndToken> listClone = new ArrayList<WeakActionAndToken>();
            listClone.addAll(list);
            for (WeakActionAndToken item : listClone) {
                WeakAction executeAction = item.getAction();
                if (executeAction == null || !item.getAction().isLive() || item.getAction().getTarget() == null || messageTargetType != null && item.getAction().getTarget().getClass() != messageTargetType && !Messenger.classImplements(item.getAction().getTarget().getClass(), messageTargetType) || (item.getToken() != null || token != null) && (item.getToken() == null || !item.getToken().equals(token))) continue;
                executeAction.execute();
            }
        }
    }

    private <T> void sendToTargetOrType(T message, Type messageTargetType, Object token) {
        Class<?> messageType = message.getClass();
        if (this.recipientsOfSubclassesAction != null) {
            ArrayList<Type> listClone = new ArrayList<Type>();
            listClone.addAll(this.recipientsOfSubclassesAction.keySet());
            for (Type type : listClone) {
                List<WeakActionAndToken> list = null;
                if (messageType == type || ((Class)type).isAssignableFrom(messageType) || Messenger.classImplements(messageType, type)) {
                    list = this.recipientsOfSubclassesAction.get(type);
                }
                Messenger.sendToList(message, list, messageTargetType, token);
            }
        }
        if (this.recipientsStrictAction != null && this.recipientsStrictAction.containsKey(messageType)) {
            List<WeakActionAndToken> list = this.recipientsStrictAction.get(messageType);
            Messenger.sendToList(message, list, messageTargetType, token);
        }
        this.cleanup();
    }

    public static class NotMsgType {
    }

    private class WeakActionAndToken {
        private WeakAction action;
        private Object token;

        public WeakActionAndToken(WeakAction action, Object token) {
            this.action = action;
            this.token = token;
        }

        public WeakAction getAction() {
            return this.action;
        }

        public void setAction(WeakAction action) {
            this.action = action;
        }

        public Object getToken() {
            return this.token;
        }

        public void setToken(Object token) {
            this.token = token;
        }
    }
}

