/*
 * Decompiled with CFR 0.152.
 */
package com.kelin.mvvmlight.bindingadapter.viewpager;

import android.databinding.BindingAdapter;
import android.support.v4.view.ViewPager;
import com.kelin.mvvmlight.command.ReplyCommand;

public class ViewBindingAdapter {
    @BindingAdapter(value={"onPageScrolledCommand", "onPageSelectedCommand", "onPageScrollStateChangedCommand"}, requireAll=false)
    public static void onScrollChangeCommand(ViewPager viewPager, final ReplyCommand<ViewPagerDataWrapper> onPageScrolledCommand, final ReplyCommand<Integer> onPageSelectedCommand, final ReplyCommand<Integer> onPageScrollStateChangedCommand) {
        viewPager.addOnPageChangeListener(new ViewPager.OnPageChangeListener(){
            private int state;

            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
                if (onPageScrolledCommand != null) {
                    onPageScrolledCommand.execute(new ViewPagerDataWrapper(position, positionOffset, positionOffsetPixels, this.state));
                }
            }

            public void onPageSelected(int position) {
                if (onPageSelectedCommand != null) {
                    onPageSelectedCommand.execute(position);
                }
            }

            public void onPageScrollStateChanged(int state) {
                this.state = state;
                if (onPageScrollStateChangedCommand != null) {
                    onPageScrollStateChangedCommand.execute(state);
                }
            }
        });
    }

    public static class ViewPagerDataWrapper {
        public float positionOffset;
        public float position;
        public int positionOffsetPixels;
        public int state;

        public ViewPagerDataWrapper(float position, float positionOffset, int positionOffsetPixels, int state) {
            this.positionOffset = positionOffset;
            this.position = position;
            this.positionOffsetPixels = positionOffsetPixels;
            this.state = state;
        }
    }
}

