/*
 * Decompiled with CFR 0.152.
 */
package com.kelin.mvvmlight.bindingadapter.recyclerview;

import android.databinding.BindingAdapter;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import com.kelin.mvvmlight.bindingadapter.recyclerview.ViewBindingAdapter$OnScrollListener$$Lambda$1;
import com.kelin.mvvmlight.command.ReplyCommand;
import io.reactivex.subjects.PublishSubject;
import java.util.concurrent.TimeUnit;

public class ViewBindingAdapter {
    @BindingAdapter(value={"onScrollChangeCommand", "onScrollStateChangedCommand"}, requireAll=false)
    public static void onScrollChangeCommand(RecyclerView recyclerView, final ReplyCommand<ScrollDataWrapper> onScrollChangeCommand, final ReplyCommand<Integer> onScrollStateChangedCommand) {
        recyclerView.addOnScrollListener(new RecyclerView.OnScrollListener(){
            private int state;

            public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
                super.onScrolled(recyclerView, dx, dy);
                if (onScrollChangeCommand != null) {
                    onScrollChangeCommand.execute(new ScrollDataWrapper(dx, dy, this.state));
                }
            }

            public void onScrollStateChanged(RecyclerView recyclerView, int newState) {
                super.onScrollStateChanged(recyclerView, newState);
                this.state = newState;
                if (onScrollStateChangedCommand != null) {
                    onScrollChangeCommand.equals(newState);
                }
            }
        });
    }

    @BindingAdapter(value={"onLoadMoreCommand"})
    public static void onLoadMoreCommand(RecyclerView recyclerView, ReplyCommand<Integer> onLoadMoreCommand) {
        OnScrollListener listener = new OnScrollListener(onLoadMoreCommand);
        recyclerView.addOnScrollListener((RecyclerView.OnScrollListener)listener);
    }

    public static class ScrollDataWrapper {
        public float scrollX;
        public float scrollY;
        public int state;

        public ScrollDataWrapper(float scrollX, float scrollY, int state) {
            this.scrollX = scrollX;
            this.scrollY = scrollY;
            this.state = state;
        }
    }

    public static class OnScrollListener
    extends RecyclerView.OnScrollListener {
        private PublishSubject<Integer> methodInvoke = PublishSubject.create();
        private ReplyCommand<Integer> onLoadMoreCommand;

        public OnScrollListener(ReplyCommand<Integer> onLoadMoreCommand) {
            this.onLoadMoreCommand = onLoadMoreCommand;
            this.methodInvoke.throttleFirst(1L, TimeUnit.SECONDS).subscribe(ViewBindingAdapter$OnScrollListener$$Lambda$1.lambdaFactory$(onLoadMoreCommand));
        }

        public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
            LinearLayoutManager layoutManager = (LinearLayoutManager)recyclerView.getLayoutManager();
            int visibleItemCount = layoutManager.getChildCount();
            int totalItemCount = layoutManager.getItemCount();
            int pastVisiblesItems = layoutManager.findFirstVisibleItemPosition();
            if (visibleItemCount + pastVisiblesItems >= totalItemCount && this.onLoadMoreCommand != null) {
                this.methodInvoke.onNext((Object)recyclerView.getAdapter().getItemCount());
            }
        }

        public void onScrollStateChanged(RecyclerView recyclerView, int newState) {
            super.onScrollStateChanged(recyclerView, newState);
        }

        static /* synthetic */ void access$lambda$0(ReplyCommand replyCommand, Integer n) {
            replyCommand.execute(n);
        }
    }
}

