/*
 * Decompiled with CFR 0.152.
 */
package com.kelin.mvvmlight.bindingadapter.listview;

import android.databinding.BindingAdapter;
import android.view.View;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.ListView;
import com.kelin.mvvmlight.bindingadapter.listview.ViewBindingAdapter$OnScrollListener$$Lambda$1;
import com.kelin.mvvmlight.command.ReplyCommand;
import io.reactivex.subjects.PublishSubject;
import java.util.concurrent.TimeUnit;

public final class ViewBindingAdapter {
    @BindingAdapter(value={"onScrollChangeCommand", "onScrollStateChangedCommand"}, requireAll=false)
    public static void onScrollChangeCommand(ListView listView, final ReplyCommand<ListViewScrollDataWrapper> onScrollChangeCommand, final ReplyCommand<Integer> onScrollStateChangedCommand) {
        listView.setOnScrollListener(new AbsListView.OnScrollListener(){
            private int scrollState;

            public void onScrollStateChanged(AbsListView view, int scrollState) {
                this.scrollState = scrollState;
                if (onScrollStateChangedCommand != null) {
                    onScrollChangeCommand.equals(scrollState);
                }
            }

            public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
                if (onScrollChangeCommand != null) {
                    onScrollChangeCommand.execute(new ListViewScrollDataWrapper(this.scrollState, firstVisibleItem, visibleItemCount, totalItemCount));
                }
            }
        });
    }

    @BindingAdapter(value={"onItemClickCommand"}, requireAll=false)
    public static void onItemClickCommand(ListView listView, final ReplyCommand<Integer> onItemClickCommand) {
        listView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id) {
                if (onItemClickCommand != null) {
                    onItemClickCommand.execute(position);
                }
            }
        });
    }

    @BindingAdapter(value={"onLoadMoreCommand"})
    public static void onLoadMoreCommand(ListView listView, ReplyCommand<Integer> onLoadMoreCommand) {
        listView.setOnScrollListener((AbsListView.OnScrollListener)new OnScrollListener(listView, onLoadMoreCommand));
    }

    public static class ListViewScrollDataWrapper {
        public int firstVisibleItem;
        public int visibleItemCount;
        public int totalItemCount;
        public int scrollState;

        public ListViewScrollDataWrapper(int scrollState, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
            this.firstVisibleItem = firstVisibleItem;
            this.visibleItemCount = visibleItemCount;
            this.totalItemCount = totalItemCount;
            this.scrollState = scrollState;
        }
    }

    public static class OnScrollListener
    implements AbsListView.OnScrollListener {
        private PublishSubject<Integer> methodInvoke = PublishSubject.create();
        private ReplyCommand<Integer> onLoadMoreCommand;
        private ListView listView;

        public OnScrollListener(ListView listView, ReplyCommand<Integer> onLoadMoreCommand) {
            this.onLoadMoreCommand = onLoadMoreCommand;
            this.listView = listView;
            this.methodInvoke.throttleFirst(1L, TimeUnit.SECONDS).subscribe(ViewBindingAdapter$OnScrollListener$$Lambda$1.lambdaFactory$(this));
        }

        public void onScrollStateChanged(AbsListView view, int scrollState) {
        }

        public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
            if (firstVisibleItem + visibleItemCount >= totalItemCount && totalItemCount != 0 && totalItemCount != this.listView.getHeaderViewsCount() + this.listView.getFooterViewsCount() && this.onLoadMoreCommand != null) {
                this.methodInvoke.onNext((Object)totalItemCount);
            }
        }

        private /* synthetic */ void lambda$new$0(Integer c) throws Exception {
            this.onLoadMoreCommand.execute(c);
        }

        static /* synthetic */ void access$lambda$0(OnScrollListener onScrollListener, Integer n) {
            onScrollListener.lambda$new$0(n);
        }
    }
}

