/*
 * Decompiled with CFR 0.152.
 */
package com.kelin.mvvmlight.bindingadapter.image;

import android.databinding.BindingAdapter;
import android.graphics.Bitmap;
import android.net.Uri;
import android.support.annotation.DrawableRes;
import android.text.TextUtils;
import android.widget.ImageView;
import com.facebook.common.executors.UiThreadImmediateExecutorService;
import com.facebook.common.references.CloseableReference;
import com.facebook.datasource.DataSource;
import com.facebook.datasource.DataSubscriber;
import com.facebook.drawee.backends.pipeline.Fresco;
import com.facebook.drawee.view.SimpleDraweeView;
import com.facebook.imagepipeline.common.ResizeOptions;
import com.facebook.imagepipeline.core.ImagePipeline;
import com.facebook.imagepipeline.datasource.BaseBitmapDataSubscriber;
import com.facebook.imagepipeline.image.CloseableImage;
import com.facebook.imagepipeline.request.ImageRequest;
import com.facebook.imagepipeline.request.ImageRequestBuilder;
import com.kelin.mvvmlight.command.ReplyCommand;
import java.util.concurrent.Executor;

public final class ViewBindingAdapter {
    @BindingAdapter(value={"uri"})
    public static void setImageUri(SimpleDraweeView simpleDraweeView, String uri) {
        if (!TextUtils.isEmpty((CharSequence)uri)) {
            simpleDraweeView.setImageURI(Uri.parse((String)uri));
        }
    }

    @BindingAdapter(value={"uri", "placeholderImageRes", "request_width", "request_height", "onSuccessCommand", "onFailureCommand"}, requireAll=false)
    public static void loadImage(final ImageView imageView, String uri, @DrawableRes int placeholderImageRes, int width, int height, final ReplyCommand<Bitmap> onSuccessCommand, final ReplyCommand<DataSource<CloseableReference<CloseableImage>>> onFailureCommand) {
        imageView.setImageResource(placeholderImageRes);
        if (!TextUtils.isEmpty((CharSequence)uri)) {
            ImagePipeline imagePipeline = Fresco.getImagePipeline();
            ImageRequestBuilder builder = ImageRequestBuilder.newBuilderWithSource((Uri)Uri.parse((String)uri));
            if (width > 0 && height > 0) {
                builder.setResizeOptions(new ResizeOptions(width, height));
            }
            ImageRequest request = builder.build();
            DataSource dataSource = imagePipeline.fetchDecodedImage(request, (Object)imageView.getContext());
            dataSource.subscribe((DataSubscriber)new BaseBitmapDataSubscriber(){

                protected void onFailureImpl(DataSource<CloseableReference<CloseableImage>> dataSource) {
                    if (onFailureCommand != null) {
                        onFailureCommand.execute(dataSource);
                    }
                }

                protected void onNewResultImpl(Bitmap bitmap) {
                    imageView.setImageBitmap(bitmap);
                    if (onSuccessCommand != null) {
                        onSuccessCommand.execute(bitmap);
                    }
                }
            }, (Executor)UiThreadImmediateExecutorService.getInstance());
        }
    }
}

