/*
 * Decompiled with CFR 0.152.
 */
package com.kelin.mvvmlight.bindingadapter.edittext;

import android.databinding.BindingAdapter;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import com.kelin.mvvmlight.command.ReplyCommand;

public final class ViewBindingAdapter {
    @BindingAdapter(value={"requestFocus"})
    public static void requestFocusCommand(EditText editText, Boolean needRequestFocus) {
        if (needRequestFocus.booleanValue()) {
            editText.setFocusableInTouchMode(true);
            editText.setSelection(editText.getText().length());
            editText.requestFocus();
            InputMethodManager imm = (InputMethodManager)editText.getContext().getSystemService("input_method");
            imm.showSoftInput((View)editText, 1);
        } else {
            editText.setEnabled(false);
            editText.setEnabled(true);
        }
    }

    @BindingAdapter(value={"beforeTextChangedCommand", "onTextChangedCommand", "afterTextChangedCommand"}, requireAll=false)
    public static void editTextCommand(EditText editText, final ReplyCommand<TextChangeDataWrapper> beforeTextChangedCommand, final ReplyCommand<TextChangeDataWrapper> onTextChangedCommand, final ReplyCommand<String> afterTextChangedCommand) {
        editText.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
                if (beforeTextChangedCommand != null) {
                    beforeTextChangedCommand.execute(new TextChangeDataWrapper(s, start, count, count));
                }
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
                if (onTextChangedCommand != null) {
                    onTextChangedCommand.execute(new TextChangeDataWrapper(s, start, before, count));
                }
            }

            public void afterTextChanged(Editable s) {
                if (afterTextChangedCommand != null) {
                    afterTextChangedCommand.execute(s.toString());
                }
            }
        });
    }

    public static class TextChangeDataWrapper {
        public CharSequence s;
        public int start;
        public int before;
        public int count;

        public TextChangeDataWrapper(CharSequence s, int start, int before, int count) {
            this.s = s;
            this.start = start;
            this.before = before;
            this.count = count;
        }
    }
}

