/*
 * Decompiled with CFR 0.152.
 */
package net.frju.androidquery.operation.function;

import android.database.Cursor;
import android.database.CursorWrapper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import net.frju.androidquery.database.DbModelDescriptor;
import net.frju.androidquery.database.Resolver;

public class CursorResult<T>
extends CursorWrapper
implements Iterable<T> {
    private final DbModelDescriptor mQuery;

    public CursorResult(@NonNull Class<T> type, @NonNull Resolver resolver, Cursor cursor) {
        super(cursor);
        this.mQuery = resolver.getDbModelDescriptor(type);
    }

    @Nullable
    public T get() {
        return this.mQuery.getSingleResult((Cursor)this);
    }

    @Nullable
    public T get(int position) {
        this.moveToPosition(position);
        return this.mQuery.getSingleResult((Cursor)this);
    }

    @NonNull
    public T[] toArray() {
        return this.mQuery.getArrayResult((Cursor)this);
    }

    @NonNull
    public List<T> toList() {
        if (this.getWrappedCursor() != null) {
            return new ArrayList<T>(Arrays.asList(this.toArray()));
        }
        return null;
    }

    public int getCount() {
        if (this.getWrappedCursor() != null) {
            return super.getCount();
        }
        return 0;
    }

    @Override
    @NonNull
    public Iterator<T> iterator() {
        return new ResultIterator();
    }

    public class ResultIterator
    implements Iterator<T> {
        @Override
        public boolean hasNext() {
            return CursorResult.this.getCount() > 0 && CursorResult.this.getPosition() < CursorResult.this.getCount() - 1;
        }

        @Override
        @Nullable
        public T next() {
            CursorResult.this.moveToNext();
            return CursorResult.this.get();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Cannot remove item from CursorResult");
        }
    }
}

