/*
 * Decompiled with CFR 0.152.
 */
package net.frju.androidquery.operation.function;

import android.support.annotation.NonNull;
import io.reactivex.Single;
import java.util.List;
import java.util.concurrent.Callable;
import net.frju.androidquery.database.DatabaseProvider;
import net.frju.androidquery.database.Query;

public class Insert
extends Query {
    private final Object[] mModels;
    private final Query.ConflictResolution mConflictResolution;

    public Object[] getModels() {
        return this.mModels;
    }

    public Query.ConflictResolution getConflictResolution() {
        return this.mConflictResolution;
    }

    private Insert(Query.ConflictResolution conflictResolution, Object ... models) {
        this.mConflictResolution = conflictResolution;
        this.mModels = models;
    }

    @SafeVarargs
    @NonNull
    public static <T> Builder getBuilder(@NonNull DatabaseProvider databaseProvider, T ... models) {
        return new Builder(databaseProvider, (Object[])models);
    }

    @NonNull
    public static <T> Builder getBuilder(@NonNull DatabaseProvider databaseProvider, @NonNull List<T> models) {
        return new Builder(databaseProvider, models.toArray(new Object[models.size()]));
    }

    public static class Builder<T> {
        private final T[] mModels;
        private Query.ConflictResolution mConflictResolution = Query.ConflictResolution.CONFLICT_IGNORE;
        private final DatabaseProvider mDatabaseProvider;

        @SafeVarargs
        private Builder(@NonNull DatabaseProvider databaseProvider, T ... models) {
            this.mModels = models;
            this.mDatabaseProvider = databaseProvider;
        }

        public Builder<T> withConflictResolution(Query.ConflictResolution conflictResolution) {
            this.mConflictResolution = conflictResolution;
            return this;
        }

        public int query() {
            return Insert.insert(new Insert(this.mConflictResolution, (Object[])this.mModels), this.mModels != null && this.mModels.length > 0 ? this.mModels[0].getClass() : Object.class, this.mDatabaseProvider);
        }

        @NonNull
        public rx.Single<Integer> rx() {
            return Insert.wrapRx(new Callable<Integer>(){

                @Override
                public Integer call() throws Exception {
                    return Builder.this.query();
                }
            });
        }

        @NonNull
        public Single<Integer> rx2() {
            return Insert.wrapRx2(new Callable<Integer>(){

                @Override
                public Integer call() throws Exception {
                    return Builder.this.query();
                }
            });
        }
    }
}

