/*
 * Decompiled with CFR 0.152.
 */
package net.frju.androidquery.database;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.DatabaseUtils;
import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.net.Uri;
import android.os.Handler;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import net.frju.androidquery.database.DatabaseProvider;
import net.frju.androidquery.database.DbModelDescriptor;
import net.frju.androidquery.operation.condition.Where;
import net.frju.androidquery.operation.join.Join;
import net.frju.androidquery.operation.keyword.Limit;
import net.frju.androidquery.operation.keyword.OrderBy;

public abstract class BaseLocalDatabaseProvider
extends DatabaseProvider {
    private final SQLiteDatabase mDatabase;
    private final String[] mSchemaArray;
    private final String[][] mColumnsSqlArray;
    private final String[] mTableRealNameArray;
    private final String[] mCreateIndexQuery;

    public BaseLocalDatabaseProvider(@NonNull Context context) {
        super(context);
        Class<?>[] modelClassDef = this.getResolver().getModelsForProvider(this.getClass());
        int modelCount = modelClassDef.length;
        this.mSchemaArray = new String[modelCount];
        this.mTableRealNameArray = new String[modelCount];
        this.mColumnsSqlArray = new String[modelCount][];
        this.mCreateIndexQuery = new String[modelCount];
        for (int i = 0; i < modelClassDef.length; ++i) {
            DbModelDescriptor dbModelDescriptor = this.getResolver().getDbModelDescriptor(modelClassDef[i]);
            this.mSchemaArray[i] = dbModelDescriptor.getTableCreateQuery();
            this.mColumnsSqlArray[i] = dbModelDescriptor.getColumnsSqlArray();
            this.mTableRealNameArray[i] = dbModelDescriptor.getTableDbName();
            this.mCreateIndexQuery[i] = dbModelDescriptor.getCreateIndexQuery();
        }
        final DbInitFeedback dbInitFeedback = new DbInitFeedback();
        SQLiteOpenHelper openHelper = new SQLiteOpenHelper(context, this.getDbName(), null, this.getDbVersion()){

            public void onCreate(SQLiteDatabase db) {
                BaseLocalDatabaseProvider.this.onCreate(db);
                dbInitFeedback.onCreateCalled = true;
            }

            public void onDowngrade(SQLiteDatabase db, int oldVersion, int newVersion) {
                BaseLocalDatabaseProvider.this.onDowngrade(db, oldVersion, newVersion);
                dbInitFeedback.onDowngradeCalled = true;
                dbInitFeedback.oldVersion = oldVersion;
                dbInitFeedback.newVersion = newVersion;
            }

            public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
                BaseLocalDatabaseProvider.this.onUpgrade(db, oldVersion, newVersion);
                dbInitFeedback.onUpgradeCalled = true;
                dbInitFeedback.oldVersion = oldVersion;
                dbInitFeedback.newVersion = newVersion;
            }
        };
        this.mDatabase = openHelper.getWritableDatabase();
        if (dbInitFeedback.onCreateCalled) {
            new Handler(this.mContext.getMainLooper()).post(new Runnable(){

                @Override
                public void run() {
                    BaseLocalDatabaseProvider.this.onPostCreate();
                }
            });
        } else if (dbInitFeedback.onDowngradeCalled) {
            new Handler(this.mContext.getMainLooper()).post(new Runnable(){

                @Override
                public void run() {
                    BaseLocalDatabaseProvider.this.onPostDowngrade(dbInitFeedback.oldVersion, dbInitFeedback.newVersion);
                }
            });
        } else if (dbInitFeedback.onUpgradeCalled) {
            new Handler(this.mContext.getMainLooper()).post(new Runnable(){

                @Override
                public void run() {
                    BaseLocalDatabaseProvider.this.onPostUpgrade(dbInitFeedback.oldVersion, dbInitFeedback.newVersion);
                }
            });
        }
    }

    @Override
    @NonNull
    protected String getAuthority() {
        return this.getClass().getPackage().getName();
    }

    @Override
    @NonNull
    public Uri getUri(@NonNull Class model, @Nullable String uriSuffix) {
        String tableName = this.getResolver().getDbModelDescriptor(model).getTableDbName();
        if (uriSuffix == null) {
            return new Uri.Builder().scheme("content").authority(this.getAuthority()).appendPath(BaseLocalDatabaseProvider.firstToLowerCase(tableName)).build();
        }
        return new Uri.Builder().scheme("content").authority(this.getAuthority()).appendPath(BaseLocalDatabaseProvider.firstToLowerCase(tableName)).appendPath(uriSuffix).build();
    }

    @Override
    @NonNull
    public Uri getUri(@NonNull String modelDbName, @Nullable String uriSuffix) {
        if (uriSuffix == null) {
            return new Uri.Builder().scheme("content").authority(this.getAuthority()).appendPath(BaseLocalDatabaseProvider.firstToLowerCase(modelDbName)).build();
        }
        return new Uri.Builder().scheme("content").authority(this.getAuthority()).appendPath(BaseLocalDatabaseProvider.firstToLowerCase(modelDbName)).appendPath(uriSuffix).build();
    }

    @NonNull
    protected abstract String getDbName();

    protected abstract int getDbVersion();

    protected void onCreate(@NonNull SQLiteDatabase db) {
        for (String schema : this.mSchemaArray) {
            db.execSQL(schema);
        }
        for (String createIndex : this.mCreateIndexQuery) {
            if (createIndex == null) continue;
            db.execSQL(createIndex);
        }
    }

    protected void onPostCreate() {
    }

    protected void onDowngrade(@NonNull SQLiteDatabase db, int oldVersion, int newVersion) {
    }

    protected void onPostDowngrade(int oldVersion, int newVersion) {
    }

    protected void onUpgrade(@NonNull SQLiteDatabase db, int oldVersion, int newVersion) {
        if (newVersion > oldVersion) {
            db.beginTransaction();
            for (String schema : this.mSchemaArray) {
                try {
                    db.execSQL(schema);
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            for (String createIndex : this.mCreateIndexQuery) {
                try {
                    if (createIndex == null) continue;
                    db.execSQL(createIndex);
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            for (int i = 0; i < this.mTableRealNameArray.length; ++i) {
                String tableName = this.mTableRealNameArray[i];
                for (String columnsSql : this.mColumnsSqlArray[i]) {
                    try {
                        db.execSQL("ALTER TABLE " + tableName + " ADD COLUMN " + columnsSql + ";");
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
            }
            db.setTransactionSuccessful();
            db.endTransaction();
        }
    }

    protected void onPostUpgrade(int oldVersion, int newVersion) {
    }

    @Override
    protected long insert(@NonNull String tableName, @NonNull ContentValues values) {
        long newId = this.mDatabase.insert(tableName, null, values);
        if (newId != -1L) {
            this.mContext.getContentResolver().notifyChange(this.getUri(tableName, null), null);
        }
        return newId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int bulkInsert(@NonNull String tableName, @NonNull ContentValues[] valuesArray) {
        int nbInsert = 0;
        this.mDatabase.beginTransaction();
        try {
            for (ContentValues values : valuesArray) {
                if (this.mDatabase.insert(tableName, null, values) == -1L) continue;
                ++nbInsert;
            }
            this.mDatabase.setTransactionSuccessful();
        }
        finally {
            this.mDatabase.endTransaction();
        }
        if (nbInsert > 0) {
            this.mContext.getContentResolver().notifyChange(this.getUri(tableName, null), null);
        }
        return nbInsert;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int bulkUpdate(@NonNull String tableName, @Nullable String uriSuffix, @NonNull ContentValues[] valuesArray, @NonNull Where[][] conditionsArray) {
        int nbUpdate = 0;
        this.mDatabase.beginTransaction();
        try {
            for (int i = 0; i < valuesArray.length; ++i) {
                nbUpdate += this.mDatabase.update(tableName, valuesArray[i], this.mClauseHelper.getCondition(conditionsArray[i]), this.mClauseHelper.getConditionArgs(conditionsArray[i]));
            }
            this.mDatabase.setTransactionSuccessful();
        }
        finally {
            this.mDatabase.endTransaction();
        }
        if (nbUpdate > 0) {
            this.mContext.getContentResolver().notifyChange(this.getUri(tableName, uriSuffix), null);
        }
        return nbUpdate;
    }

    @Override
    @Nullable
    protected Cursor query(@NonNull String tableName, @NonNull String[] columns, @Nullable Where[] where, @Nullable Join[] joins, @Nullable String groupBy, @Nullable String having, @Nullable OrderBy[] orderBy, @Nullable Limit limit) {
        if (joins != null && joins.length > 0) {
            try {
                String joinQuery = this.mClauseHelper.buildJoinQuery(columns, joins, tableName, where, orderBy, limit, this.getResolver());
                return this.mDatabase.rawQuery(joinQuery, this.mClauseHelper.getConditionArgs(where));
            }
            catch (Exception e) {
                throw new SQLException(e.getMessage());
            }
        }
        Cursor cursor = this.mDatabase.query(tableName, columns, this.mClauseHelper.getCondition(where), this.mClauseHelper.getConditionArgs(where), groupBy, having, this.mClauseHelper.getOrderBy(orderBy), this.mClauseHelper.getLimit(limit));
        if (cursor != null) {
            cursor.setNotificationUri(this.mContext.getContentResolver(), this.getUri(tableName, null));
        }
        return cursor;
    }

    @Override
    protected int delete(@NonNull String tableName, @Nullable String uriSuffix, @Nullable Where[] where) {
        String whereClause = this.mClauseHelper.getCondition(where);
        int nbDeleted = this.mDatabase.delete(tableName, whereClause, this.mClauseHelper.getConditionArgs(where));
        if (nbDeleted > 0 || TextUtils.isEmpty((CharSequence)whereClause)) {
            this.mContext.getContentResolver().notifyChange(this.getUri(tableName, uriSuffix), null);
        }
        return nbDeleted;
    }

    @Override
    protected long count(@NonNull String tableName, @Nullable Where[] where) {
        return DatabaseUtils.queryNumEntries((SQLiteDatabase)this.mDatabase, (String)tableName, (String)this.mClauseHelper.getCondition(where), (String[])this.mClauseHelper.getConditionArgs(where));
    }

    @Override
    @Nullable
    protected Cursor rawQuery(@NonNull String sql) {
        return this.mDatabase.rawQuery(sql, null);
    }

    @NonNull
    SQLiteDatabase getDatabase() {
        return this.mDatabase;
    }

    private class DbInitFeedback {
        boolean onCreateCalled = false;
        boolean onDowngradeCalled = false;
        boolean onUpgradeCalled = false;
        int oldVersion;
        int newVersion;

        private DbInitFeedback() {
        }
    }
}

