/*
 * Decompiled with CFR 0.152.
 */
package net.frju.androidquery.operation.join;

public class Join {
    private final Class<?> mInitialTable;
    private final Class<?> mAddedTable;
    private final String mInitialTableColumn;
    private final String mAddedTableColumn;
    private final Type mType;

    public Type getType() {
        return this.mType;
    }

    public Class<?> getInitialTable() {
        return this.mInitialTable;
    }

    public Class<?> getAddedTable() {
        return this.mAddedTable;
    }

    public String getInitialTableColumn() {
        return this.mInitialTableColumn;
    }

    public String getAddedTableColumn() {
        return this.mAddedTableColumn;
    }

    public Join(Type type, Class<?> initialTable, String initialTableColumn, Class<?> addedTable, String addedTableColumn) {
        this.mType = type;
        this.mInitialTable = initialTable;
        this.mAddedTable = addedTable;
        this.mInitialTableColumn = initialTableColumn;
        this.mAddedTableColumn = addedTableColumn;
    }

    public static Join innerJoin(Class<?> initialTable, String initialTableColumn, Class<?> addedTable, String addedTableColumn) {
        return new Join(Type.INNER, initialTable, initialTableColumn, addedTable, addedTableColumn);
    }

    public static Join leftOuterJoin(Class<?> initialTable, String initialTableColumn, Class<?> addedTable, String addedTableColumn) {
        return new Join(Type.LEFT_OUTER, initialTable, initialTableColumn, addedTable, addedTableColumn);
    }

    public static Join crossInnerJoin(Class<?> initialTable, String initialTableColumn, Class<?> addedTable, String addedTableColumn) {
        return new Join(Type.CROSS_INNER, initialTable, initialTableColumn, addedTable, addedTableColumn);
    }

    public static Join naturalInnerJoin(Class<?> initialTable, String initialTableColumn, Class<?> addedTable, String addedTableColumn) {
        return new Join(Type.NATURAL_INNER, initialTable, initialTableColumn, addedTable, addedTableColumn);
    }

    public static Join naturalLeftOuterJoin(Class<?> initialTable, String initialTableColumn, Class<?> addedTable, String addedTableColumn) {
        return new Join(Type.NATURAL_LEFT_OUTER, initialTable, initialTableColumn, addedTable, addedTableColumn);
    }

    public static enum Type {
        INNER,
        LEFT_OUTER,
        CROSS_INNER,
        NATURAL_INNER,
        NATURAL_LEFT_OUTER;

    }
}

