/*
 * Decompiled with CFR 0.152.
 */
package net.frju.androidquery.database;

import android.content.ContentValues;
import android.database.Cursor;
import android.text.TextUtils;
import io.reactivex.ObservableEmitter;
import io.reactivex.ObservableOnSubscribe;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import net.frju.androidquery.database.DatabaseProvider;
import net.frju.androidquery.database.DbModelDescriptor;
import net.frju.androidquery.database.ModelListener;
import net.frju.androidquery.operation.condition.Condition;
import net.frju.androidquery.operation.condition.In;
import net.frju.androidquery.operation.condition.Where;
import net.frju.androidquery.operation.function.Count;
import net.frju.androidquery.operation.function.CursorResult;
import net.frju.androidquery.operation.function.Delete;
import net.frju.androidquery.operation.function.Insert;
import net.frju.androidquery.operation.function.Save;
import net.frju.androidquery.operation.function.Select;
import net.frju.androidquery.operation.function.Update;
import rx.Observable;
import rx.Subscriber;

public abstract class Query {
    protected static int save(Save save, Class<?> classDef, DatabaseProvider databaseProvider) {
        int nb = 0;
        DbModelDescriptor table = databaseProvider.getResolver().getDbModelDescriptor(classDef);
        boolean isPrimaryKeyAutoIncrement = table.isPrimaryKeyAutoIncrement();
        ArrayList<Object> modelsToInsert = new ArrayList<Object>();
        for (Object model : save.getModels()) {
            long id = 1L;
            if (isPrimaryKeyAutoIncrement) {
                Object primaryKeyValue = table.getPrimaryKeyValue(model);
                id = Long.parseLong(primaryKeyValue.toString());
            }
            if (id <= 0L || Update.getBuilder(classDef, databaseProvider).model(model).query() <= 0) {
                modelsToInsert.add(model);
                continue;
            }
            ++nb;
        }
        return nb += Insert.getBuilder(databaseProvider, modelsToInsert.toArray()).query();
    }

    protected static int insert(Insert insert, Class<?> classDef, DatabaseProvider databaseProvider) {
        if (insert.getModels() != null && insert.getModels().length > 0) {
            Object[] models = insert.getModels();
            ContentValues[] valuesArray = new ContentValues[models.length];
            DbModelDescriptor dbModelDescriptor = Query.getTableDescription(classDef, databaseProvider);
            for (int i = 0; i < models.length; ++i) {
                if (models[i] instanceof ModelListener) {
                    ((ModelListener)models[i]).onPreInsert();
                }
                valuesArray[i] = dbModelDescriptor.getContentValues(models[i]);
            }
            if (models.length == 1) {
                long newId = databaseProvider.insert(dbModelDescriptor.getTableRealName(), valuesArray[0]);
                if (newId != -1L) {
                    dbModelDescriptor.setIdToModel(models[0], newId);
                    return 1;
                }
                return 0;
            }
            return databaseProvider.bulkInsert(dbModelDescriptor.getTableRealName(), valuesArray);
        }
        return 0;
    }

    protected static Cursor selectCursor(Select select, Class<?> classDef, DatabaseProvider databaseProvider) {
        DbModelDescriptor dbModelDescriptor = Query.getTableDescription(classDef, databaseProvider);
        return databaseProvider.query(dbModelDescriptor.getTableRealName(), select.getJoins() != null ? dbModelDescriptor.getColumnNamesWithTablePrefix() : dbModelDescriptor.getColumnNames(), select.getClause(), select.getJoins(), null, null, select.getOrderBy(), select.getLimit());
    }

    protected static <T> CursorResult<T> select(Select select, Class<T> classDef, DatabaseProvider databaseProvider) {
        Cursor cursor = Query.selectCursor(select, classDef, databaseProvider);
        return new CursorResult<T>(classDef, databaseProvider.getResolver(), cursor);
    }

    protected static <T> T selectSingle(Select select, Class<T> classDef, DatabaseProvider databaseProvider) {
        Cursor cursor = Query.selectCursor(select, classDef, databaseProvider);
        T[] results = Query.getTableDescription(classDef, databaseProvider).getArrayResult(cursor);
        if (results != null && results.length > 0) {
            return results[0];
        }
        return null;
    }

    protected static int update(Update update, Class<?> classDef, DatabaseProvider databaseProvider) {
        Object[] models = update.getModels();
        if (models != null) {
            DbModelDescriptor tableDesc = Query.getTableDescription(classDef, databaseProvider);
            String primaryKeyName = tableDesc.getPrimaryKeyRealName();
            ContentValues[] valuesArray = new ContentValues[models.length];
            Condition[][] conditionsArray = new Condition[models.length][];
            for (int i = 0; i < models.length; ++i) {
                Object model = models[i];
                conditionsArray[i] = update.getConditions();
                if (conditionsArray[i] == null) {
                    if (TextUtils.isEmpty((CharSequence)primaryKeyName)) {
                        throw new IllegalStateException("update with model() method require a primary key");
                    }
                    conditionsArray[i] = new Condition[1];
                    conditionsArray[i][0] = Where.where(primaryKeyName, Where.Op.IS, tableDesc.getPrimaryKeyValue(model));
                }
                if (model instanceof ModelListener) {
                    ((ModelListener)model).onPreUpdate();
                }
                valuesArray[i] = tableDesc.getContentValues(model);
            }
            return databaseProvider.bulkUpdate(tableDesc.getTableRealName(), valuesArray, conditionsArray);
        }
        return databaseProvider.bulkUpdate(Query.getTableDescription(classDef, databaseProvider).getTableRealName(), new ContentValues[]{update.getContentValues()}, new Condition[][]{update.getConditions()});
    }

    protected static long count(Count count, Class<?> classDef, DatabaseProvider databaseProvider) {
        return databaseProvider.count(Query.getTableDescription(classDef, databaseProvider).getTableRealName(), count.getClause());
    }

    protected static int delete(Delete delete, Class<?> classDef, DatabaseProvider databaseProvider) {
        Object[] models = delete.getModels();
        if (models != null) {
            DbModelDescriptor tableDesc = Query.getTableDescription(classDef, databaseProvider);
            String primaryKeyName = tableDesc.getPrimaryKeyRealName();
            if (TextUtils.isEmpty((CharSequence)primaryKeyName)) {
                throw new IllegalStateException("delete with model() method require a primary key");
            }
            Object[] keys = new String[delete.getModels().length];
            for (int i = 0; i < models.length; ++i) {
                keys[i] = tableDesc.getPrimaryKeyValue(models[i]);
                if (!(models[i] instanceof ModelListener)) continue;
                ((ModelListener)models[i]).onPreDelete();
            }
            In condition = new In(primaryKeyName, keys);
            return databaseProvider.delete(tableDesc.getTableRealName(), new Condition[]{condition});
        }
        return databaseProvider.delete(Query.getTableDescription(classDef, databaseProvider).getTableRealName(), delete.getConditions());
    }

    protected static Cursor rawQuery(String query, DatabaseProvider databaseProvider) {
        return databaseProvider.rawQuery(query);
    }

    protected static <T> Observable<T> wrapRx(final Callable<T> func) {
        return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<T>(){

            public void call(Subscriber<? super T> subscriber) {
                try {
                    subscriber.onNext(func.call());
                }
                catch (Exception e) {
                    subscriber.onError((Throwable)e);
                }
            }
        });
    }

    protected static <T> io.reactivex.Observable<T> wrapRx2(final Callable<T> func) {
        return io.reactivex.Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<T>(){

            public void subscribe(ObservableEmitter<T> emitter) throws Exception {
                try {
                    emitter.onNext(func.call());
                }
                catch (Exception e) {
                    emitter.onError((Throwable)e);
                }
            }
        });
    }

    private static DbModelDescriptor getTableDescription(Class<?> classDef, DatabaseProvider databaseProvider) {
        return databaseProvider.getResolver().getDbModelDescriptor(classDef);
    }
}

