/*
 * Decompiled with CFR 0.152.
 */
package net.frju.androidquery.utils;

import android.database.ContentObserver;
import android.os.Handler;
import android.os.SystemClock;

public abstract class ThrottledContentObserver
extends ContentObserver {
    private final long mUpdateThrottle;
    private final Handler mHandler;
    private long mLastUpdate = 0L;
    private boolean mRerun = false;

    public ThrottledContentObserver(Handler handler, long delayMS) {
        super(handler);
        this.mUpdateThrottle = delayMS;
        this.mHandler = handler;
    }

    public void onChange(final boolean selfChange) {
        long now = SystemClock.uptimeMillis();
        if (now - this.mLastUpdate > this.mUpdateThrottle) {
            this.mLastUpdate = now;
            this.onChangeThrottled();
            this.mHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    if (ThrottledContentObserver.this.mRerun) {
                        ThrottledContentObserver.this.mRerun = false;
                        ThrottledContentObserver.this.onChange(selfChange);
                    }
                }
            }, this.mUpdateThrottle + 1L);
        } else {
            this.mRerun = true;
        }
        super.onChange(selfChange);
    }

    public abstract void onChangeThrottled();
}

