/*
 * Decompiled with CFR 0.152.
 */
package net.frju.androidquery.operation.function;

import android.database.Cursor;
import android.database.CursorWrapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import net.frju.androidquery.database.Resolver;
import net.frju.androidquery.database.TableDescription;

public class Result<T>
extends CursorWrapper
implements Iterable<T> {
    private TableDescription mQuery;

    public Result(Class<T> type, Resolver resolver, Cursor cursor) {
        super(cursor);
        this.mQuery = resolver.getTableDescription(type);
    }

    public T get() {
        return this.mQuery.getSingleResult((Cursor)this);
    }

    public T get(int position) {
        this.moveToPosition(position);
        return this.mQuery.getSingleResult((Cursor)this);
    }

    public T[] toArray() {
        return this.mQuery.getArrayResult((Cursor)this);
    }

    public List<T> toList() {
        return new ArrayList<T>(Arrays.asList(this.toArray()));
    }

    @Override
    public Iterator<T> iterator() {
        return new ResultIterator();
    }

    public class ResultIterator
    implements Iterator<T> {
        @Override
        public boolean hasNext() {
            return Result.this.getCount() > 0 && Result.this.getPosition() < Result.this.getCount() - 1;
        }

        @Override
        public T next() {
            Result.this.moveToNext();
            return Result.this.get();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Cannot remove item from Result");
        }
    }
}

