/*
 * Decompiled with CFR 0.152.
 */
package net.frju.androidquery.operation.function;

import io.reactivex.Observable;
import java.util.Arrays;
import java.util.concurrent.Callable;
import net.frju.androidquery.database.DatabaseProvider;
import net.frju.androidquery.database.Query;
import net.frju.androidquery.operation.condition.Condition;
import net.frju.androidquery.operation.function.Result;
import net.frju.androidquery.operation.join.Join;
import net.frju.androidquery.operation.keyword.Limit;
import net.frju.androidquery.operation.keyword.OrderBy;

public class Select
extends Query {
    private Condition[] mCondition;
    private Join[] mJoin;
    private OrderBy[] mOrderBy;
    private Limit mLimit;

    public Condition[] getClause() {
        return this.mCondition;
    }

    public Join[] getJoin() {
        return this.mJoin;
    }

    public OrderBy[] getOrderBy() {
        return this.mOrderBy;
    }

    public Limit getLimit() {
        return this.mLimit;
    }

    private Select(Condition[] condition, Join[] join, OrderBy[] orderBy, Limit limit) {
        this.mCondition = condition;
        this.mJoin = join;
        this.mOrderBy = orderBy;
        this.mLimit = limit;
    }

    public static <T> Builder getBuilder(Class<T> classDef, DatabaseProvider databaseProvider) {
        return new Builder(classDef, databaseProvider);
    }

    public static class Builder<T> {
        private Condition[] mCondition;
        private Join[] mJoin;
        private OrderBy[] mOrderBy;
        private Limit mLimit;
        private Class<T> mClassDef;
        private DatabaseProvider mDatabaseProvider;

        private Builder(Class<T> classDef, DatabaseProvider databaseProvider) {
            this.mClassDef = classDef;
            this.mDatabaseProvider = databaseProvider;
        }

        public Builder<T> where(Condition ... condition) {
            this.mCondition = condition;
            return this;
        }

        public Builder<T> join(Join ... joins) {
            this.mJoin = joins;
            return this;
        }

        public Builder<T> orderBy(String column, OrderBy.Order order) {
            if (this.mOrderBy == null) {
                this.mOrderBy = new OrderBy[]{new OrderBy(column, order)};
            } else {
                this.mOrderBy = Arrays.copyOf(this.mOrderBy, this.mOrderBy.length + 1);
                this.mOrderBy[this.mOrderBy.length - 1] = new OrderBy(column, order);
            }
            return this;
        }

        public Builder<T> orderBy(OrderBy ... orderBy) {
            this.mOrderBy = orderBy;
            return this;
        }

        public Builder<T> limit(int n) {
            this.mLimit = new Limit(0, n);
            return this;
        }

        public Builder<T> limit(int start, int end) {
            this.mLimit = new Limit(start, end);
            return this;
        }

        public Result<T> query() {
            return Select.select(new Select(this.mCondition, this.mJoin, this.mOrderBy, this.mLimit), this.mClassDef, this.mDatabaseProvider);
        }

        public T querySingle() {
            return (T)Select.selectSingle(new Select(this.mCondition, this.mJoin, this.mOrderBy, new Limit(0, 1)), this.mClassDef, this.mDatabaseProvider);
        }

        public Observable<Result<T>> rx() {
            return Select.wrapRx(new Callable<Result<T>>(){

                @Override
                public Result<T> call() throws Exception {
                    return Builder.this.query();
                }
            });
        }

        public Observable<T> rxSingle() {
            return Select.wrapRx(new Callable<T>(){

                @Override
                public T call() throws Exception {
                    return Builder.this.querySingle();
                }
            });
        }
    }
}

