/*
 * Decompiled with CFR 0.152.
 */
package net.frju.androidquery.operation.function;

import io.reactivex.Observable;
import java.util.concurrent.Callable;
import net.frju.androidquery.database.DatabaseProvider;
import net.frju.androidquery.database.Query;
import net.frju.androidquery.operation.clause.Clause;
import net.frju.androidquery.operation.function.Result;
import net.frju.androidquery.operation.join.Join;
import net.frju.androidquery.operation.keyword.Limit;
import net.frju.androidquery.operation.keyword.OrderBy;

public class Select
extends Query {
    private Clause[] mClause;
    private Join[] mJoin;
    private OrderBy mOrderBy;
    private Limit mLimit;

    public Clause[] getClause() {
        return this.mClause;
    }

    public Join[] getJoin() {
        return this.mJoin;
    }

    public OrderBy getOrderBy() {
        return this.mOrderBy;
    }

    public Limit getLimit() {
        return this.mLimit;
    }

    private Select(Clause[] clause, Join[] join, OrderBy orderBy, Limit limit) {
        this.mClause = clause;
        this.mJoin = join;
        this.mOrderBy = orderBy;
        this.mLimit = limit;
    }

    public static <T> Builder getBuilder(Class<T> classDef, DatabaseProvider databaseProvider) {
        return new Builder(classDef, databaseProvider);
    }

    public static class Builder<T> {
        private Clause[] mClause;
        private Join[] mJoin;
        private OrderBy mOrderBy;
        private Limit mLimit;
        private Class<T> mClassDef;
        private DatabaseProvider mDatabaseProvider;

        private Builder(Class<T> classDef, DatabaseProvider databaseProvider) {
            this.mClassDef = classDef;
            this.mDatabaseProvider = databaseProvider;
        }

        public Builder<T> where(Clause ... clause) {
            this.mClause = clause;
            return this;
        }

        public Builder<T> join(Join ... joins) {
            this.mJoin = joins;
            return this;
        }

        public Builder<T> orderBy(String column, OrderBy.Order order) {
            this.mOrderBy = new OrderBy(column, order);
            return this;
        }

        public Builder<T> limit(int start, int end) {
            this.mLimit = new Limit(start, end);
            return this;
        }

        public Result<T> execute() {
            return Select.select(new Select(this.mClause, this.mJoin, this.mOrderBy, this.mLimit), this.mClassDef, this.mDatabaseProvider);
        }

        public T executeOne() {
            return (T)Select.selectSingle(new Select(this.mClause, this.mJoin, this.mOrderBy, this.mLimit), this.mClassDef, this.mDatabaseProvider);
        }

        public Observable<Result<T>> rx() {
            return Select.wrapRx(new Callable<Result<T>>(){

                @Override
                public Result<T> call() throws Exception {
                    return Builder.this.execute();
                }
            });
        }

        public Observable<T> rxOne() {
            return Select.wrapRx(new Callable<T>(){

                @Override
                public T call() throws Exception {
                    return Builder.this.executeOne();
                }
            });
        }
    }
}

