/*
 * Decompiled with CFR 0.152.
 */
package net.frju.androidquery.models.gen;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import net.frju.androidquery.database.BaseContentDatabaseProvider;
import net.frju.androidquery.database.DatabaseProvider;
import net.frju.androidquery.database.DbModelDescriptor;
import net.frju.androidquery.database.Resolver;
import net.frju.androidquery.models.BlockedNumber;
import net.frju.androidquery.models.BlockedNumberContentDatabaseProvider;
import net.frju.androidquery.models.Contact;
import net.frju.androidquery.models.ContactContentDatabaseProvider;
import net.frju.androidquery.models.Image;
import net.frju.androidquery.models.MediaStoreContentDatabaseProvider;
import net.frju.androidquery.models.RawContact;
import net.frju.androidquery.models.RawContactData;
import net.frju.androidquery.models.gen.BLOCKED_NUMBER;
import net.frju.androidquery.models.gen.CONTACT;
import net.frju.androidquery.models.gen.IMAGE;
import net.frju.androidquery.models.gen.RAW_CONTACT;
import net.frju.androidquery.models.gen.RAW_CONTACT_DATA;

public class Q {
    private static DefaultResolver sResolver;
    private static RAW_CONTACT sRawContact;
    private static RAW_CONTACT_DATA sRawContactData;
    private static IMAGE sImage;
    private static BLOCKED_NUMBER sBlockedNumber;
    private static CONTACT sContact;

    public static void init(@NonNull Context context) {
        if (sResolver == null) {
            sResolver = new DefaultResolver();
            sResolver.init(context);
        }
    }

    @NonNull
    public static DefaultResolver getResolver() {
        return sResolver;
    }

    static {
        sRawContact = new RAW_CONTACT();
        sRawContactData = new RAW_CONTACT_DATA();
        sImage = new IMAGE();
        sBlockedNumber = new BLOCKED_NUMBER();
        sContact = new CONTACT();
    }

    public static class DefaultResolver
    implements Resolver {
        private static HashMap<Class<?>, DatabaseProvider> mProviders = new HashMap();

        public void init(@NonNull Context context) {
            HashMap<String, BaseContentDatabaseProvider> providersByName = new HashMap<String, BaseContentDatabaseProvider>();
            providersByName.put("net.frju.androidquery.models.ContactContentDatabaseProvider", new ContactContentDatabaseProvider(context.getApplicationContext()));
            providersByName.put("net.frju.androidquery.models.BlockedNumberContentDatabaseProvider", new BlockedNumberContentDatabaseProvider(context.getApplicationContext()));
            providersByName.put("net.frju.androidquery.models.MediaStoreContentDatabaseProvider", new MediaStoreContentDatabaseProvider(context.getApplicationContext()));
            mProviders.put(RawContact.class, (DatabaseProvider)providersByName.get("net.frju.androidquery.models.ContactContentDatabaseProvider"));
            mProviders.put(RAW_CONTACT.class, (DatabaseProvider)providersByName.get("net.frju.androidquery.models.ContactContentDatabaseProvider"));
            mProviders.put(RawContactData.class, (DatabaseProvider)providersByName.get("net.frju.androidquery.models.ContactContentDatabaseProvider"));
            mProviders.put(RAW_CONTACT_DATA.class, (DatabaseProvider)providersByName.get("net.frju.androidquery.models.ContactContentDatabaseProvider"));
            mProviders.put(Image.class, (DatabaseProvider)providersByName.get("net.frju.androidquery.models.MediaStoreContentDatabaseProvider"));
            mProviders.put(IMAGE.class, (DatabaseProvider)providersByName.get("net.frju.androidquery.models.MediaStoreContentDatabaseProvider"));
            mProviders.put(BlockedNumber.class, (DatabaseProvider)providersByName.get("net.frju.androidquery.models.BlockedNumberContentDatabaseProvider"));
            mProviders.put(BLOCKED_NUMBER.class, (DatabaseProvider)providersByName.get("net.frju.androidquery.models.BlockedNumberContentDatabaseProvider"));
            mProviders.put(Contact.class, (DatabaseProvider)providersByName.get("net.frju.androidquery.models.ContactContentDatabaseProvider"));
            mProviders.put(CONTACT.class, (DatabaseProvider)providersByName.get("net.frju.androidquery.models.ContactContentDatabaseProvider"));
        }

        public void initModelWithInitMethods(@NonNull Object model) {
            if (model instanceof RawContact) {
                ((RawContact)model).initRawContactData();
            } else if (!(model instanceof RawContactData) && !(model instanceof Image) && !(model instanceof BlockedNumber) && model instanceof Contact) {
                ((Contact)model).initRawContacts();
            }
        }

        @NonNull
        public Class<?> getModelClassFromName(@NonNull String modelDbName) {
            switch (modelDbName) {
                case "raw_contacts": {
                    return RawContact.class;
                }
                case "data": {
                    return RawContactData.class;
                }
                case "external/images/media": {
                    return Image.class;
                }
                case "blocked": {
                    return BlockedNumber.class;
                }
                case "contacts": {
                    return Contact.class;
                }
            }
            throw new IllegalStateException("The modelDbName " + modelDbName + " is not a correct");
        }

        @NonNull
        public DbModelDescriptor getDbModelDescriptor(@NonNull Class<?> classDef) {
            if (classDef.isAssignableFrom(RawContact.class)) {
                return sRawContact;
            }
            if (classDef.isAssignableFrom(RawContactData.class)) {
                return sRawContactData;
            }
            if (classDef.isAssignableFrom(Image.class)) {
                return sImage;
            }
            if (classDef.isAssignableFrom(BlockedNumber.class)) {
                return sBlockedNumber;
            }
            if (classDef.isAssignableFrom(Contact.class)) {
                return sContact;
            }
            throw new IllegalStateException("Please ensure all SQL tables are annotated with @DbModel");
        }

        @NonNull
        public Class<?>[] getModelsForProvider(@Nullable Class<? extends DatabaseProvider> providerClass) {
            ArrayList<Class<Contact>> result = new ArrayList<Class<Contact>>();
            if (ContactContentDatabaseProvider.class.equals(providerClass)) {
                result.add(RawContact.class);
            }
            if (ContactContentDatabaseProvider.class.equals(providerClass)) {
                result.add(RawContactData.class);
            }
            if (MediaStoreContentDatabaseProvider.class.equals(providerClass)) {
                result.add(Image.class);
            }
            if (BlockedNumberContentDatabaseProvider.class.equals(providerClass)) {
                result.add(BlockedNumber.class);
            }
            if (ContactContentDatabaseProvider.class.equals(providerClass)) {
                result.add(Contact.class);
            }
            if (result.size() == 0) {
                throw new IllegalStateException("This provider does not have any @DbModel models registered into that resolver");
            }
            return result.toArray(new Class[result.size()]);
        }

        @Nullable
        public DatabaseProvider getDatabaseProviderForModel(@Nullable Class<?> model) {
            return mProviders.get(model);
        }
    }
}

