/*
 * Decompiled with CFR 0.152.
 */
package net.frju.androidquery.models.gen;

import android.content.ContentValues;
import android.database.Cursor;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.util.List;
import net.frju.androidquery.database.DatabaseProvider;
import net.frju.androidquery.database.DbModelDescriptor;
import net.frju.androidquery.database.Resolver;
import net.frju.androidquery.models.Image;
import net.frju.androidquery.models.gen.Q;
import net.frju.androidquery.operation.function.Count;
import net.frju.androidquery.operation.function.CursorResult;
import net.frju.androidquery.operation.function.Delete;
import net.frju.androidquery.operation.function.Insert;
import net.frju.androidquery.operation.function.Save;
import net.frju.androidquery.operation.function.Select;
import net.frju.androidquery.operation.function.Update;

public class IMAGE
implements DbModelDescriptor {
    public static final String ID = "_id";
    public static final String TITLE = "title";
    public static final String PATH = "_data";
    public static final String SIZE = "_size";
    public static final String DISPLAY_NAME = "_display_name";
    public static final String MIME_TYPE = "mime_type";
    public static final String WIDTH = "width";
    public static final String HEIGHT = "height";
    public static final String DESCRIPTION = "description";
    public static final String LATITUDE = "latitude";
    public static final String LONGITUDE = "longitude";
    public static final String DATE_TAKEN = "datetaken";
    public static final String ORIENTATION = "orientation";

    @NonNull
    public String getTableDbName() {
        return "external/images/media";
    }

    @NonNull
    public String getTableCreateQuery() {
        return "CREATE TABLE external/images/media (_id integer,title text,_data text,_size integer,_display_name text,mime_type text,width integer,height integer,description text,latitude real,longitude real,datetaken integer,orientation integer);";
    }

    @NonNull
    public String[] getColumnsSqlArray() {
        return new String[]{"_id integer", "title text", "_data text", "_size integer", "_display_name text", "mime_type text", "width integer", "height integer", "description text", "latitude real", "longitude real", "datetaken integer", "orientation integer"};
    }

    @Nullable
    public String getPrimaryKeyDbName() {
        return "";
    }

    @NonNull
    public String[] getIndexNames() {
        return new String[0];
    }

    @Nullable
    public String getCreateIndexQuery() {
        StringBuilder sb = new StringBuilder();
        return sb.length() > 0 ? sb.toString() : null;
    }

    @Nullable
    public Image getSingleResult(@Nullable Cursor cursor) {
        if (cursor != null) {
            Image image = new Image();
            for (int x = 0; x < cursor.getColumnCount(); ++x) {
                if (cursor.getColumnName(x).equals(ID)) {
                    image.id = cursor.getLong(x);
                    continue;
                }
                if (cursor.getColumnName(x).equals(TITLE)) {
                    image.title = cursor.getString(x);
                    continue;
                }
                if (cursor.getColumnName(x).equals(PATH)) {
                    image.path = cursor.getString(x);
                    continue;
                }
                if (cursor.getColumnName(x).equals(SIZE)) {
                    image.size = cursor.getLong(x);
                    continue;
                }
                if (cursor.getColumnName(x).equals(DISPLAY_NAME)) {
                    image.displayName = cursor.getString(x);
                    continue;
                }
                if (cursor.getColumnName(x).equals(MIME_TYPE)) {
                    image.mimeType = cursor.getString(x);
                    continue;
                }
                if (cursor.getColumnName(x).equals(WIDTH)) {
                    image.width = cursor.getInt(x);
                    continue;
                }
                if (cursor.getColumnName(x).equals(HEIGHT)) {
                    image.height = cursor.getInt(x);
                    continue;
                }
                if (cursor.getColumnName(x).equals(DESCRIPTION)) {
                    image.description = cursor.getString(x);
                    continue;
                }
                if (cursor.getColumnName(x).equals(LATITUDE)) {
                    image.latitude = cursor.getDouble(x);
                    continue;
                }
                if (cursor.getColumnName(x).equals(LONGITUDE)) {
                    image.longitude = cursor.getDouble(x);
                    continue;
                }
                if (cursor.getColumnName(x).equals(DATE_TAKEN)) {
                    image.dateTaken = cursor.getInt(x);
                    continue;
                }
                if (!cursor.getColumnName(x).equals(ORIENTATION)) continue;
                image.orientation = cursor.getInt(x);
            }
            return image;
        }
        return null;
    }

    @NonNull
    public Image[] getArrayResult(@Nullable Cursor cursor) {
        if (cursor != null) {
            Image[] result = new Image[cursor.getCount()];
            cursor.moveToFirst();
            int i = 0;
            while (!cursor.isAfterLast()) {
                result[i] = this.getSingleResult(cursor);
                cursor.moveToNext();
                ++i;
            }
            cursor.close();
            return result;
        }
        return new Image[0];
    }

    @NonNull
    public String[] getColumnNames() {
        return new String[]{ID, TITLE, PATH, SIZE, DISPLAY_NAME, MIME_TYPE, WIDTH, HEIGHT, DESCRIPTION, LATITUDE, LONGITUDE, DATE_TAKEN, ORIENTATION};
    }

    @NonNull
    public String[] getColumnNamesWithTablePrefix() {
        return new String[]{"external/images/media._id", "external/images/media.title", "external/images/media._data", "external/images/media._size", "external/images/media._display_name", "external/images/media.mime_type", "external/images/media.width", "external/images/media.height", "external/images/media.description", "external/images/media.latitude", "external/images/media.longitude", "external/images/media.datetaken", "external/images/media.orientation"};
    }

    @Nullable
    public Object getPrimaryKeyValue(@NonNull Object model) {
        Image image = (Image)model;
        return null;
    }

    public void setIdToModel(@NonNull Object model, long id) {
    }

    public boolean isPrimaryKeyAutoIncrement() {
        return false;
    }

    @NonNull
    public ContentValues getContentValues(@NonNull Object model) {
        Image image = (Image)model;
        ContentValues contentValues = new ContentValues();
        contentValues.put(ID, Long.valueOf(image.id));
        contentValues.put(TITLE, image.title);
        contentValues.put(PATH, image.path);
        contentValues.put(SIZE, Long.valueOf(image.size));
        contentValues.put(DISPLAY_NAME, image.displayName);
        contentValues.put(MIME_TYPE, image.mimeType);
        contentValues.put(WIDTH, Integer.valueOf(image.width));
        contentValues.put(HEIGHT, Integer.valueOf(image.height));
        contentValues.put(DESCRIPTION, image.description);
        contentValues.put(LATITUDE, Double.valueOf(image.latitude));
        contentValues.put(LONGITUDE, Double.valueOf(image.longitude));
        contentValues.put(DATE_TAKEN, Integer.valueOf(image.dateTaken));
        contentValues.put(ORIENTATION, Integer.valueOf(image.orientation));
        return contentValues;
    }

    @NonNull
    public static Uri getContentUri() {
        return Q.getResolver().getDatabaseProviderForModel(Image.class).getUri(Image.class, null);
    }

    @NonNull
    public static Count.Builder<Image> count() {
        return Count.getBuilder(Image.class, (DatabaseProvider)Q.getResolver().getDatabaseProviderForModel(Image.class));
    }

    @NonNull
    public static Select.Builder<Image> select() {
        return Select.getBuilder(Image.class, (DatabaseProvider)Q.getResolver().getDatabaseProviderForModel(Image.class));
    }

    @NonNull
    public static Delete.Builder<Image> delete() {
        return Delete.getBuilder(Image.class, (DatabaseProvider)Q.getResolver().getDatabaseProviderForModel(Image.class));
    }

    @NonNull
    public static Update.Builder<Image> update() {
        return Update.getBuilder(Image.class, (DatabaseProvider)Q.getResolver().getDatabaseProviderForModel(Image.class));
    }

    @NonNull
    public static Save.Builder<Image> save(Image ... models) {
        return Save.getBuilder((DatabaseProvider)Q.getResolver().getDatabaseProviderForModel(Image.class), (Object[])models);
    }

    @NonNull
    public static Save.Builder<Image> save(@NonNull List<Image> models) {
        return Save.getBuilder((DatabaseProvider)Q.getResolver().getDatabaseProviderForModel(Image.class), models);
    }

    @NonNull
    public static Insert.Builder<Image> insert(Image ... models) {
        return Insert.getBuilder((DatabaseProvider)Q.getResolver().getDatabaseProviderForModel(Image.class), (Object[])models);
    }

    @NonNull
    public static Insert.Builder<Image> insert(@NonNull List<Image> models) {
        return Insert.getBuilder((DatabaseProvider)Q.getResolver().getDatabaseProviderForModel(Image.class), models);
    }

    @NonNull
    public static CursorResult<Image> fromCursor(@Nullable Cursor cursor) {
        return new CursorResult(Image.class, (Resolver)Q.getResolver(), cursor);
    }
}

