/*
 * Decompiled with CFR 0.152.
 */
package net.frju.androidquery.models.gen;

import android.content.ContentValues;
import android.database.Cursor;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.util.List;
import net.frju.androidquery.converter.UriConverter;
import net.frju.androidquery.database.DatabaseProvider;
import net.frju.androidquery.database.DbModelDescriptor;
import net.frju.androidquery.database.Resolver;
import net.frju.androidquery.models.Contact;
import net.frju.androidquery.models.gen.Q;
import net.frju.androidquery.operation.function.Count;
import net.frju.androidquery.operation.function.CursorResult;
import net.frju.androidquery.operation.function.Delete;
import net.frju.androidquery.operation.function.Insert;
import net.frju.androidquery.operation.function.Save;
import net.frju.androidquery.operation.function.Select;
import net.frju.androidquery.operation.function.Update;

public class CONTACT
implements DbModelDescriptor {
    public static final String ID = "_id";
    public static final String DISPLAY_NAME = "display_name";
    public static final String PHOTO_URI = "photo_uri";
    public static final String PHOTO_THUMBNAIL_URI = "photo_thumb_uri";
    public static final String TIMES_CONTACTED = "times_contacted";
    public static final String LAST_TIME_CONTACTED = "last_time_contacted";
    public static final String STARRED = "starred";
    public static final String CUSTOM_RINGTONE = "custom_ringtone";
    public static final String LOOKUP_KEY = "lookup";
    public static final String IN_VISIBLE_GROUP = "in_visible_group";
    public static final String HAS_PHONE_NUMBER = "has_phone_number";

    @NonNull
    public String getTableDbName() {
        return "contacts";
    }

    @NonNull
    public String getTableCreateQuery() {
        return "CREATE TABLE contacts (_id integer PRIMARY KEY AUTOINCREMENT,display_name text,photo_uri text,photo_thumb_uri text,times_contacted integer,last_time_contacted integer,starred integer,custom_ringtone text,lookup text,in_visible_group integer,has_phone_number integer);";
    }

    @NonNull
    public String[] getColumnsSqlArray() {
        return new String[]{"_id integer PRIMARY KEY AUTOINCREMENT", "display_name text", "photo_uri text", "photo_thumb_uri text", "times_contacted integer", "last_time_contacted integer", "starred integer", "custom_ringtone text", "lookup text", "in_visible_group integer", "has_phone_number integer"};
    }

    @Nullable
    public String getPrimaryKeyDbName() {
        return ID;
    }

    @NonNull
    public String[] getIndexNames() {
        return new String[0];
    }

    @Nullable
    public String getCreateIndexQuery() {
        StringBuilder sb = new StringBuilder();
        return sb.length() > 0 ? sb.toString() : null;
    }

    @Nullable
    public Contact getSingleResult(@Nullable Cursor cursor) {
        if (cursor != null) {
            Contact contact = new Contact();
            for (int x = 0; x < cursor.getColumnCount(); ++x) {
                if (cursor.getColumnName(x).equals(ID)) {
                    contact.id = cursor.getLong(x);
                    continue;
                }
                if (cursor.getColumnName(x).equals(DISPLAY_NAME)) {
                    contact.displayName = cursor.getString(x);
                    continue;
                }
                if (cursor.getColumnName(x).equals(PHOTO_URI)) {
                    contact.photoUri = new UriConverter().convertFromDb(cursor.getString(x));
                    continue;
                }
                if (cursor.getColumnName(x).equals(PHOTO_THUMBNAIL_URI)) {
                    contact.photoThumbnailUri = new UriConverter().convertFromDb(cursor.getString(x));
                    continue;
                }
                if (cursor.getColumnName(x).equals(TIMES_CONTACTED)) {
                    contact.timesContacted = cursor.getInt(x);
                    continue;
                }
                if (cursor.getColumnName(x).equals(LAST_TIME_CONTACTED)) {
                    contact.lastTimeContacted = cursor.getInt(x);
                    continue;
                }
                if (cursor.getColumnName(x).equals(STARRED)) {
                    contact.starred = cursor.getInt(x) > 0;
                    continue;
                }
                if (cursor.getColumnName(x).equals(CUSTOM_RINGTONE)) {
                    contact.customRingtone = new UriConverter().convertFromDb(cursor.getString(x));
                    continue;
                }
                if (cursor.getColumnName(x).equals(LOOKUP_KEY)) {
                    contact.lookupKey = cursor.getString(x);
                    continue;
                }
                if (cursor.getColumnName(x).equals(IN_VISIBLE_GROUP)) {
                    contact.inVisibleGroup = cursor.getInt(x) > 0;
                    continue;
                }
                if (!cursor.getColumnName(x).equals(HAS_PHONE_NUMBER)) continue;
                contact.hasPhoneNumber = cursor.getInt(x) > 0;
            }
            return contact;
        }
        return null;
    }

    @NonNull
    public Contact[] getArrayResult(@Nullable Cursor cursor) {
        if (cursor != null) {
            Contact[] result = new Contact[cursor.getCount()];
            cursor.moveToFirst();
            int i = 0;
            while (!cursor.isAfterLast()) {
                result[i] = this.getSingleResult(cursor);
                cursor.moveToNext();
                ++i;
            }
            cursor.close();
            return result;
        }
        return new Contact[0];
    }

    @NonNull
    public String[] getColumnNames() {
        return new String[]{ID, DISPLAY_NAME, PHOTO_URI, PHOTO_THUMBNAIL_URI, TIMES_CONTACTED, LAST_TIME_CONTACTED, STARRED, CUSTOM_RINGTONE, LOOKUP_KEY, IN_VISIBLE_GROUP, HAS_PHONE_NUMBER};
    }

    @NonNull
    public String[] getColumnNamesWithTablePrefix() {
        return new String[]{"contacts._id", "contacts.display_name", "contacts.photo_uri", "contacts.photo_thumb_uri", "contacts.times_contacted", "contacts.last_time_contacted", "contacts.starred", "contacts.custom_ringtone", "contacts.lookup", "contacts.in_visible_group", "contacts.has_phone_number"};
    }

    @Nullable
    public Object getPrimaryKeyValue(@NonNull Object model) {
        Contact contact = (Contact)model;
        return contact.id;
    }

    public void setIdToModel(@NonNull Object model, long id) {
        Contact contact = (Contact)model;
        contact.id = id;
    }

    public boolean isPrimaryKeyAutoIncrement() {
        return true;
    }

    @NonNull
    public ContentValues getContentValues(@NonNull Object model) {
        Contact contact = (Contact)model;
        ContentValues contentValues = new ContentValues();
        contentValues.put(DISPLAY_NAME, contact.displayName);
        contentValues.put(PHOTO_URI, new UriConverter().convertToDb(contact.photoUri));
        contentValues.put(PHOTO_THUMBNAIL_URI, new UriConverter().convertToDb(contact.photoThumbnailUri));
        contentValues.put(TIMES_CONTACTED, Integer.valueOf(contact.timesContacted));
        contentValues.put(LAST_TIME_CONTACTED, Integer.valueOf(contact.lastTimeContacted));
        contentValues.put(STARRED, Boolean.valueOf(contact.starred));
        contentValues.put(CUSTOM_RINGTONE, new UriConverter().convertToDb(contact.customRingtone));
        contentValues.put(LOOKUP_KEY, contact.lookupKey);
        contentValues.put(IN_VISIBLE_GROUP, Boolean.valueOf(contact.inVisibleGroup));
        contentValues.put(HAS_PHONE_NUMBER, Boolean.valueOf(contact.hasPhoneNumber));
        return contentValues;
    }

    @NonNull
    public static Uri getContentUri() {
        return Q.getResolver().getDatabaseProviderForModel(Contact.class).getUri(Contact.class, null);
    }

    @NonNull
    public static Uri getContentUri(@Nullable Contact model) {
        return Q.getResolver().getDatabaseProviderForModel(Contact.class).getUri(Contact.class, Uri.encode((String)Long.valueOf(model.id).toString()));
    }

    @NonNull
    public static Count.Builder<Contact> count() {
        return Count.getBuilder(Contact.class, (DatabaseProvider)Q.getResolver().getDatabaseProviderForModel(Contact.class));
    }

    @NonNull
    public static Select.Builder<Contact> select() {
        return Select.getBuilder(Contact.class, (DatabaseProvider)Q.getResolver().getDatabaseProviderForModel(Contact.class));
    }

    @NonNull
    public static Delete.Builder<Contact> delete() {
        return Delete.getBuilder(Contact.class, (DatabaseProvider)Q.getResolver().getDatabaseProviderForModel(Contact.class));
    }

    @NonNull
    public static Update.Builder<Contact> update() {
        return Update.getBuilder(Contact.class, (DatabaseProvider)Q.getResolver().getDatabaseProviderForModel(Contact.class));
    }

    @NonNull
    public static Save.Builder<Contact> save(Contact ... models) {
        return Save.getBuilder((DatabaseProvider)Q.getResolver().getDatabaseProviderForModel(Contact.class), (Object[])models);
    }

    @NonNull
    public static Save.Builder<Contact> save(@NonNull List<Contact> models) {
        return Save.getBuilder((DatabaseProvider)Q.getResolver().getDatabaseProviderForModel(Contact.class), models);
    }

    @NonNull
    public static Insert.Builder<Contact> insert(Contact ... models) {
        return Insert.getBuilder((DatabaseProvider)Q.getResolver().getDatabaseProviderForModel(Contact.class), (Object[])models);
    }

    @NonNull
    public static Insert.Builder<Contact> insert(@NonNull List<Contact> models) {
        return Insert.getBuilder((DatabaseProvider)Q.getResolver().getDatabaseProviderForModel(Contact.class), models);
    }

    @NonNull
    public static CursorResult<Contact> fromCursor(@Nullable Cursor cursor) {
        return new CursorResult(Contact.class, (Resolver)Q.getResolver(), cursor);
    }
}

