/*
 * Decompiled with CFR 0.152.
 */
package net.frju.androidquery.models.gen;

import android.content.ContentValues;
import android.database.Cursor;
import android.net.Uri;
import android.support.annotation.NonNull;
import java.util.List;
import net.frju.androidquery.database.DatabaseProvider;
import net.frju.androidquery.database.DbModelDescriptor;
import net.frju.androidquery.database.Resolver;
import net.frju.androidquery.models.DataMimeTypeConverter;
import net.frju.androidquery.models.RawContactData;
import net.frju.androidquery.models.gen.Q;
import net.frju.androidquery.operation.function.Count;
import net.frju.androidquery.operation.function.CursorResult;
import net.frju.androidquery.operation.function.Delete;
import net.frju.androidquery.operation.function.Insert;
import net.frju.androidquery.operation.function.Save;
import net.frju.androidquery.operation.function.Select;
import net.frju.androidquery.operation.function.Update;

public class RAW_CONTACT_DATA
implements DbModelDescriptor {
    public static final String ID = "_id";
    public static final String RAW_CONTACT_ID = "raw_contact_id";
    public static final String MIME_TYPE = "mimetype";
    public static final String IS_PRIMARY = "is_primary";
    public static final String IS_SUPER_PRIMARY = "is_super_primary";
    public static final String DATA_VERSION = "data_version";
    public static final String DATA1 = "data1";
    public static final String DATA2 = "data2";
    public static final String DATA3 = "data3";
    public static final String DATA4 = "data4";
    public static final String DATA5 = "data5";
    public static final String DATA6 = "data6";
    public static final String DATA7 = "data7";
    public static final String DATA8 = "data8";
    public static final String DATA9 = "data9";
    public static final String DATA10 = "data10";
    public static final String DATA11 = "data11";
    public static final String DATA12 = "data12";
    public static final String DATA13 = "data13";
    public static final String DATA14 = "data14";
    public static final String DATA15 = "data15";

    @NonNull
    public String getTableDbName() {
        return "data";
    }

    @NonNull
    public String getTableCreateQuery() {
        return "CREATE TABLE data (_id integer PRIMARY KEY AUTOINCREMENT,raw_contact_id integer,mimetype text,is_primary integer,is_super_primary integer,data_version integer,data1 text,data2 text,data3 text,data4 text,data5 text,data6 text,data7 text,data8 text,data9 text,data10 text,data11 text,data12 text,data13 text,data14 text,data15 blob);";
    }

    @NonNull
    public String[] getColumnsSqlArray() {
        return new String[]{"_id integer PRIMARY KEY AUTOINCREMENT", "raw_contact_id integer", "mimetype text", "is_primary integer", "is_super_primary integer", "data_version integer", "data1 text", "data2 text", "data3 text", "data4 text", "data5 text", "data6 text", "data7 text", "data8 text", "data9 text", "data10 text", "data11 text", "data12 text", "data13 text", "data14 text", "data15 blob"};
    }

    public String getPrimaryKeyDbName() {
        return ID;
    }

    public String[] getIndexNames() {
        return new String[0];
    }

    public String getCreateIndexQuery() {
        StringBuilder sb = new StringBuilder();
        return sb.length() > 0 ? sb.toString() : null;
    }

    public RawContactData getSingleResult(Cursor cursor) {
        if (cursor != null) {
            RawContactData rawcontactdata = new RawContactData();
            for (int x = 0; x < cursor.getColumnCount(); ++x) {
                if (cursor.getColumnName(x).equals(ID)) {
                    rawcontactdata.id = cursor.getLong(x);
                    continue;
                }
                if (cursor.getColumnName(x).equals(RAW_CONTACT_ID)) {
                    rawcontactdata.rawContactId = cursor.getLong(x);
                    continue;
                }
                if (cursor.getColumnName(x).equals(MIME_TYPE)) {
                    rawcontactdata.mimeType = new DataMimeTypeConverter().convertFromDb(cursor.getString(x));
                    continue;
                }
                if (cursor.getColumnName(x).equals(IS_PRIMARY)) {
                    rawcontactdata.isPrimary = cursor.getInt(x) > 0;
                    continue;
                }
                if (cursor.getColumnName(x).equals(IS_SUPER_PRIMARY)) {
                    rawcontactdata.isSuperPrimary = cursor.getInt(x) > 0;
                    continue;
                }
                if (cursor.getColumnName(x).equals(DATA_VERSION)) {
                    rawcontactdata.dataVersion = cursor.getInt(x);
                    continue;
                }
                if (cursor.getColumnName(x).equals(DATA1)) {
                    rawcontactdata.data1 = cursor.getString(x);
                    continue;
                }
                if (cursor.getColumnName(x).equals(DATA2)) {
                    rawcontactdata.data2 = cursor.getString(x);
                    continue;
                }
                if (cursor.getColumnName(x).equals(DATA3)) {
                    rawcontactdata.data3 = cursor.getString(x);
                    continue;
                }
                if (cursor.getColumnName(x).equals(DATA4)) {
                    rawcontactdata.data4 = cursor.getString(x);
                    continue;
                }
                if (cursor.getColumnName(x).equals(DATA5)) {
                    rawcontactdata.data5 = cursor.getString(x);
                    continue;
                }
                if (cursor.getColumnName(x).equals(DATA6)) {
                    rawcontactdata.data6 = cursor.getString(x);
                    continue;
                }
                if (cursor.getColumnName(x).equals(DATA7)) {
                    rawcontactdata.data7 = cursor.getString(x);
                    continue;
                }
                if (cursor.getColumnName(x).equals(DATA8)) {
                    rawcontactdata.data8 = cursor.getString(x);
                    continue;
                }
                if (cursor.getColumnName(x).equals(DATA9)) {
                    rawcontactdata.data9 = cursor.getString(x);
                    continue;
                }
                if (cursor.getColumnName(x).equals(DATA10)) {
                    rawcontactdata.data10 = cursor.getString(x);
                    continue;
                }
                if (cursor.getColumnName(x).equals(DATA11)) {
                    rawcontactdata.data11 = cursor.getString(x);
                    continue;
                }
                if (cursor.getColumnName(x).equals(DATA12)) {
                    rawcontactdata.data12 = cursor.getString(x);
                    continue;
                }
                if (cursor.getColumnName(x).equals(DATA13)) {
                    rawcontactdata.data13 = cursor.getString(x);
                    continue;
                }
                if (cursor.getColumnName(x).equals(DATA14)) {
                    rawcontactdata.data14 = cursor.getString(x);
                    continue;
                }
                if (!cursor.getColumnName(x).equals(DATA15)) continue;
                rawcontactdata.data15 = cursor.getBlob(x);
            }
            return rawcontactdata;
        }
        return null;
    }

    public RawContactData[] getArrayResult(Cursor cursor) {
        if (cursor != null) {
            RawContactData[] result = new RawContactData[cursor.getCount()];
            cursor.moveToFirst();
            int i = 0;
            while (!cursor.isAfterLast()) {
                result[i] = this.getSingleResult(cursor);
                cursor.moveToNext();
                ++i;
            }
            cursor.close();
            return result;
        }
        return new RawContactData[0];
    }

    public String[] getColumnNames() {
        return new String[]{ID, RAW_CONTACT_ID, MIME_TYPE, IS_PRIMARY, IS_SUPER_PRIMARY, DATA_VERSION, DATA1, DATA2, DATA3, DATA4, DATA5, DATA6, DATA7, DATA8, DATA9, DATA10, DATA11, DATA12, DATA13, DATA14, DATA15};
    }

    public String[] getColumnNamesWithTablePrefix() {
        return new String[]{"data._id", "data.raw_contact_id", "data.mimetype", "data.is_primary", "data.is_super_primary", "data.data_version", "data.data1", "data.data2", "data.data3", "data.data4", "data.data5", "data.data6", "data.data7", "data.data8", "data.data9", "data.data10", "data.data11", "data.data12", "data.data13", "data.data14", "data.data15"};
    }

    public Object getPrimaryKeyValue(@NonNull Object model) {
        RawContactData rawcontactdata = (RawContactData)model;
        return rawcontactdata.id;
    }

    public void setIdToModel(@NonNull Object model, long id) {
        RawContactData rawcontactdata = (RawContactData)model;
        rawcontactdata.id = id;
    }

    public boolean isPrimaryKeyAutoIncrement() {
        return true;
    }

    @NonNull
    public ContentValues getContentValues(@NonNull Object model) {
        RawContactData rawcontactdata = (RawContactData)model;
        ContentValues contentValues = new ContentValues();
        contentValues.put(MIME_TYPE, new DataMimeTypeConverter().convertToDb(rawcontactdata.mimeType));
        contentValues.put(IS_PRIMARY, Boolean.valueOf(rawcontactdata.isPrimary));
        contentValues.put(IS_SUPER_PRIMARY, Boolean.valueOf(rawcontactdata.isSuperPrimary));
        contentValues.put(DATA_VERSION, Integer.valueOf(rawcontactdata.dataVersion));
        contentValues.put(DATA1, rawcontactdata.data1);
        contentValues.put(DATA2, rawcontactdata.data2);
        contentValues.put(DATA3, rawcontactdata.data3);
        contentValues.put(DATA4, rawcontactdata.data4);
        contentValues.put(DATA5, rawcontactdata.data5);
        contentValues.put(DATA6, rawcontactdata.data6);
        contentValues.put(DATA7, rawcontactdata.data7);
        contentValues.put(DATA8, rawcontactdata.data8);
        contentValues.put(DATA9, rawcontactdata.data9);
        contentValues.put(DATA10, rawcontactdata.data10);
        contentValues.put(DATA11, rawcontactdata.data11);
        contentValues.put(DATA12, rawcontactdata.data12);
        contentValues.put(DATA13, rawcontactdata.data13);
        contentValues.put(DATA14, rawcontactdata.data14);
        contentValues.put(DATA15, rawcontactdata.data15);
        return contentValues;
    }

    @NonNull
    public static Uri getContentUri() {
        return Q.getResolver().getDatabaseProviderForModel(RawContactData.class).getUri(RawContactData.class);
    }

    @NonNull
    public static Count.Builder<RawContactData> count() {
        return Count.getBuilder(RawContactData.class, (DatabaseProvider)Q.getResolver().getDatabaseProviderForModel(RawContactData.class));
    }

    @NonNull
    public static Select.Builder<RawContactData> select() {
        return Select.getBuilder(RawContactData.class, (DatabaseProvider)Q.getResolver().getDatabaseProviderForModel(RawContactData.class));
    }

    @NonNull
    public static Delete.Builder<RawContactData> delete() {
        return Delete.getBuilder(RawContactData.class, (DatabaseProvider)Q.getResolver().getDatabaseProviderForModel(RawContactData.class));
    }

    @NonNull
    public static Update.Builder<RawContactData> update() {
        return Update.getBuilder(RawContactData.class, (DatabaseProvider)Q.getResolver().getDatabaseProviderForModel(RawContactData.class));
    }

    @NonNull
    public static Save.Builder<RawContactData> save(RawContactData ... models) {
        return Save.getBuilder((DatabaseProvider)Q.getResolver().getDatabaseProviderForModel(RawContactData.class), (Object[])models);
    }

    @NonNull
    public static Save.Builder<RawContactData> save(@NonNull List<RawContactData> models) {
        return Save.getBuilder((DatabaseProvider)Q.getResolver().getDatabaseProviderForModel(RawContactData.class), models);
    }

    @NonNull
    public static Insert.Builder<RawContactData> insert(RawContactData ... models) {
        return Insert.getBuilder((DatabaseProvider)Q.getResolver().getDatabaseProviderForModel(RawContactData.class), (Object[])models);
    }

    @NonNull
    public static Insert.Builder<RawContactData> insert(@NonNull List<RawContactData> models) {
        return Insert.getBuilder((DatabaseProvider)Q.getResolver().getDatabaseProviderForModel(RawContactData.class), models);
    }

    @NonNull
    public static CursorResult<RawContactData> fromCursor(Cursor cursor) {
        return new CursorResult(RawContactData.class, (Resolver)Q.getResolver(), cursor);
    }
}

