package net.frju.androidquery.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Author: andrewgrosner
 * Description: Marks a class as being a TypeConverter. A type converter will turn a non-model, non-SQLiteTyped class into
 * a valid database type.
 */
@Retention(RetentionPolicy.SOURCE)
@Target(ElementType.TYPE)
public @interface TypeConverter {
    Class<?> dbClass();

    Class<?> modelClass();
}
