/*
 * Decompiled with CFR 0.152.
 */
package net.freeutils.tnef.msg;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.freeutils.tnef.GUID;
import net.freeutils.tnef.MAPIProp;
import net.freeutils.tnef.MAPIPropName;
import net.freeutils.tnef.MAPIValue;
import net.freeutils.tnef.RawInputStream;
import net.freeutils.tnef.TNEFUtils;
import net.freeutils.tnef.msg.Msg;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.DocumentEntry;
import org.apache.poi.poifs.filesystem.Entry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Properties {
    protected List<MAPIProp> props;
    protected int recipientCount;
    protected int attachmentCount;

    public MAPIProp[] toArray() {
        return this.props.toArray(new MAPIProp[this.props.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Properties processProperties(DirectoryEntry dir, int headerSize, Map<Integer, MAPIPropName> names) throws IOException {
        Properties properties = new Properties();
        Entry entry = dir.getEntry("__properties_version1.0");
        if (headerSize != 8 && headerSize != 24 && headerSize != 32) {
            throw new IOException("invalid header length: " + headerSize);
        }
        RawInputStream data = Msg.toRawInputStream((DocumentEntry)entry);
        try {
            if (data.getLength() > 0L) {
                data.readU64();
                if (headerSize > 8) {
                    int nextRecipientId = (int)data.readU32();
                    int nextAttachmentId = (int)data.readU32();
                    properties.recipientCount = (int)data.readU32();
                    properties.attachmentCount = (int)data.readU32();
                    if (headerSize > 24) {
                        data.readU64();
                    }
                }
            }
            properties.props = Properties.processPropertyList(data);
            properties.props.addAll(Properties.processPropertyEntries(dir));
        }
        finally {
            data.close();
        }
        Properties.translateNames(properties.props, names);
        return properties;
    }

    protected static List<MAPIProp> processPropertyList(RawInputStream data) throws IOException {
        ArrayList<MAPIProp> props = new ArrayList<MAPIProp>();
        while (data.available() > 0) {
            int type = data.readU16();
            int id = data.readU16();
            data.readU32();
            int typeSize = MAPIProp.getTypeSize(type &= 0xFFFFEFFF);
            if (typeSize >= 0 && typeSize <= 8) {
                MAPIValue val = new MAPIValue(type, data, typeSize);
                props.add(new MAPIProp(type, id, val));
                data.skip(-typeSize & 7);
                continue;
            }
            data.readU32();
            data.readU32();
        }
        return props;
    }

    protected static List<MAPIProp> processPropertyEntries(DirectoryEntry dir) throws IOException {
        ArrayList<MAPIProp> props = new ArrayList<MAPIProp>();
        for (Entry entry : dir) {
            if (!(entry instanceof DocumentEntry) || entry.getName().length() != 20 || !entry.getName().toLowerCase().startsWith("__substg1.0_")) continue;
            props.add(Properties.processProperty((DocumentEntry)entry));
        }
        return props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static MAPIProp processProperty(DocumentEntry entry) throws IOException {
        MAPIValue[] vals;
        String name = entry.getName();
        int id = Integer.parseInt(name.substring(12, 16), 16);
        int type = Integer.parseInt(name.substring(16, 20), 16);
        boolean isMultivalue = (type & 0x1000) != 0;
        type &= 0xFFFFEFFF;
        RawInputStream data = Msg.toRawInputStream(entry);
        try {
            if (!isMultivalue) {
                vals = new MAPIValue[]{new MAPIValue(type, data, (int)data.getLength())};
            } else {
                int typeSize = MAPIProp.getTypeSize(type);
                ArrayList<MAPIValue> list = new ArrayList<MAPIValue>();
                while (data.available() > 0) {
                    if (typeSize > -1) {
                        list.add(new MAPIValue(type, data, typeSize));
                        continue;
                    }
                    long length = data.readU32();
                    if (type == 258) {
                        data.readU32();
                    }
                    String valEntryName = entry.getName() + "-" + TNEFUtils.toHexString(list.size(), 8);
                    DocumentEntry valEntry = (DocumentEntry)entry.getParent().getEntry(valEntryName);
                    RawInputStream valData = Msg.toRawInputStream(valEntry);
                    try {
                        list.add(new MAPIValue(type, valData, (int)valData.getLength()));
                    }
                    finally {
                        valData.close();
                    }
                }
                vals = list.toArray(new MAPIValue[list.size()]);
            }
        }
        finally {
            data.close();
        }
        return new MAPIProp(type, id, vals);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Map<Integer, MAPIPropName> processNameIDs(DirectoryEntry dir) throws IOException {
        byte[] nameStrings;
        DirectoryEntry entry = (DirectoryEntry)dir.getEntry("__nameid_version1.0");
        ArrayList<GUID> guids = new ArrayList<GUID>();
        guids.add(null);
        guids.add(MAPIProp.PS_MAPI);
        guids.add(MAPIProp.PS_PUBLIC_STRINGS);
        MAPIProp guidsProp = Properties.processProperty((DocumentEntry)entry.getEntry("__substg1.0_00020102"));
        RawInputStream guidsData = (RawInputStream)guidsProp.getValue();
        try {
            while (guidsData.available() > 0) {
                guids.add(new GUID(guidsData.readBytes(16)));
            }
        }
        finally {
            guidsData.close();
        }
        MAPIProp namesProp = Properties.processProperty((DocumentEntry)entry.getEntry("__substg1.0_00040102"));
        RawInputStream namesData = (RawInputStream)namesProp.getValue();
        try {
            nameStrings = namesData.toByteArray();
        }
        finally {
            namesData.close();
        }
        HashMap<Integer, MAPIPropName> names = new HashMap<Integer, MAPIPropName>();
        MAPIProp propsProp = Properties.processProperty((DocumentEntry)entry.getEntry("__substg1.0_00030102"));
        RawInputStream propsData = (RawInputStream)propsProp.getValue();
        try {
            while (propsData.available() > 0) {
                MAPIPropName propName;
                byte[] item = propsData.readBytes(8);
                int idOrOffset = (int)TNEFUtils.getU32(item, 0);
                int guidIndex = TNEFUtils.getU16(item, 4);
                GUID guid = (GUID)guids.get(guidIndex >> 1);
                if ((guidIndex & 1) == 1) {
                    int len = (int)TNEFUtils.getU32(nameStrings, idOrOffset);
                    String nameStr = TNEFUtils.createStringUnicode(nameStrings, idOrOffset + 4, len);
                    propName = new MAPIPropName(guid, nameStr);
                } else {
                    propName = new MAPIPropName(guid, idOrOffset);
                }
                int index = TNEFUtils.getU16(item, 6);
                names.put(32768 + index, propName);
            }
        }
        finally {
            propsData.close();
        }
        return names;
    }

    protected static void translateNames(List<MAPIProp> props, Map<Integer, MAPIPropName> names) {
        if (names != null) {
            for (MAPIProp prop : props) {
                MAPIPropName name = names.get(prop.getID());
                if (name == null) continue;
                prop.setName(name);
            }
        }
    }
}

