/*
 * Decompiled with CFR 0.152.
 */
package net.freeutils.tnef;

import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.TimeZone;
import net.freeutils.tnef.RawInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TNEFUtils {
    public static int getU8(byte[] buf, int offset) {
        return buf[offset] & 0xFF;
    }

    public static int getU16(int b1, int b2) {
        return b1 & 0xFF | (b2 & 0xFF) << 8;
    }

    public static int getU16(byte[] buf, int offset) {
        return buf[offset] & 0xFF | (buf[offset + 1] & 0xFF) << 8;
    }

    public static long getU32(int b1, int b2, int b3, int b4) {
        return (long)(b1 & 0xFF | (b2 & 0xFF) << 8 | (b3 & 0xFF) << 16 | (b4 & 0xFF) << 24) & 0xFFFFFFFFL;
    }

    public static long getU32(byte[] buf, int offset) {
        return (long)(buf[offset] & 0xFF | (buf[offset + 1] & 0xFF) << 8 | (buf[offset + 2] & 0xFF) << 16 | (buf[offset + 3] & 0xFF) << 24) & 0xFFFFFFFFL;
    }

    public static long getU64(byte[] buf, int offset) {
        return (TNEFUtils.getU32(buf, offset + 4) & 0xFFFFFFFFL) << 32 | TNEFUtils.getU32(buf, offset) & 0xFFFFFFFFL;
    }

    public static int attribute(int atp, int id) {
        return atp << 16 | id;
    }

    public static int attID(int att) {
        return att & 0xFFFF;
    }

    public static int attType(int att) {
        return att >>> 16;
    }

    public static int calculateChecksum(byte[] data) {
        return TNEFUtils.calculateChecksum(data, 0, data.length);
    }

    public static int calculateChecksum(byte[] data, int offset, int length) {
        int checksum = 0;
        length += offset;
        for (int i = offset; i < length; ++i) {
            checksum += data[i] & 0xFF;
        }
        return checksum & 0xFFFF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int calculateChecksum(RawInputStream ris) throws IOException {
        int checksum = 0;
        RawInputStream r = new RawInputStream(ris);
        try {
            int read;
            byte[] buf = new byte[4096];
            while ((read = r.read(buf)) != -1) {
                checksum += TNEFUtils.calculateChecksum(buf, 0, read);
            }
        }
        finally {
            r.close();
        }
        return checksum & 0xFFFF;
    }

    public static String getConstName(Class cls, String constPrefix, long value) {
        try {
            for (Field field : cls.getFields()) {
                if (!field.getName().startsWith(constPrefix) || field.getLong(null) != value) continue;
                return field.getName();
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return "0x" + Long.toHexString(value);
    }

    public static String removeTerminatingNulls(String s) {
        int len;
        if (s == null) {
            return null;
        }
        for (len = s.length(); len > 0 && s.charAt(len - 1) == '\u0000'; --len) {
        }
        return len == s.length() ? s : s.substring(0, len);
    }

    public static String replace(String s, String search, String replace) {
        if (s == null || search == null || search.length() == 0) {
            return s;
        }
        if (replace == null) {
            replace = "";
        }
        int len = s.length();
        int slen = search.length();
        int rlen = replace.length();
        for (int ind = 0; ind < len && (ind = s.indexOf(search, ind)) > -1; ind += rlen) {
            s = s.substring(0, ind) + replace + s.substring(ind + slen);
        }
        return s;
    }

    public static String createString(byte[] bytes, int offset, int length) {
        try {
            return TNEFUtils.removeTerminatingNulls(new String(bytes, offset, length, "ISO8859_1"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return "";
        }
    }

    public static String createStringUnicode(byte[] bytes, int offset, int length) {
        try {
            return TNEFUtils.removeTerminatingNulls(new String(bytes, offset, length, "UTF-16LE"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return "";
        }
    }

    public static StringBuilder appendHexString(StringBuilder sb, int i, int len) {
        String s = Integer.toHexString(i).toUpperCase();
        len -= s.length();
        while (len-- > 0) {
            sb.append('0');
        }
        return sb.append(s);
    }

    public static String toHexString(int i, int len) {
        return TNEFUtils.appendHexString(new StringBuilder(8), i, len).toString();
    }

    public static String toHexString(byte[] bytes) {
        return TNEFUtils.toHexString(bytes, 0, bytes != null ? bytes.length : 0, -1);
    }

    public static String toHexString(byte[] bytes, int max) {
        return TNEFUtils.toHexString(bytes, 0, bytes != null ? bytes.length : 0, max);
    }

    public static String toHexString(byte[] bytes, int offset, int len, int max) {
        if (bytes == null) {
            return "[null]";
        }
        int count = max > -1 && max < len ? max : len;
        StringBuilder s = new StringBuilder(2 * count + 20);
        s.append('[');
        for (int i = 0; i < count; ++i) {
            TNEFUtils.appendHexString(s, bytes[offset + i] & 0xFF, 2);
        }
        if (count < len) {
            s.append("... (").append(len).append(" bytes)");
        }
        s.append(']');
        return s.toString();
    }

    public static String formatDate(long time, String format) {
        SimpleDateFormat df = new SimpleDateFormat(format);
        df.setTimeZone(TimeZone.getTimeZone("GMT"));
        return df.format(time);
    }

    public static boolean isTNEFMimeType(String mimeType) {
        return mimeType != null && ((mimeType = mimeType.toLowerCase()).startsWith("application/ms-tnef") || mimeType.startsWith("application/vnd.ms-tnef"));
    }

    public static int read(InputStream in, byte[] b, int off, int min, int max) throws IOException {
        int total;
        int read;
        if (min > max) {
            throw new IllegalArgumentException("min is greater than max");
        }
        int remaining = b.length - off;
        if (min > remaining) {
            throw new IndexOutOfBoundsException("available array space is smaller than min");
        }
        if (max > remaining) {
            max = remaining;
        }
        for (total = 0; total < min; total += read) {
            read = in.read(b, off + total, max - total);
            if (read >= 0) continue;
            throw new EOFException("Unexpected end of stream");
        }
        return total;
    }

    public static byte[] readSafely(InputStream in, int length, int initialBufferLength) throws IOException {
        byte[] b = new byte[Math.min(length, Math.max(initialBufferLength, 4096))];
        int remaining = length;
        while (remaining > 0) {
            int block;
            if ((remaining -= TNEFUtils.read(in, b, b.length - (block = b.length - (length - remaining)), block, block)) <= 0) continue;
            byte[] temp = new byte[b.length + Math.min(remaining, b.length)];
            System.arraycopy(b, 0, temp, 0, b.length);
            b = temp;
        }
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long transfer(InputStream in, OutputStream out, long maxLength, boolean closeIn, boolean closeOut) throws IOException {
        long len;
        byte[] buf = new byte[4096];
        try {
            int count;
            for (len = maxLength; len != 0L; len -= (long)count) {
                count = len < 0L || (long)buf.length < len ? buf.length : (int)len;
                if ((count = in.read(buf, 0, count)) == -1) {
                    break;
                }
                out.write(buf, 0, count);
            }
        }
        finally {
            if (closeIn) {
                in.close();
            }
            if (closeOut) {
                out.close();
            }
        }
        return maxLength - len;
    }

    public static <T extends Closeable> void closeAll(Collection<T> closeables) throws IOException {
        if (closeables != null && !closeables.isEmpty()) {
            TNEFUtils.closeAll((Closeable[])closeables.toArray(new Closeable[closeables.size()]));
        }
    }

    public static <T extends Closeable> void closeAll(T ... closeables) throws IOException {
        if (closeables != null) {
            Throwable error = null;
            for (T closeable : closeables) {
                try {
                    if (closeable == null) continue;
                    closeable.close();
                }
                catch (Throwable t) {
                    error = t;
                }
            }
            if (error != null) {
                IOException throwable = new IOException();
                throwable.initCause(error);
                throw throwable;
            }
        }
    }
}

