/*
 * Decompiled with CFR 0.152.
 */
package net.freeutils.tnef;

import java.io.IOException;
import net.freeutils.tnef.GUID;
import net.freeutils.tnef.RawInputStream;

public class MAPIPropName {
    public static final int MNID_ID = 0;
    public static final int MNID_STRING = 1;
    GUID guid;
    int type;
    long id;
    String name;
    int rawLength;

    public MAPIPropName(RawInputStream data) throws IOException {
        long startOffset = data.getPosition();
        this.guid = new GUID(data.readBytes(16));
        this.type = (int)data.readU32();
        if (this.type == 1) {
            int length = (int)data.readU32();
            this.name = data.readStringUnicode(length);
            data.skip(-length & 3);
        } else if (this.type == 0) {
            this.id = data.readU32();
        } else {
            throw new IOException("invalid type: " + this.type);
        }
        this.rawLength = (int)(data.getPosition() - startOffset);
    }

    public MAPIPropName(GUID guid, long id) {
        this.guid = guid;
        this.type = 0;
        this.id = id;
    }

    public MAPIPropName(GUID guid, String name) {
        this.guid = guid;
        this.type = 1;
        this.name = name;
    }

    public GUID getGUID() {
        return this.guid;
    }

    public int getType() {
        return this.type;
    }

    public long getID() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    protected int getRawLength() {
        return this.rawLength;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("[GUID=").append(this.guid);
        if (this.type == 1) {
            s.append(" name=").append(this.name);
        } else {
            s.append(" id=0x").append(Long.toHexString(this.id));
        }
        return s.append(']').toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MAPIPropName)) {
            return false;
        }
        MAPIPropName p = (MAPIPropName)o;
        return this.type == p.type && (this.type == 0 ? this.id == p.id : this.name.equals(p.name)) && this.guid.equals(p.guid);
    }

    public int hashCode() {
        int result = 17;
        result = result * 37 + this.type;
        result = result * 37 + this.guid.hashCode();
        if (this.type == 0) {
            result = result * 37 + (int)(this.id ^ this.id >>> 32);
        }
        if (this.type == 1 && this.name != null) {
            result = result * 37 + this.name.hashCode();
        }
        return result;
    }
}

