/*
 * Decompiled with CFR 0.152.
 */
package net.freeutils.tnef;

import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import net.freeutils.tnef.GUID;
import net.freeutils.tnef.MAPIPropName;
import net.freeutils.tnef.MAPIValue;
import net.freeutils.tnef.RawInputStream;
import net.freeutils.tnef.TNEFUtils;

public class MAPIProp
implements Closeable {
    public static final int MV_FLAG = 4096;
    public static final int PT_UNSPECIFIED = 0;
    public static final int PT_NULL = 1;
    public static final int PT_SHORT = 2;
    public static final int PT_INT = 3;
    public static final int PT_FLOAT = 4;
    public static final int PT_DOUBLE = 5;
    public static final int PT_CURRENCY = 6;
    public static final int PT_APPTIME = 7;
    public static final int PT_ERROR = 10;
    public static final int PT_BOOLEAN = 11;
    public static final int PT_OBJECT = 13;
    public static final int PT_INT8BYTE = 20;
    public static final int PT_STRING = 30;
    public static final int PT_UNICODE_STRING = 31;
    public static final int PT_SYSTIME = 64;
    public static final int PT_CLSID = 72;
    public static final int PT_BINARY = 258;
    public static final int MAPI_ORIG = 0;
    public static final int MAPI_TO = 1;
    public static final int MAPI_CC = 2;
    public static final int MAPI_BCC = 3;
    public static final int MAPI_P1 = 0x10000000;
    public static final int MAPI_SUBMITTED = Integer.MIN_VALUE;
    public static final GUID IID_ISTORAGE = new GUID("0000000b-0000-0000-c000-000000000046");
    public static final GUID IID_ISTREAM = new GUID("0000000c-0000-0000-c000-000000000046");
    public static final GUID IID_IMESSAGE = new GUID("00020307-0000-0000-c000-000000000046");
    public static final GUID PS_MAPI = new GUID("00020328-0000-0000-c000-000000000046");
    public static final GUID PS_PUBLIC_STRINGS = new GUID("00020329-0000-0000-c000-000000000046");
    public static final GUID PS_INTERNET_HEADERS = new GUID("00020386-0000-0000-c000-000000000046");
    public static final GUID PSETID_Appointment = new GUID("00062002-0000-0000-c000-000000000046");
    public static final GUID PSETID_Task = new GUID("00062003-0000-0000-c000-000000000046");
    public static final GUID PSETID_Address = new GUID("00062004-0000-0000-c000-000000000046");
    public static final GUID PSETID_Common = new GUID("00062008-0000-0000-c000-000000000046");
    public static final GUID PSETID_Log = new GUID("0006200a-0000-0000-c000-000000000046");
    public static final GUID PSETID_Note = new GUID("0006200e-0000-0000-c000-000000000046");
    public static final GUID PSETID_Sharing = new GUID("00062040-0000-0000-c000-000000000046");
    public static final GUID PSETID_PostRss = new GUID("00062041-0000-0000-c000-000000000046");
    public static final GUID PSETID_CalendarAssistant = new GUID("11000e07-b51b-40d6-af21-caa85edab1d0");
    public static final GUID PSETID_XmlExtractedEntities = new GUID("23239608-685d-4732-9c55-4c95cb4e8e33");
    public static final GUID PSETID_Messaging = new GUID("41f28f13-83f4-4114-a584-eedb5a6b0bff");
    public static final GUID PSETID_UnifiedMessaging = new GUID("4442858e-a9e3-4e80-b900-317a210cc15b");
    public static final GUID PSETID_Meeting = new GUID("6ed8da90-450b-101b-98da-00aa003f1305");
    public static final GUID PSETID_AirSync = new GUID("71035549-0739-4dcb-9163-00f0580dbbdf");
    public static final GUID PSETID_Attachment = new GUID("96357f7f-59e1-47d0-99a7-46515c183b54");
    int type;
    int id;
    MAPIPropName name;
    MAPIValue[] values;
    public static final int PR_ACKNOWLEDGEMENT_MODE = 1;
    public static final int PR_EMS_TEMPLATE_BLOB = 1;
    public static final int PR_ALTERNATE_RECIPIENT_ALLOWED = 2;
    public static final int PR_AUTHORIZING_USERS = 3;
    public static final int PR_AUTO_FORWARD_COMMENT = 4;
    public static final int PR_EMS_SCRIPT_BLOB = 4;
    public static final int PR_AUTO_FORWARDED = 5;
    public static final int PR_CONTENT_CONFIDENTIALITY_ALGORITHM_ID = 6;
    public static final int PR_CONTENT_CORRELATOR = 7;
    public static final int PR_CONTENT_IDENTIFIER = 8;
    public static final int PR_CONTENT_LENGTH = 9;
    public static final int PR_CONTENT_RETURN_REQUESTED = 10;
    public static final int PR_CONVERSATION_KEY = 11;
    public static final int PR_CONVERSION_EITS = 12;
    public static final int PR_CONVERSION_WITH_LOSS_PROHIBITED = 13;
    public static final int PR_CONVERTED_EITS = 14;
    public static final int PR_DEFERRED_DELIVERY_TIME = 15;
    public static final int PR_DELIVER_TIME = 16;
    public static final int PR_DISCARD_REASON = 17;
    public static final int PR_DISCLOSURE_OF_RECIPIENTS = 18;
    public static final int PR_DL_EXPANSION_HISTORY = 19;
    public static final int PR_DL_EXPANSION_PROHIBITED = 20;
    public static final int PR_EXPIRY_TIME = 21;
    public static final int PR_IMPLICIT_CONVERSION_PROHIBITED = 22;
    public static final int PR_IMPORTANCE = 23;
    public static final int PR_IPM_ID = 24;
    public static final int PR_LATEST_DELIVERY_TIME = 25;
    public static final int PR_MESSAGE_CLASS = 26;
    public static final int PR_MESSAGE_DELIVERY_ID = 27;
    public static final int PR_MESSAGE_SECURITY_LABEL = 30;
    public static final int PR_OBSOLETED_IPMS = 31;
    public static final int PR_ORIGINALLY_INTENDED_RECIPIENT_NAME = 32;
    public static final int PR_ORIGINAL_EITS = 33;
    public static final int PR_ORIGINATOR_CERTIFICATE = 34;
    public static final int PR_ORIGINATOR_DELIVERY_REPORT_REQUESTED = 35;
    public static final int PR_ORIGINATOR_RETURN_ADDRESS = 36;
    public static final int PR_PARENT_KEY = 37;
    public static final int PR_PRIORITY = 38;
    public static final int PR_ORIGIN_CHECK = 39;
    public static final int PR_PROOF_OF_SUBMISSION_REQUESTED = 40;
    public static final int PR_READ_RECEIPT_REQUESTED = 41;
    public static final int PR_RECEIPT_TIME = 42;
    public static final int PR_RECIPIENT_REASSIGNMENT_PROHIBITED = 43;
    public static final int PR_REDIRECTION_HISTORY = 44;
    public static final int PR_RELATED_IPMS = 45;
    public static final int PR_ORIGINAL_SENSITIVITY = 46;
    public static final int PR_LANGUAGES = 47;
    public static final int PR_REPLY_TIME = 48;
    public static final int PR_REPORT_TAG = 49;
    public static final int PR_REPORT_TIME = 50;
    public static final int PR_RETURNED_IPM = 51;
    public static final int PR_SECURITY = 52;
    public static final int PR_INCOMPLETE_COPY = 53;
    public static final int PR_SENSITIVITY = 54;
    public static final int PR_SUBJECT = 55;
    public static final int PR_SUBJECT_IPM = 56;
    public static final int PR_CLIENT_SUBMIT_TIME = 57;
    public static final int PR_REPORT_NAME = 58;
    public static final int PR_SENT_REPRESENTING_SEARCH_KEY = 59;
    public static final int PR_X400_CONTENT_TYPE = 60;
    public static final int PR_SUBJECT_PREFIX = 61;
    public static final int PR_NON_RECEIPT_REASON = 62;
    public static final int PR_RECEIVED_BY_ENTRYID = 63;
    public static final int PR_RECEIVED_BY_NAME = 64;
    public static final int PR_SENT_REPRESENTING_ENTRYID = 65;
    public static final int PR_SENT_REPRESENTING_NAME = 66;
    public static final int PR_RCVD_REPRESENTING_ENTRYID = 67;
    public static final int PR_RCVD_REPRESENTING_NAME = 68;
    public static final int PR_REPORT_ENTRYID = 69;
    public static final int PR_READ_RECEIPT_ENTRYID = 70;
    public static final int PR_MESSAGE_SUBMISSION_ID = 71;
    public static final int PR_MTS_ID = 71;
    public static final int PR_MTS_REPORT_ID = 71;
    public static final int PR_PROVIDER_SUBMIT_TIME = 72;
    public static final int PR_ORIGINAL_SUBJECT = 73;
    public static final int PR_DISC_VAL = 74;
    public static final int PR_ORIG_MESSAGE_CLASS = 75;
    public static final int PR_ORIGINAL_AUTHOR_ENTRYID = 76;
    public static final int PR_ORIGINAL_AUTHOR_NAME = 77;
    public static final int PR_ORIGINAL_SUBMIT_TIME = 78;
    public static final int PR_REPLY_RECIPIENT_ENTRIES = 79;
    public static final int PR_REPLY_RECIPIENT_NAMES = 80;
    public static final int PR_RECEIVED_BY_SEARCH_KEY = 81;
    public static final int PR_RCVD_REPRESENTING_SEARCH_KEY = 82;
    public static final int PR_READ_RECEIPT_SEARCH_KEY = 83;
    public static final int PR_REPORT_SEARCH_KEY = 84;
    public static final int PR_ORIGINAL_DELIVERY_TIME = 85;
    public static final int PR_ORIGINAL_AUTHOR_SEARCH_KEY = 86;
    public static final int PR_MESSAGE_TO_ME = 87;
    public static final int PR_MESSAGE_CC_ME = 88;
    public static final int PR_MESSAGE_RECIP_ME = 89;
    public static final int PR_ORIGINAL_SENDER_NAME = 90;
    public static final int PR_ORIGINAL_SENDER_ENTRYID = 91;
    public static final int PR_ORIGINAL_SENDER_SEARCH_KEY = 92;
    public static final int PR_ORIGINAL_SENT_REPRESENTING_NAME = 93;
    public static final int PR_ORIGINAL_SENT_REPRESENTING_ENTRYID = 94;
    public static final int PR_ORIGINAL_SENT_REPRESENTING_SEARCH_KEY = 95;
    public static final int PR_START_DATE = 96;
    public static final int PR_END_DATE = 97;
    public static final int PR_OWNER_APPT_ID = 98;
    public static final int PR_RESPONSE_REQUESTED = 99;
    public static final int PR_SENT_REPRESENTING_ADDRTYPE = 100;
    public static final int PR_SENT_REPRESENTING_EMAIL_ADDRESS = 101;
    public static final int PR_ORIGINAL_SENDER_ADDRTYPE = 102;
    public static final int PR_ORIGINAL_SENDER_EMAIL_ADDRESS = 103;
    public static final int PR_ORIGINAL_SENT_REPRESENTING_ADDRTYPE = 104;
    public static final int PR_ORIGINAL_SENT_REPRESENTING_EMAIL_ADDRESS = 105;
    public static final int PR_CONVERSATION_TOPIC = 112;
    public static final int PR_CONVERSATION_INDEX = 113;
    public static final int PR_ORIGINAL_DISPLAY_BCC = 114;
    public static final int PR_ORIGINAL_DISPLAY_CC = 115;
    public static final int PR_ORIGINAL_DISPLAY_TO = 116;
    public static final int PR_RECEIVED_BY_ADDRTYPE = 117;
    public static final int PR_RECEIVED_BY_EMAIL_ADDRESS = 118;
    public static final int PR_RCVD_REPRESENTING_ADDRTYPE = 119;
    public static final int PR_RCVD_REPRESENTING_EMAIL_ADDRESS = 120;
    public static final int PR_ORIGINAL_AUTHOR_ADDRTYPE = 121;
    public static final int PR_ORIGINAL_AUTHOR_EMAIL_ADDRESS = 122;
    public static final int PR_ORIGINALLY_INTENDED_RECIP_ADDRTYPE = 123;
    public static final int PR_ORIGINALLY_INTENDED_RECIP_EMAIL_ADDRESS = 124;
    public static final int PR_TRANSPORT_MESSAGE_HEADERS = 125;
    public static final int PR_DELEGATION = 126;
    public static final int PR_TNEF_CORRELATION_KEY = 127;
    public static final int PR_EMS_AB_ROOM_CAPACITY = 2055;
    public static final int PR_EMS_AB_ROOM_DESCRIPTION = 2057;
    public static final int PR_CONTENT_INTEGRITY_CHECK = 3072;
    public static final int PR_EXPLICIT_CONVERSION = 3073;
    public static final int PR_IPM_RETURN_REQUESTED = 3074;
    public static final int PR_MESSAGE_TOKEN = 3075;
    public static final int PR_NDR_REASON_CODE = 3076;
    public static final int PR_NDR_DIAG_CODE = 3077;
    public static final int PR_NON_RECEIPT_NOTIFICATION_REQUESTED = 3078;
    public static final int PR_DELIVERY_POINT = 3079;
    public static final int PR_ORIGINATOR_NON_DELIVERY_REPORT_REQUESTED = 3080;
    public static final int PR_ORIGINATOR_REQUESTED_ALTERNATE_RECIPIENT = 3081;
    public static final int PR_PHYSICAL_DELIVERY_BUREAU_FAX_DELIVERY = 3082;
    public static final int PR_PHYSICAL_DELIVERY_MODE = 3083;
    public static final int PR_PHYSICAL_DELIVERY_REPORT_REQUEST = 3084;
    public static final int PR_PHYSICAL_FORWARDING_ADDRESS = 3085;
    public static final int PR_PHYSICAL_FORWARDING_ADDRESS_REQUESTED = 3086;
    public static final int PR_PHYSICAL_FORWARDING_PROHIBITED = 3087;
    public static final int PR_PHYSICAL_RENDITION_ATTRIBUTES = 3088;
    public static final int PR_PROOF_OF_DELIVERY = 3089;
    public static final int PR_PROOF_OF_DELIVERY_REQUESTED = 3090;
    public static final int PR_RECIPIENT_CERTIFICATE = 3091;
    public static final int PR_RECIPIENT_NUMBER_FOR_ADVICE = 3092;
    public static final int PR_RECIPIENT_TYPE = 3093;
    public static final int PR_REGISTERED_MAIL_TYPE = 3094;
    public static final int PR_REPLY_REQUESTED = 3095;
    public static final int PR_REQUESTED_DELIVERY_METHOD = 3096;
    public static final int PR_SENDER_ENTRYID = 3097;
    public static final int PR_SENDER_NAME = 3098;
    public static final int PR_SUPPLEMENTARY_INFO = 3099;
    public static final int PR_TYPE_OF_MTS_USER = 3100;
    public static final int PR_SENDER_SEARCH_KEY = 3101;
    public static final int PR_SENDER_ADDRTYPE = 3102;
    public static final int PR_SENDER_EMAIL_ADDRESS = 3103;
    public static final int PR_NDR_STATUS_CODE = 3104;
    public static final int PR_DSN_REMOTE_MTA = 3105;
    public static final int PR_CURRENT_VERSION = 3584;
    public static final int PR_DELETE_AFTER_SUBMIT = 3585;
    public static final int PR_DISPLAY_BCC = 3586;
    public static final int PR_DISPLAY_CC = 3587;
    public static final int PR_DISPLAY_TO = 3588;
    public static final int PR_PARENT_DISPLAY = 3589;
    public static final int PR_MESSAGE_DELIVERY_TIME = 3590;
    public static final int PR_MESSAGE_FLAGS = 3591;
    public static final int PR_MESSAGE_SIZE = 3592;
    public static final int PR_MESSAGE_SIZE_EXTENDED = 3592;
    public static final int PR_PARENT_ENTRYID = 3593;
    public static final int PR_SENTMAIL_ENTRYID = 3594;
    public static final int PR_CORRELATE = 3596;
    public static final int PR_CORRELATE_MTSID = 3597;
    public static final int PR_DISCRETE_VALUES = 3598;
    public static final int PR_RESPONSIBILITY = 3599;
    public static final int PR_SPOOLER_STATUS = 3600;
    public static final int PR_TRANSPORT_STATUS = 3601;
    public static final int PR_MESSAGE_RECIPIENTS = 3602;
    public static final int PR_MESSAGE_ATTACHMENTS = 3603;
    public static final int PR_SUBMIT_FLAGS = 3604;
    public static final int PR_RECIPIENT_STATUS = 3605;
    public static final int PR_TRANSPORT_KEY = 3606;
    public static final int PR_MSG_STATUS = 3607;
    public static final int PR_MESSAGE_DOWNLOAD_TIME = 3608;
    public static final int PR_CREATION_VERSION = 3609;
    public static final int PR_MODIFY_VERSION = 3610;
    public static final int PR_HASATTACH = 3611;
    public static final int PR_BODY_CRC = 3612;
    public static final int PR_NORMALIZED_SUBJECT = 3613;
    public static final int PR_RTF_IN_SYNC = 3615;
    public static final int PR_ATTACH_SIZE = 3616;
    public static final int PR_ATTACH_NUM = 3617;
    public static final int PR_PREPROCESS = 3618;
    public static final int PR_ORIGINATING_MTA_CERTIFICATE = 3621;
    public static final int PR_PROOF_OF_SUBMISSION = 3622;
    public static final int PR_PRIMARY_SEND_ACCT = 3624;
    public static final int PR_NEXT_SEND_ACCT = 3625;
    public static final int PR_TODO_ITEM_FLAGS = 3627;
    public static final int PR_SWAPPED_TODO_STORE = 3628;
    public static final int PR_SWAPPED_TODO_DATA = 3629;
    public static final int PR_READ = 3689;
    public static final int PR_NT_SECURITY_DESCRIPTOR_AS_XML = 3690;
    public static final int PR_TRUST_SENDER = 3705;
    public static final int PR_EXTENDED_RULE_MSG_ACTIONS = 3737;
    public static final int PR_EXTENDED_RULE_MSG_CONDITION = 3738;
    public static final int PR_EXTENDED_RULE_SIZE_LIMIT = 3739;
    public static final int PR_ACCESS = 4084;
    public static final int PR_ROW_TYPE = 4085;
    public static final int PR_INSTANCE_KEY = 4086;
    public static final int PR_ACCESS_LEVEL = 4087;
    public static final int PR_MAPPING_SIGNATURE = 4088;
    public static final int PR_RECORD_KEY = 4089;
    public static final int PR_STORE_RECORD_KEY = 4090;
    public static final int PR_STORE_ENTRYID = 4091;
    public static final int PR_MINI_ICON = 4092;
    public static final int PR_ICON = 4093;
    public static final int PR_OBJECT_TYPE = 4094;
    public static final int PR_ENTRYID = 4095;
    public static final int PR_MEMBER_ENTRYID = 4095;
    public static final int PR_BODY = 4096;
    public static final int PR_REPORT_TEXT = 4097;
    public static final int PR_ORIGINATOR_AND_DL_EXPANSION_HISTORY = 4098;
    public static final int PR_REPORTING_DL_NAME = 4099;
    public static final int PR_REPORTING_MTA_CERTIFICATE = 4100;
    public static final int PR_RTF_SYNC_BODY_CRC = 4102;
    public static final int PR_RTF_SYNC_BODY_COUNT = 4103;
    public static final int PR_RTF_SYNC_BODY_TAG = 4104;
    public static final int PR_RTF_COMPRESSED = 4105;
    public static final int PR_RTF_SYNC_PREFIX_COUNT = 4112;
    public static final int PR_RTF_SYNC_TRAILING_COUNT = 4113;
    public static final int PR_ORIGINALLY_INTENDED_RECIP_ENTRYID = 4114;
    public static final int PR_HTML = 4115;
    public static final int PR_BODY_HTML = 4115;
    public static final int PR_BODY_CONTENT_LOCATION = 4116;
    public static final int PR_BODY_CONTENT_ID = 4117;
    public static final int PR_NATIVE_BODY_INFO = 4118;
    public static final int PR_INTERNET_MESSAGE_ID = 4149;
    public static final int PR_INTERNET_REFERENCES = 4153;
    public static final int PR_IN_REPLY_TO_ID = 4162;
    public static final int PR_LIST_HELP = 4163;
    public static final int PR_LIST_SUBSCRIBE = 4164;
    public static final int PR_LIST_UNSUBSCRIBE = 4165;
    public static final int PR_ICON_INDEX = 4224;
    public static final int PR_LAST_VERB_EXECUTED = 4225;
    public static final int PR_LAST_VERB_EXECUTION_TIME = 4226;
    public static final int PR_FLAG_STATUS = 4240;
    public static final int PR_FLAG_COMPLETE_TIME = 4241;
    public static final int PR_FOLLOWUP_ICON = 4245;
    public static final int PR_BLOCK_STATUS = 4246;
    public static final int PR_CDO_RECURRENCEID = 4293;
    public static final int PR_OWA_URL = 4337;
    public static final int PR_DISABLE_FULL_FIDELITY = 4338;
    public static final int PR_ATTR_HIDDEN = 4340;
    public static final int PR_ATTR_READONLY = 4342;
    public static final int PR_P1_CONTENT = 4352;
    public static final int PR_P1_CONTENT_TYPE = 4353;
    public static final int PR_ROWID = 12288;
    public static final int PR_DISPLAY_NAME = 12289;
    public static final int PR_ADDRTYPE = 12290;
    public static final int PR_EMAIL_ADDRESS = 12291;
    public static final int PR_COMMENT = 12292;
    public static final int PR_DEPTH = 12293;
    public static final int PR_PROVIDER_DISPLAY = 12294;
    public static final int PR_CREATION_TIME = 12295;
    public static final int PR_LAST_MODIFICATION_TIME = 12296;
    public static final int PR_RESOURCE_FLAGS = 12297;
    public static final int PR_PROVIDER_DLL_NAME = 12298;
    public static final int PR_SEARCH_KEY = 12299;
    public static final int PR_PROVIDER_UID = 12300;
    public static final int PR_PROVIDER_ORDINAL = 12301;
    public static final int PR_TARGET_ENTRYID = 12304;
    public static final int PR_CONVERSATION_ID = 12307;
    public static final int PR_CONVERSATION_INDEX_TRACKING = 12310;
    public static final int PR_ARCHIVE_TAG = 12312;
    public static final int PR_POLICY_TAG = 12313;
    public static final int PR_RETENTION_PERIOD = 12314;
    public static final int PR_START_DATE_ETC = 12315;
    public static final int PR_RETENTION_DATE = 12316;
    public static final int PR_RETENTION_FLAGS = 12317;
    public static final int PR_ARCHIVE_PERIOD = 12318;
    public static final int PR_ARCHIVE_DATE = 12319;
    public static final int PR_FORM_VERSION = 13057;
    public static final int PR_FORM_CLSID = 13058;
    public static final int PR_FORM_CONTACT_NAME = 13059;
    public static final int PR_FORM_CATEGORY = 13060;
    public static final int PR_FORM_CATEGORY_SUB = 13061;
    public static final int PR_FORM_HOST_MAP = 13062;
    public static final int PR_FORM_HIDDEN = 13063;
    public static final int PR_FORM_DESIGNER_NAME = 13064;
    public static final int PR_FORM_DESIGNER_GUID = 13065;
    public static final int PR_FORM_MESSAGE_BEHAVIOR = 13066;
    public static final int PR_DEFAULT_STORE = 13312;
    public static final int PR_STORE_SUPPORT_MASK = 13325;
    public static final int PR_STORE_STATE = 13326;
    public static final int PR_IPM_SUBTREE_SEARCH_KEY = 13328;
    public static final int PR_IPM_OUTBOX_SEARCH_KEY = 13329;
    public static final int PR_IPM_WASTEBASKET_SEARCH_KEY = 13330;
    public static final int PR_IPM_SENTMAIL_SEARCH_KEY = 13331;
    public static final int PR_MDB_PROVIDER = 13332;
    public static final int PR_RECEIVE_FOLDER_SETTINGS = 13333;
    public static final int PR_VALID_FOLDER_MASK = 13791;
    public static final int PR_IPM_SUBTREE_ENTRYID = 13792;
    public static final int PR_IPM_OUTBOX_ENTRYID = 13794;
    public static final int PR_IPM_WASTEBASKET_ENTRYID = 13795;
    public static final int PR_IPM_SENTMAIL_ENTRYID = 13796;
    public static final int PR_VIEWS_ENTRYID = 13797;
    public static final int PR_COMMON_VIEWS_ENTRYID = 13798;
    public static final int PR_FINDER_ENTRYID = 13799;
    public static final int PR_CONTAINER_FLAGS = 13824;
    public static final int PR_FOLDER_TYPE = 13825;
    public static final int PR_CONTENT_COUNT = 13826;
    public static final int PR_CONTENT_UNREAD = 13827;
    public static final int PR_CREATE_TEMPLATES = 13828;
    public static final int PR_DETAILS_TABLE = 13829;
    public static final int PR_SEARCH = 13831;
    public static final int PR_SELECTABLE = 13833;
    public static final int PR_SUBFOLDERS = 13834;
    public static final int PR_STATUS = 13835;
    public static final int PR_ANR = 13836;
    public static final int PR_CONTENTS_SORT_ORDER = 13837;
    public static final int PR_CONTAINER_HIERARCHY = 13838;
    public static final int PR_CONTAINER_CONTENTS = 13839;
    public static final int PR_FOLDER_ASSOCIATED_CONTENTS = 13840;
    public static final int PR_DEF_CREATE_DL = 13841;
    public static final int PR_DEF_CREATE_MAILUSER = 13842;
    public static final int PR_CONTAINER_CLASS = 13843;
    public static final int PR_CONTAINER_MODIFY_VERSION = 13844;
    public static final int PR_AB_PROVIDER_ID = 13845;
    public static final int PR_DEFAULT_VIEW_ENTRYID = 13846;
    public static final int PR_ASSOC_CONTENT_COUNT = 13847;
    public static final int PR_IPM_APPOINTMENT_ENTRYID = 14032;
    public static final int PR_IPM_CONTACT_ENTRYID = 14033;
    public static final int PR_IPM_JOURNAL_ENTRYID = 14034;
    public static final int PR_IPM_NOTE_ENTRYID = 14035;
    public static final int PR_IPM_TASK_ENTRYID = 14036;
    public static final int PR_REM_ONLINE_ENTRYID = 14037;
    public static final int PR_IPM_DRAFTS_ENTRYID = 14039;
    public static final int PR_ADDITIONAL_REN_ENTRYIDS = 14040;
    public static final int PR_ADDITIONAL_REN_ENTRYIDS_EX = 14041;
    public static final int PR_EXTENDED_FOLDER_FLAGS = 14042;
    public static final int PR_ORDINAL_MOST = 14050;
    public static final int PR_FREEBUSY_ENTRYIDS = 14052;
    public static final int PR_DEF_POST_MSGCLASS = 14053;
    public static final int PR_ATTACHMENT_X400_PARAMETERS = 14080;
    public static final int PR_ATTACH_DATA_OBJ = 14081;
    public static final int PR_ATTACH_DATA_BIN = 14081;
    public static final int PR_ATTACH_ENCODING = 14082;
    public static final int PR_ATTACH_EXTENSION = 14083;
    public static final int PR_ATTACH_FILENAME = 14084;
    public static final int PR_ATTACH_METHOD = 14085;
    public static final int PR_ATTACH_LONG_FILENAME = 14087;
    public static final int PR_ATTACH_PATHNAME = 14088;
    public static final int PR_ATTACH_RENDERING = 14089;
    public static final int PR_ATTACH_TAG = 14090;
    public static final int PR_RENDERING_POSITION = 14091;
    public static final int PR_ATTACH_TRANSPORT_NAME = 14092;
    public static final int PR_ATTACH_LONG_PATHNAME = 14093;
    public static final int PR_ATTACH_MIME_TAG = 14094;
    public static final int PR_ATTACH_ADDITIONAL_INFO = 14095;
    public static final int PR_ATTACH_CONTENT_BASE = 14097;
    public static final int PR_ATTACH_CONTENT_ID = 14098;
    public static final int PR_ATTACH_CONTENT_LOCATION = 14099;
    public static final int PR_ATTACH_FLAGS = 14100;
    public static final int PR_ATTACH_PAYLOAD_PROV_GUID_STR = 14105;
    public static final int PR_ATTACH_PAYLOAD_CLASS = 14106;
    public static final int PR_DISPLAY_TYPE = 14592;
    public static final int PR_TEMPLATEID = 14594;
    public static final int PR_PRIMARY_CAPABILITY = 14596;
    public static final int PR_DISPLAY_TYPE_EX = 14597;
    public static final int PR_SMTP_ADDRESS = 14846;
    public static final int PR_7BIT_DISPLAY_NAME = 14847;
    public static final int PR_EMS_AB_DISPLAY_NAME_PRINTABLE = 14847;
    public static final int PR_ACCOUNT = 14848;
    public static final int PR_ALTERNATE_RECIPIENT = 14849;
    public static final int PR_CALLBACK_TELEPHONE_NUMBER = 14850;
    public static final int PR_CONVERSION_PROHIBITED = 14851;
    public static final int PR_DISCLOSE_RECIPIENTS = 14852;
    public static final int PR_GENERATION = 14853;
    public static final int PR_GIVEN_NAME = 14854;
    public static final int PR_GOVERNMENT_ID_NUMBER = 14855;
    public static final int PR_BUSINESS_TELEPHONE_NUMBER = 14856;
    public static final int PR_OFFICE_TELEPHONE_NUMBER = 14856;
    public static final int PR_HOME_TELEPHONE_NUMBER = 14857;
    public static final int PR_INITIALS = 14858;
    public static final int PR_KEYWORD = 14859;
    public static final int PR_LANGUAGE = 14860;
    public static final int PR_LOCATION = 14861;
    public static final int PR_MAIL_PERMISSION = 14862;
    public static final int PR_MHS_COMMON_NAME = 14863;
    public static final int PR_ORGANIZATIONAL_ID_NUMBER = 14864;
    public static final int PR_SURNAME = 14865;
    public static final int PR_ORIGINAL_ENTRYID = 14866;
    public static final int PR_ORIGINAL_DISPLAY_NAME = 14867;
    public static final int PR_ORIGINAL_SEARCH_KEY = 14868;
    public static final int PR_POSTAL_ADDRESS = 14869;
    public static final int PR_COMPANY_NAME = 14870;
    public static final int PR_TITLE = 14871;
    public static final int PR_DEPARTMENT_NAME = 14872;
    public static final int PR_OFFICE_LOCATION = 14873;
    public static final int PR_PRIMARY_TELEPHONE_NUMBER = 14874;
    public static final int PR_BUSINESS2_TELEPHONE_NUMBER = 14875;
    public static final int PR_OFFICE2_TELEPHONE_NUMBER = 14875;
    public static final int PR_MOBILE_TELEPHONE_NUMBER = 14876;
    public static final int PR_CELLULAR_TELEPHONE_NUMBER = 14876;
    public static final int PR_RADIO_TELEPHONE_NUMBER = 14877;
    public static final int PR_CAR_TELEPHONE_NUMBER = 14878;
    public static final int PR_OTHER_TELEPHONE_NUMBER = 14879;
    public static final int PR_TRANSMITABLE_DISPLAY_NAME = 14880;
    public static final int PR_PAGER_TELEPHONE_NUMBER = 14881;
    public static final int PR_BEEPER_TELEPHONE_NUMBER = 14881;
    public static final int PR_USER_CERTIFICATE = 14882;
    public static final int PR_PRIMARY_FAX_NUMBER = 14883;
    public static final int PR_BUSINESS_FAX_NUMBER = 14884;
    public static final int PR_HOME_FAX_NUMBER = 14885;
    public static final int PR_COUNTRY = 14886;
    public static final int PR_BUSINESS_ADDRESS_COUNTRY = 14886;
    public static final int PR_LOCALITY = 14887;
    public static final int PR_BUSINESS_ADDRESS_LOCALITY = 14887;
    public static final int PR_STATE_OR_PROVINCE = 14888;
    public static final int PR_BUSINESS_ADDRESS_STATE_OR_PROVINCE = 14888;
    public static final int PR_STREET_ADDRESS = 14889;
    public static final int PR_BUSINESS_ADDRESS_STREET = 14889;
    public static final int PR_POSTAL_CODE = 14890;
    public static final int PR_BUSINESS_ADDRESS_POSTAL_CODE = 14890;
    public static final int PR_POST_OFFICE_BOX = 14891;
    public static final int PR_BUSINESS_ADDRESS_POST_OFFICE_BOX = 14891;
    public static final int PR_TELEX_NUMBER = 14892;
    public static final int PR_ISDN_NUMBER = 14893;
    public static final int PR_ASSISTANT_TELEPHONE_NUMBER = 14894;
    public static final int PR_HOME2_TELEPHONE_NUMBER = 14895;
    public static final int PR_ASSISTANT = 14896;
    public static final int PR_SEND_RICH_INFO = 14912;
    public static final int PR_WEDDING_ANNIVERSARY = 14913;
    public static final int PR_BIRTHDAY = 14914;
    public static final int PR_HOBBIES = 14915;
    public static final int PR_MIDDLE_NAME = 14916;
    public static final int PR_DISPLAY_NAME_PREFIX = 14917;
    public static final int PR_PROFESSION = 14918;
    public static final int PR_REFERRED_BY_NAME = 14919;
    public static final int PR_SPOUSE_NAME = 14920;
    public static final int PR_COMPUTER_NETWORK_NAME = 14921;
    public static final int PR_CUSTOMER_ID = 14922;
    public static final int PR_TTYTDD_PHONE_NUMBER = 14923;
    public static final int PR_FTP_SITE = 14924;
    public static final int PR_GENDER = 14925;
    public static final int PR_MANAGER_NAME = 14926;
    public static final int PR_NICKNAME = 14927;
    public static final int PR_PERSONAL_HOME_PAGE = 14928;
    public static final int PR_BUSINESS_HOME_PAGE = 14929;
    public static final int PR_CONTACT_VERSION = 14930;
    public static final int PR_CONTACT_ENTRYIDS = 14931;
    public static final int PR_CONTACT_ADDRTYPES = 14932;
    public static final int PR_CONTACT_DEFAULT_ADDRESS_INDEX = 14933;
    public static final int PR_CONTACT_EMAIL_ADDRESSES = 14934;
    public static final int PR_COMPANY_MAIN_PHONE_NUMBER = 14935;
    public static final int PR_CHILDRENS_NAMES = 14936;
    public static final int PR_HOME_ADDRESS_CITY = 14937;
    public static final int PR_HOME_ADDRESS_COUNTRY = 14938;
    public static final int PR_HOME_ADDRESS_POSTAL_CODE = 14939;
    public static final int PR_HOME_ADDRESS_STATE_OR_PROVINCE = 14940;
    public static final int PR_HOME_ADDRESS_STREET = 14941;
    public static final int PR_HOME_ADDRESS_POST_OFFICE_BOX = 14942;
    public static final int PR_OTHER_ADDRESS_CITY = 14943;
    public static final int PR_OTHER_ADDRESS_COUNTRY = 14944;
    public static final int PR_OTHER_ADDRESS_POSTAL_CODE = 14945;
    public static final int PR_OTHER_ADDRESS_STATE_OR_PROVINCE = 14946;
    public static final int PR_OTHER_ADDRESS_STREET = 14947;
    public static final int PR_OTHER_ADDRESS_POST_OFFICE_BOX = 14948;
    public static final int PR_USER_X509_CERTIFICATE = 14960;
    public static final int PR_SEND_INTERNET_ENCODING = 14961;
    public static final int PR_STORE_PROVIDERS = 15616;
    public static final int PR_AB_PROVIDERS = 15617;
    public static final int PR_TRANSPORT_PROVIDERS = 15618;
    public static final int PR_DEFAULT_PROFILE = 15620;
    public static final int PR_AB_SEARCH_PATH = 15621;
    public static final int PR_AB_DEFAULT_DIR = 15622;
    public static final int PR_AB_DEFAULT_PAB = 15623;
    public static final int PR_FILTERING_HOOKS = 15624;
    public static final int PR_SERVICE_NAME = 15625;
    public static final int PR_SERVICE_DLL_NAME = 15626;
    public static final int PR_SERVICE_ENTRY_NAME = 15627;
    public static final int PR_SERVICE_UID = 15628;
    public static final int PR_SERVICE_EXTRA_UIDS = 15629;
    public static final int PR_SERVICES = 15630;
    public static final int PR_SERVICE_SUPPORT_FILES = 15631;
    public static final int PR_SERVICE_DELETE_FILES = 15632;
    public static final int PR_AB_SEARCH_PATH_UPDATE = 15633;
    public static final int PR_PROFILE_NAME = 15634;
    public static final int PR_IDENTITY_DISPLAY = 15872;
    public static final int PR_IDENTITY_ENTRYID = 15873;
    public static final int PR_RESOURCE_METHODS = 15874;
    public static final int PR_RESOURCE_TYPE = 15875;
    public static final int PR_STATUS_CODE = 15876;
    public static final int PR_IDENTITY_SEARCH_KEY = 15877;
    public static final int PR_OWN_STORE_ENTRYID = 15878;
    public static final int PR_RESOURCE_PATH = 15879;
    public static final int PR_STATUS_STRING = 15880;
    public static final int PR_X400_DEFERRED_DELIVERY_CANCEL = 15881;
    public static final int PR_HEADER_FOLDER_ENTRYID = 15882;
    public static final int PR_REMOTE_PROGRESS = 15883;
    public static final int PR_REMOTE_PROGRESS_TEXT = 15884;
    public static final int PR_REMOTE_VALIDATE_OK = 15885;
    public static final int PR_CONTROL_FLAGS = 16128;
    public static final int PR_CONTROL_STRUCTURE = 16129;
    public static final int PR_CONTROL_TYPE = 16130;
    public static final int PR_DELTAX = 16131;
    public static final int PR_DELTAY = 16132;
    public static final int PR_XPOS = 16133;
    public static final int PR_YPOS = 16134;
    public static final int PR_CONTROL_ID = 16135;
    public static final int PR_INITIAL_DETAILS_PANE = 16136;
    public static final int PR_PREVIEW_UNREAD = 16344;
    public static final int PR_PREVIEW = 16345;
    public static final int PR_ABSTRACT = 16346;
    public static final int PR_DL_REPORT_FLAGS = 16347;
    public static final int PR_BILATERAL_INFO = 16348;
    public static final int PR_MSG_BODY_ID = 16349;
    public static final int PR_INTERNET_CPID = 16350;
    public static final int PR_AUTO_RESPONSE_SUPPRESS = 16351;
    public static final int PR_ACL_TABLE = 16352;
    public static final int PR_ACL_DATA = 16352;
    public static final int PR_RULES_TABLE = 16353;
    public static final int PR_RULES_DATA = 16353;
    public static final int PR_FOLDER_DESIGN_FLAGS = 16354;
    public static final int PR_DELEGATED_BY_RULE = 16355;
    public static final int PR_DESIGN_IN_PROGRESS = 16356;
    public static final int PR_SECURE_ORIGINATION = 16357;
    public static final int PR_PUBLISH_IN_ADDRESS_BOOK = 16358;
    public static final int PR_RESOLVE_METHOD = 16359;
    public static final int PR_ADDRESS_BOOK_DISPLAY_NAME = 16360;
    public static final int PR_EFORMS_LOCALE_ID = 16361;
    public static final int PR_HAS_DAMS = 16362;
    public static final int PR_DEFERRED_SEND_NUMBER = 16363;
    public static final int PR_DEFERRED_SEND_UNITS = 16364;
    public static final int PR_EXPIRY_NUMBER = 16365;
    public static final int PR_EXPIRY_UNITS = 16366;
    public static final int PR_DEFERRED_SEND_TIME = 16367;
    public static final int PR_CONFLICT_ENTRYID = 16368;
    public static final int PR_MESSAGE_LOCALE_ID = 16369;
    public static final int PR_RULE_TRIGGER_HISTORY = 16370;
    public static final int PR_MOVE_TO_STORE_ENTRYID = 16371;
    public static final int PR_MOVE_TO_FOLDER_ENTRYID = 16372;
    public static final int PR_STORAGE_QUOTA_LIMIT = 16373;
    public static final int PR_EXCESS_STORAGE_USED = 16374;
    public static final int PR_SVR_GENERATING_QUOTA_MSG = 16375;
    public static final int PR_CREATOR_NAME = 16376;
    public static final int PR_CREATOR_ENTRYID = 16377;
    public static final int PR_LAST_MODIFIER_NAME = 16378;
    public static final int PR_LAST_MODIFIER_ENTRYID = 16379;
    public static final int PR_REPLY_RECIPIENT_SMTP_PROXIES = 16380;
    public static final int PR_MESSAGE_CODEPAGE = 16381;
    public static final int PR_EXTENDED_ACL_DATA = 16382;
    public static final int PR_CONTENT_FILTER_SCL = 16502;
    public static final int PR_SENDER_ID_STATUS = 16505;
    public static final int PR_HIER_REV = 16514;
    public static final int PR_PURPORTED_SENDER_DOMAIN = 16515;
    public static final int PR_INETMAIL_OVERRIDE_FORMAT = 22786;
    public static final int PR_MSG_EDITOR_FORMAT = 22793;
    public static final int PR_SENT_REPRESENTING_SMTP_ADDRESS = 23810;
    public static final int PR_RECIPIENT_ORDER = 24543;
    public static final int PR_RECIPIENT_PROPOSED = 24545;
    public static final int PR_RECIPIENT_PROPOSEDSTARTTIME = 24547;
    public static final int PR_RECIPIENT_PROPOSEDENDTIME = 24548;
    public static final int PR_RECIPIENT_DISPLAY_NAME = 24566;
    public static final int PR_RECIPIENT_ENTRYID = 24567;
    public static final int PR_RECIPIENT_TRACKSTATUS_TIME = 24571;
    public static final int PR_RECIPIENT_FLAGS = 24573;
    public static final int PR_RECIPIENT_TRACKSTATUS = 24575;
    public static final int PR_JUNK_INCLUDE_CONTACTS = 24832;
    public static final int PR_JUNK_THRESHOLD = 24833;
    public static final int PR_JUNK_PERMANENTLY_DELETE = 24834;
    public static final int PR_JUNK_ADD_RECIPS_TO_SSL = 24835;
    public static final int PR_JUNK_PHISHING_ENABLE_LINKS = 24839;
    public static final int PR_REPLY_TEMPLATE_ID = 26050;
    public static final int PR_SOURCE_KEY = 26080;
    public static final int PR_PARENT_SOURCE_KEY = 26081;
    public static final int PR_CHANGE_KEY = 26082;
    public static final int PR_PREDECESSOR_CHANGE_LIST = 26083;
    public static final int PR_RULE_MSG_STATE = 26089;
    public static final int PR_RULE_MSG_USER_FLAGS = 26090;
    public static final int PR_RULE_MSG_LEVEL = 26093;
    public static final int PR_RULE_MSG_PROVIDER_DATA = 26094;
    public static final int PR_RULE_MSG_SEQUENCE = 26099;
    public static final int PR_USER_ENTRYID = 26137;
    public static final int PR_MAILBOX_OWNER_ENTRYID = 26139;
    public static final int PR_MAILBOX_OWNER_NAME = 26140;
    public static final int PR_OOF_STATE = 26141;
    public static final int PR_SPLUS_FREE_BUSY_ENTRYID = 26146;
    public static final int PR_RIGHTS = 26169;
    public static final int PR_HAS_RULES = 26170;
    public static final int PR_ADDRESS_BOOK_ENTRYID = 26171;
    public static final int PR_HIERARCHY_CHANGE_NUM = 26174;
    public static final int PR_CLIENT_ACTIONS = 26181;
    public static final int PR_DAM_ORIGINAL_ENTRYID = 26182;
    public static final int PR_DAM_BACK_PATCHED = 26183;
    public static final int PR_RULE_ERROR = 26184;
    public static final int PR_RULE_ACTION_TYPE = 26185;
    public static final int PR_HAS_NAMED_PROPERTIES = 26186;
    public static final int PR_RULE_ACTION_NUMBER = 26192;
    public static final int PR_RULE_FOLDER_ENTRYID = 26193;
    public static final int PR_PROHIBIT_RECEIVE_QUOTA = 26218;
    public static final int PR_IN_CONFLICT = 26220;
    public static final int PR_MAX_SUBMIT_MESSAGE_SIZE = 26221;
    public static final int PR_PROHIBIT_SEND_QUOTA = 26222;
    public static final int PR_MEMBER_ID = 26225;
    public static final int PR_MEMBER_NAME = 26226;
    public static final int PR_MEMBER_RIGHTS = 26227;
    public static final int PR_RULE_ID = 26228;
    public static final int PR_RULE_IDS = 26229;
    public static final int PR_RULE_SEQUENCE = 26230;
    public static final int PR_RULE_STATE = 26231;
    public static final int PR_RULE_USER_FLAGS = 26232;
    public static final int PR_RULE_CONDITION = 26233;
    public static final int PR_RULE_ACTIONS = 26240;
    public static final int PR_RULE_PROVIDER = 26241;
    public static final int PR_RULE_NAME = 26242;
    public static final int PR_RULE_LEVEL = 26243;
    public static final int PR_RULE_PROVIDER_DATA = 26244;
    public static final int PR_DELETED_ON = 26255;
    public static final int PR_LOCALE_ID = 26273;
    public static final int PR_FOLDER_FLAGS = 26280;
    public static final int PR_CODE_PAGE_ID = 26307;
    public static final int PR_EMS_AB_MANAGE_DL = 26372;
    public static final int PR_SORT_LOCALE_ID = 26373;
    public static final int PR_LOCAL_COMMIT_TIME = 26377;
    public static final int PR_LOCAL_COMMIT_TIME_MAX = 26378;
    public static final int PR_DELETED_COUNT_TOTAL = 26379;
    public static final int PR_FLAT_URL_NAME = 26382;
    public static final int PR_DAM_ORIG_MSG_SVREID = 26433;
    public static final int PR_OAB_NAME = 26624;
    public static final int PR_OAB_SEQUENCE = 26625;
    public static final int PR_OAB_CONTAINER_GUID = 26626;
    public static final int PR_OAB_MESSAGE_CLASS = 26627;
    public static final int PR_OAB_DN = 26628;
    public static final int PR_OAB_TRUNCATED_PROPS = 26629;
    public static final int PR_SCHDINFO_RESOURCE_TYPE = 26689;
    public static final int PR_SCHDINFO_BOSS_WANTS_COPY = 26690;
    public static final int PR_SCHDINFO_DONT_MAIL_DELEGATES = 26691;
    public static final int PR_SCHDINFO_DELEGATE_NAMES = 26692;
    public static final int PR_SCHDINFO_DELEGATE_ENTRYIDS = 26693;
    public static final int PR_GATEWAY_NEEDS_TO_REFRESH = 26694;
    public static final int PR_FREEBUSY_PUBLISH_START = 26695;
    public static final int PR_FREEBUSY_PUBLISH_END = 26696;
    public static final int PR_FREEBUSY_EMA = 26697;
    public static final int PR_SCHDINFO_BOSS_WANTS_INFO = 26699;
    public static final int PR_SCHDINFO_MONTHS_MERGED = 26703;
    public static final int PR_SCHDINFO_FREEBUSY_MERGED = 26704;
    public static final int PR_SCHDINFO_MONTHS_TENTATIVE = 26705;
    public static final int PR_SCHDINFO_FREEBUSY_TENTATIVE = 26706;
    public static final int PR_SCHDINFO_MONTHS_BUSY = 26707;
    public static final int PR_SCHDINFO_FREEBUSY_BUSY = 26708;
    public static final int PR_SCHDINFO_MONTHS_OOF = 26709;
    public static final int PR_SCHDINFO_FREEBUSY_OOF = 26710;
    public static final int PR_FREEBUSY_RANGE_TIMESTAMP = 26728;
    public static final int PR_FREEBUSY_COUNT_MONTHS = 26729;
    public static final int PR_SCHDINFO_APPT_TOMBSTONE = 26730;
    public static final int PR_DELEGATE_FLAGS = 26731;
    public static final int PR_SCHDINFO_FREEBUSY = 26732;
    public static final int PR_SCHDINFO_AUTO_ACCEPT_APPTS = 26733;
    public static final int PR_SCHDINFO_DISALLOW_RECURRING_APPTS = 26734;
    public static final int PR_SCHDINFO_DISALLOW_OVERLAPPING_APPTS = 26735;
    public static final int PR_WLINK_CLIENTID = 26768;
    public static final int PR_WLINK_AB_EXSTOREEID = 26769;
    public static final int PR_WLINK_RO_GROUP_TYPE = 26770;
    public static final int PR_VD_BINARY = 28673;
    public static final int PR_VD_STRINGS = 28674;
    public static final int PR_VD_NAME = 28678;
    public static final int PR_VD_VERSION = 28679;
    public static final int PR_ROAMING_DATATYPES = 31750;
    public static final int PR_ROAMING_DICTIONARY = 31751;
    public static final int PR_ROAMING_XMLSTREAM = 31752;
    public static final int PR_OSC_SYNC_ENABLEDONSERVER = 31780;
    public static final int PR_PROCESSED = 32001;
    public static final int PR_EXCEPTION_REPLACETIME = 32761;
    public static final int PR_ATTACHMENT_LINKID = 32762;
    public static final int PR_EXCEPTION_STARTTIME = 32763;
    public static final int PR_EXCEPTION_ENDTIME = 32764;
    public static final int PR_ATTACHMENT_FLAGS = 32765;
    public static final int PR_ATTACHMENT_HIDDEN = 32766;
    public static final int PR_ATTACHMENT_CONTACTPHOTO = Short.MAX_VALUE;
    public static final int PR_EMS_AB_FOLDER_PATHNAME = 32772;
    public static final int PR_EMS_AB_MANAGER = 32773;
    public static final int PR_EMS_AB_HOME_MDB = 32774;
    public static final int PR_EMS_AB_IS_MEMBER_OF_DL = 32776;
    public static final int PR_EMS_AB_MEMBER = 32777;
    public static final int PR_EMS_AB_OWNER_O = 32780;
    public static final int PR_EMS_AB_REPORTS = 32782;
    public static final int PR_EMS_AB_PROXY_ADDRESSES = 32783;
    public static final int PR_EMS_AB_TARGET_ADDRESS = 32785;
    public static final int PR_EMS_AB_PUBLIC_DELEGATES = 32789;
    public static final int PR_EMS_AB_OWNER_BL_O = 32804;
    public static final int PR_EMS_AB_EXTENSION_ATTRIBUTE_1 = 32813;
    public static final int PR_EMS_AB_EXTENSION_ATTRIBUTE_2 = 32814;
    public static final int PR_EMS_AB_EXTENSION_ATTRIBUTE_3 = 32815;
    public static final int PR_EMS_AB_EXTENSION_ATTRIBUTE_4 = 32816;
    public static final int PR_EMS_AB_EXTENSION_ATTRIBUTE_5 = 32817;
    public static final int PR_EMS_AB_EXTENSION_ATTRIBUTE_6 = 32818;
    public static final int PR_EMS_AB_EXTENSION_ATTRIBUTE_7 = 32819;
    public static final int PR_EMS_AB_EXTENSION_ATTRIBUTE_8 = 32820;
    public static final int PR_EMS_AB_EXTENSION_ATTRIBUTE_9 = 32821;
    public static final int PR_EMS_AB_EXTENSION_ATTRIBUTE_10 = 32822;
    public static final int PR_EMS_AB_OBJ_DIST_NAME = 32828;
    public static final int PR_EMS_AB_DELIV_CONT_LENGTH = 32874;
    public static final int PR_EMS_AB_DL_MEM_SUBMIT_PERMS_BL_O = 32883;
    public static final int PR_EMS_AB_NETWORK_ADDRESS = 33136;
    public static final int PR_EMS_AB_EXTENSION_ATTRIBUTE_11 = 35927;
    public static final int PR_EMS_AB_EXTENSION_ATTRIBUTE_12 = 35928;
    public static final int PR_EMS_AB_EXTENSION_ATTRIBUTE_13 = 35929;
    public static final int PR_EMS_AB_EXTENSION_ATTRIBUTE_14 = 35936;
    public static final int PR_EMS_AB_EXTENSION_ATTRIBUTE_15 = 35937;
    public static final int PR_EMS_AB_X509_CERT = 35946;
    public static final int PR_EMS_AB_OBJECT_GUID = 35949;
    public static final int PR_EMS_AB_PHONETIC_GIVEN_NAME = 35982;
    public static final int PR_EMS_AB_PHONETIC_SURNAME = 35983;
    public static final int PR_EMS_AB_PHONETIC_DEPARTMENT_NAME = 35984;
    public static final int PR_EMS_AB_PHONETIC_COMPANY_NAME = 35985;
    public static final int PR_EMS_AB_PHONETIC_DISPLAY_NAME = 35986;
    public static final int PR_EMS_AB_DISPLAY_TYPE_EX = 35987;
    public static final int PR_EMS_AB_HAB_SHOW_IN_DEPARTMENTS = 35988;
    public static final int PR_EMS_AB_ROOM_CONTAINERS = 35990;
    public static final int PR_EMS_AB_HAB_DEPARTMENT_MEMBERS = 35991;
    public static final int PR_EMS_AB_HAB_ROOT_DEPARTMENT = 35992;
    public static final int PR_EMS_AB_HAB_PARENT_DEPARTMENT = 35993;
    public static final int PR_EMS_AB_HAB_CHILD_DEPARTMENTS = 35994;
    public static final int PR_EMS_AB_THUMBNAIL_PHOTO = 35998;
    public static final int PR_EMS_AB_HAB_SENIORITY_INDEX = 36000;
    public static final int PR_EMS_AB_SENIORITY_INDEX = 36000;
    public static final int PR_EMS_AB_ORG_UNIT_ROOT_DN = 36008;
    public static final int PR_EMS_AB_ENABLE_MODERATION = 36021;
    public static final int PR_EMS_AB_UM_SPOKEN_NAME = 36034;
    public static final int PR_EMS_AB_AUTH_ORIG = 36056;
    public static final int PR_EMS_AB_UNAUTH_ORIG = 36057;
    public static final int PR_EMS_AB_DL_MEM_SUBMIT_PERMS = 36058;
    public static final int PR_EMS_AB_DL_MEM_REJECT_PERMS = 36059;
    public static final int PR_EMS_AB_HAB_IS_HIERARCHICAL_GROUP = 36061;
    public static final int PR_EMS_AB_IS_ORGANIZATIONAL = 36061;
    public static final int PR_EMS_AB_DL_TOTAL_MEMBER_COUNT = 36066;
    public static final int PR_EMS_AB_DL_EXTERNAL_MEMBER_COUNT = 36067;
    public static final int PR_EMS_AB_IS_MASTER = 65531;
    public static final int PR_EMS_AB_PARENT_ENTRYID = 65532;
    public static final int PR_EMS_AB_CONTAINERID = 65533;

    public MAPIProp(RawInputStream data) throws IOException {
        int valueCount;
        this.type = data.readU16();
        boolean isMultiValue = (this.type & 0x1000) != 0;
        this.type &= 0xFFFFEFFF;
        int typeSize = MAPIProp.getTypeSize(this.type);
        if (typeSize < 0) {
            isMultiValue = true;
        }
        this.id = data.readU16();
        if (this.id >= 32768 && this.id <= 65534) {
            this.name = new MAPIPropName(data);
        }
        int n = valueCount = isMultiValue ? (int)data.readU32() : 1;
        if (valueCount > 1024 && valueCount > data.available()) {
            throw new IOException("count is too large: " + valueCount);
        }
        this.values = new MAPIValue[valueCount];
        for (int i = 0; i < valueCount; ++i) {
            int length = typeSize >= 0 ? typeSize : (int)data.readU32();
            this.values[i] = new MAPIValue(this.type, data, length);
            data.skip(-length & 3);
        }
    }

    public MAPIProp(int type, int id, MAPIValue ... values) {
        this.type = type;
        this.id = id;
        this.values = values != null ? values : new MAPIValue[]{};
    }

    public int getType() {
        return this.type;
    }

    public int getID() {
        return this.id;
    }

    public MAPIPropName getName() {
        return this.name;
    }

    public void setName(MAPIPropName name) {
        this.name = name;
    }

    public int getLength() {
        return this.values.length;
    }

    public MAPIValue[] getValues() {
        return this.values;
    }

    public Object getValue() throws IOException {
        return this.values.length > 0 && this.values[0] != null ? this.values[0].getValue() : null;
    }

    public void close() throws IOException {
        TNEFUtils.closeAll((Closeable[])this.values);
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("MAPIProp:").append(" type=").append(TNEFUtils.getConstName(this.getClass(), "PT_", this.type));
        if (this.name == null) {
            s.append(" id=").append(TNEFUtils.getConstName(this.getClass(), "PR_", this.id));
        } else {
            s.append(" name=").append(this.name);
            s.append(" id=0x").append(TNEFUtils.toHexString(this.id, 4).toLowerCase());
        }
        if (this.getLength() == 0) {
            s.append(" value=").append((Object)null);
        } else if (this.getLength() == 1) {
            s.append(" value=").append(this.values[0]);
        } else {
            s.append(" values=").append(Arrays.toString(this.values));
        }
        return s.toString();
    }

    public static MAPIProp findProp(MAPIProp[] props, int id) {
        if (props != null) {
            for (MAPIProp prop : props) {
                if (prop.getID() != id) continue;
                return prop;
            }
        }
        return null;
    }

    public static MAPIProp findProp(MAPIProp[] props, MAPIPropName name) {
        if (props != null) {
            for (MAPIProp prop : props) {
                if (!name.equals(prop.getName())) continue;
                return prop;
            }
        }
        return null;
    }

    public static int getTypeSize(int type) {
        switch (type) {
            case 1: {
                return 0;
            }
            case 2: 
            case 11: {
                return 2;
            }
            case 3: 
            case 4: 
            case 10: {
                return 4;
            }
            case 5: 
            case 6: 
            case 7: 
            case 20: 
            case 64: {
                return 8;
            }
            case 72: {
                return 16;
            }
            case 13: 
            case 30: 
            case 31: 
            case 258: {
                return -1;
            }
        }
        if ((type & 0x1000) != 0) {
            throw new IllegalArgumentException("remove multivalue flag when calculating size");
        }
        throw new IllegalArgumentException("Unknown MAPI type: 0x" + Integer.toHexString(type));
    }
}

