/*
 * Decompiled with CFR 0.152.
 */
package net.freeutils.tnef;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import net.freeutils.tnef.TNEFUtils;

public class CompressedRTFInputStream
extends InputStream {
    protected static final int MAGIC_COMPRESSED = 1967544908;
    protected static final int MAGIC_UNCOMPRESSED = 1095517517;
    protected static final int DICT_SIZE = 4096;
    protected static final int DICT_MASK = 4095;
    protected static byte[] COMPRESSED_RTF_PREBUF;
    protected static int[] CRC32_TABLE;
    protected final InputStream in;
    protected final byte[] buf;
    protected final byte[] dict = new byte[4096];
    protected int bufstart;
    protected int bufend;
    protected int crc;
    protected int out;
    protected int dictstart;
    protected int flagCount;
    protected int flags;
    protected int compressedSize;
    protected int declaredCompressedSize;
    protected int uncompressedSize;
    protected int declaredUncompressedSize;
    protected int magic;
    protected int crc32;

    public static int calculateCRC32(byte[] buf, int off, int len, int crc) {
        int end = off + len;
        for (int i = off; i < end; ++i) {
            crc = CRC32_TABLE[(crc ^ buf[i]) & 0xFF] ^ crc >>> 8;
        }
        return crc;
    }

    public static int calculateCRC32(byte[] buf, int off, int len) {
        return CompressedRTFInputStream.calculateCRC32(buf, off, len, 0);
    }

    /*
     * Unable to fully structure code
     */
    public static byte[] decompressRTF(byte[] src) {
        in = 0;
        out = 0;
        if (src == null || src.length < 16) {
            throw new IllegalArgumentException("Invalid compressed-RTF header");
        }
        compressedSize = (int)TNEFUtils.getU32(src, in);
        uncompressedSize = (int)TNEFUtils.getU32(src, in += 4);
        magic = (int)TNEFUtils.getU32(src, in += 4);
        crc32 = (int)TNEFUtils.getU32(src, in += 4);
        in += 4;
        if (compressedSize != src.length - 4) {
            throw new IllegalArgumentException("compressed data size mismatch");
        }
        if (magic == 1095517517) {
            dst = new byte[uncompressedSize];
            System.arraycopy(src, in, dst, out, uncompressedSize);
        } else if (magic == 1967544908) {
            block14: {
                if (crc32 != CompressedRTFInputStream.calculateCRC32(src, 16, src.length - 16)) {
                    throw new IllegalArgumentException("compressed-RTF CRC32 failed");
                }
                out = CompressedRTFInputStream.COMPRESSED_RTF_PREBUF.length;
                dst = new byte[out + uncompressedSize];
                System.arraycopy(CompressedRTFInputStream.COMPRESSED_RTF_PREBUF, 0, dst, 0, out);
                flagCount = 0;
                flags = 0;
                try {
                    block2: while (true) {
                        v0 = flags = (flagCount++ & 7) == 0 ? src[in++] : flags >> 1;
                        if ((flags & 1) == 0) {
                            dst[out++] = src[in++];
                            continue;
                        }
                        offset = src[in++] & 255;
                        length = src[in++] & 255;
                        offset = offset << 4 | length >>> 4;
                        length = (length & 15) + 2;
                        if ((offset = out & -4096 | offset) >= out) {
                            if (offset == out) break;
                            offset -= 4096;
                        }
                        end = offset + length;
                        while (true) {
                            if (offset < end) ** break;
                            continue block2;
                            dst[out++] = dst[offset++];
                        }
                        break;
                    }
                }
                catch (IndexOutOfBoundsException ioobe) {
                    if (uncompressedSize == 0) break block14;
                    throw new IllegalArgumentException("uncompressed data size mismatch");
                }
            }
            src = dst;
            dst = new byte[uncompressedSize];
            System.arraycopy(src, CompressedRTFInputStream.COMPRESSED_RTF_PREBUF.length, dst, 0, uncompressedSize);
        } else {
            throw new IllegalArgumentException("Unknown compression type (magic number " + magic + ")");
        }
        return dst;
    }

    public CompressedRTFInputStream(InputStream in) throws IOException {
        this.in = in;
        this.buf = new byte[4096];
        TNEFUtils.read(in, this.buf, 0, 16, 16);
        this.init();
    }

    protected void init() throws IOException {
        this.declaredCompressedSize = this.compressedSize = (int)TNEFUtils.getU32(this.buf, 0) - 12;
        this.declaredUncompressedSize = this.uncompressedSize = (int)TNEFUtils.getU32(this.buf, 4);
        this.magic = (int)TNEFUtils.getU32(this.buf, 8);
        this.crc32 = (int)TNEFUtils.getU32(this.buf, 12);
        if (this.magic == 1967544908) {
            this.dictstart = this.out = COMPRESSED_RTF_PREBUF.length;
            System.arraycopy(COMPRESSED_RTF_PREBUF, 0, this.dict, 0, this.out);
        } else if (this.magic != 1095517517) {
            throw new IOException("Unknown compression type (magic number " + this.magic + ")");
        }
    }

    public int getCompressedSize() {
        return this.declaredCompressedSize;
    }

    public int getUncompressedSize() {
        return this.declaredUncompressedSize;
    }

    protected boolean moreCompressed() throws IOException {
        block14: {
            if (this.compressedSize == 0 && this.bufstart == this.bufend) {
                if (this.crc32 != this.crc) {
                    throw new IOException("compressed-RTF CRC32 failed");
                }
                return false;
            }
            do {
                boolean newRun = (this.flagCount++ & 7) == 0;
                int remaining = this.bufend - this.bufstart;
                if (remaining < 3) {
                    int required;
                    int n = required = newRun ? 3 : 2;
                    if (remaining < required) {
                        if (remaining > 0) {
                            this.buf[0] = this.buf[this.bufstart];
                            if (remaining > 1) {
                                this.buf[1] = this.buf[this.bufstart + 1];
                            }
                        }
                        int read = TNEFUtils.read(this.in, this.buf, remaining, required - remaining, this.buf.length - remaining);
                        this.bufstart = 0;
                        this.bufend = remaining + read;
                        this.compressedSize -= read;
                        this.crc = CompressedRTFInputStream.calculateCRC32(this.buf, remaining, read, this.crc);
                    }
                }
                int n = this.flags = newRun ? this.buf[this.bufstart++] : this.flags >> 1;
                if ((this.flags & 1) == 0) {
                    this.dict[this.out++] = this.buf[this.bufstart++];
                } else {
                    int offset = this.buf[this.bufstart++] & 0xFF;
                    int length = this.buf[this.bufstart++] & 0xFF;
                    offset = offset << 4 | length >>> 4;
                    length = (length & 0xF) + 2;
                    if (offset != this.out) {
                        int end = offset + length;
                        while (offset < end) {
                            this.dict[this.out++ & 0xFFF] = this.dict[offset++ & 0xFFF];
                        }
                    }
                    break block14;
                }
                this.out &= 0xFFF;
            } while ((this.dictstart - this.out & 0xFFF) >= 17);
            return true;
        }
        if (this.compressedSize < 0) {
            throw new IOException("compressed data size mismatch");
        }
        while (this.compressedSize > 0) {
            this.bufend = Math.min(this.compressedSize, this.buf.length);
            this.bufend = TNEFUtils.read(this.in, this.buf, 0, this.bufend, this.bufend);
            this.crc = CompressedRTFInputStream.calculateCRC32(this.buf, 0, this.bufend, this.crc);
            this.compressedSize -= this.bufend;
        }
        this.bufend = 0;
        this.bufstart = 0;
        if (this.crc32 != this.crc) {
            throw new IOException("compressed-RTF CRC32 failed");
        }
        return this.out != this.dictstart;
    }

    protected boolean moreUncompressed() throws IOException {
        int read = this.in.read(this.dict, 0, Math.min(this.uncompressedSize, 4096));
        if (read <= 0) {
            if (this.uncompressedSize == 0) {
                return false;
            }
            throw new EOFException("unexpected end of stream");
        }
        this.out = read & 0xFFF;
        this.uncompressedSize -= read;
        return true;
    }

    protected boolean more() throws IOException {
        if (this.dictstart < 0) {
            throw new IOException("stream has been closed");
        }
        return this.magic == 1967544908 ? this.moreCompressed() : this.moreUncompressed();
    }

    public int available() throws IOException {
        return this.out - this.dictstart & 0xFFF;
    }

    public void close() throws IOException {
        this.out = -1;
        this.dictstart = -1;
        this.in.close();
    }

    public int read() throws IOException {
        if (this.dictstart == this.out && !this.more()) {
            return -1;
        }
        byte b = this.dict[this.dictstart];
        this.dictstart = this.dictstart + 1 & 0xFFF;
        return b;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int count;
        if (len == 0) {
            return 0;
        }
        if (this.dictstart == this.out && !this.more()) {
            return -1;
        }
        if ((len = Math.min(len, this.available())) == 0) {
            len = 4096;
        }
        if (len <= (count = 4096 - this.dictstart)) {
            System.arraycopy(this.dict, this.dictstart, b, off, len);
        } else {
            System.arraycopy(this.dict, this.dictstart, b, off, count);
            System.arraycopy(this.dict, 0, b, off + count, len - count);
        }
        this.dictstart = this.dictstart + len & 0xFFF;
        return len;
    }

    static {
        try {
            String prebuf = "{\\rtf1\\ansi\\mac\\deff0\\deftab720{\\fonttbl;}{\\f0\\fnil \\froman \\fswiss \\fmodern \\fscript \\fdecor MS Sans SerifSymbolArialTimes New RomanCourier{\\colortbl\\red0\\green0\\blue0\n\r\\par \\pard\\plain\\f0\\fs20\\b\\i\\u\\tab\\tx";
            COMPRESSED_RTF_PREBUF = prebuf.getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException prebuf) {
            // empty catch block
        }
        CRC32_TABLE = new int[256];
        for (int i = 0; i < 256; ++i) {
            int c = i;
            for (int j = 0; j < 8; ++j) {
                c = (c & 1) == 1 ? 0xEDB88320 ^ c >>> 1 : c >>> 1;
            }
            CompressedRTFInputStream.CRC32_TABLE[i] = c;
        }
    }
}

