/*
 * Decompiled with CFR 0.152.
 */
package net.freeutils.charset;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.util.ArrayList;

public class Utils {
    private Utils() {
    }

    static boolean isJDK15() {
        try {
            float version = Float.parseFloat(System.getProperty("java.class.version"));
            return (double)version >= 49.0;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String toInverseLookupTableDefinition(int[][] tables) {
        StringBuilder sb = new StringBuilder();
        int nulls = 0;
        sb.append("static final int[][] CHAR_TO_BYTE = {\n\t");
        for (int i = 0; i < tables.length; ++i) {
            int[] table = tables[i];
            if (table == null) {
                if (nulls++ % 8 == 0 && nulls > 1) {
                    sb.append("\n\t");
                }
                sb.append("null, ");
                continue;
            }
            if (nulls > 0) {
                sb.append("\n\t");
            }
            nulls = 0;
            sb.append("{ // high byte = 0x");
            if (i < 16) {
                sb.append('0');
            }
            sb.append(Integer.toHexString(i));
            sb.append("\n\t");
            for (int j = 0; j < table.length; ++j) {
                if (table[j] == -1) {
                    sb.append("  -1, ");
                } else {
                    sb.append("0x");
                    if (table[j] < 16) {
                        sb.append('0');
                    }
                    sb.append(Integer.toHexString(table[j])).append(", ");
                }
                if ((j + 1) % 8 != 0) continue;
                sb.append("\n\t");
            }
            sb.append("}, \n\t");
        }
        sb.append("\n\t};");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        String from = "UTF-8";
        String to = "UTF-8";
        ArrayList<String> inputFiles = new ArrayList<String>();
        String outputFile = null;
        PrintStream so = System.out;
        try {
            for (int i = 0; i < args.length; ++i) {
                String arg = args[i];
                if (arg.startsWith("-") && arg.length() > 1 && inputFiles.isEmpty()) {
                    if (arg.equals("-o")) {
                        outputFile = args[++i];
                        continue;
                    }
                    if (arg.equals("-f")) {
                        from = args[++i];
                        continue;
                    }
                    if (arg.equals("-t")) {
                        to = args[++i];
                        continue;
                    }
                    if (arg.equals("-l") || arg.equals("-ll")) {
                        String filter = arg.equals("-ll") ? Utils.class.getPackage().getName() : "";
                        for (Charset charset : Charset.availableCharsets().values()) {
                            if (!charset.getClass().getName().startsWith(filter)) continue;
                            so.println(charset.name() + " " + charset.aliases());
                        }
                        System.exit(0);
                        continue;
                    }
                    if (arg.equals("-?") || arg.equals("-h")) {
                        so.println("Usage: java -jar jcharset.jar [options] [inputFiles...]\n");
                        so.println("Converts the charset encoding of one or more (concatenated) input files.");
                        so.println("If no files or '-' (dash) is specified, input is read from stdin.");
                        so.println("\nOptions:");
                        so.println("  -f <fromCharset>\tthe name of the input charset [default UTF-8]");
                        so.println("  -t <toCharset>\tthe name of the output charset [default UTF-8]");
                        so.println("  -o <outputFile>\tthe output file name [default stdout]");
                        so.println("  -l\t\t\tlist all available charset names and aliases");
                        so.println("  -ll\t\t\tlist all JCharset charset names and aliases");
                        so.println("  -h, -?\t\tshow this help information");
                        System.exit(1);
                        continue;
                    }
                    throw new IndexOutOfBoundsException();
                }
                inputFiles.add(arg);
            }
        }
        catch (IndexOutOfBoundsException ioobe) {
            System.err.println("Error: invalid argument");
            System.err.println("Use the -h option for help");
            System.exit(2);
        }
        if (inputFiles.isEmpty()) {
            inputFiles.add("-");
        }
        OutputStream os = outputFile == null ? so : new FileOutputStream(outputFile);
        OutputStreamWriter writer = null;
        try {
            char[] buf = new char[16384];
            writer = new OutputStreamWriter(os, to);
            for (String inputFile : inputFiles) {
                InputStream is = inputFile.equals("-") ? System.in : new FileInputStream(inputFile);
                try {
                    int count;
                    InputStreamReader reader = new InputStreamReader(is, from);
                    while ((count = reader.read(buf)) > -1) {
                        writer.write(buf, 0, count);
                    }
                }
                finally {
                    is.close();
                }
            }
        }
        finally {
            if (writer != null) {
                writer.close();
            }
            os.close();
        }
    }
}

