/*
 * Decompiled with CFR 0.152.
 */
package net.fortytwo.sesametools.ldserver.query;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import net.fortytwo.sesametools.ldserver.query.SparqlTools;
import org.openrdf.sail.Sail;
import org.openrdf.sail.SailConnection;
import org.restlet.data.MediaType;
import org.restlet.representation.OutputRepresentation;

public class SparqlQueryRepresentation
extends OutputRepresentation {
    private final ByteArrayOutputStream data;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SparqlQueryRepresentation(String query, Sail sail, int limit, MediaType mediaType) throws Exception {
        super(mediaType);
        try {
            this.data = new ByteArrayOutputStream();
            SailConnection sc = sail.getConnection();
            try {
                SparqlTools.SparqlResultFormat format = SparqlTools.SparqlResultFormat.lookup(this.getMediaType());
                SparqlTools.executeQuery(query, sc, this.data, limit, format);
            }
            finally {
                sc.close();
            }
        }
        catch (Throwable e) {
            e.printStackTrace(System.err);
            throw new Exception(e);
        }
    }

    public void write(OutputStream out) throws IOException {
        this.data.writeTo(out);
    }
}

