/*
 * Decompiled with CFR 0.152.
 */
package net.fortytwo.sesametools.ldserver.query;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import net.fortytwo.sesametools.ldserver.LinkedDataServer;
import org.openrdf.sail.Sail;
import org.restlet.Request;
import org.restlet.Restlet;
import org.restlet.resource.ResourceException;

public abstract class QueryResource
extends Restlet {
    private static final Logger LOGGER = Logger.getLogger(QueryResource.class.getName());
    private static final String UTF_8 = "UTF-8";
    private static final int MAX_LIMIT = 500;
    private static final int DEFAULT_LIMIT = 300;
    private static final String LIMIT_PARAM = "limit";
    protected String selfURI;
    protected Sail sail;

    protected Map<String, String> getArguments(Request request) throws ResourceException {
        String args;
        this.selfURI = request.getResourceRef().toString();
        this.sail = LinkedDataServer.getInstance().getSail();
        int i = this.selfURI.lastIndexOf("?");
        Map<String, String> arguments = new HashMap<String, String>();
        if (0 < i && 0 < (args = this.selfURI.substring(i + 1)).length()) {
            try {
                arguments = this.parseParams(args);
            }
            catch (UnsupportedEncodingException e) {
                throw new ResourceException((Throwable)e);
            }
        }
        return arguments;
    }

    protected Map<String, String> parseParams(String s) throws UnsupportedEncodingException {
        String[] a;
        HashMap<String, String> map = new HashMap<String, String>();
        for (String p : a = s.split("&")) {
            String[] b = p.split("=");
            map.put(this.urlDecode(b[0]), this.urlDecode(b[1]));
        }
        return map;
    }

    protected int readLimit(Map<String, String> arguments) {
        int limit;
        String l = arguments.get(LIMIT_PARAM);
        if (null == l) {
            limit = 300;
        } else {
            try {
                limit = Integer.valueOf(l);
                if (limit > 500) {
                    limit = 500;
                } else if (limit < 1) {
                    limit = 300;
                }
            }
            catch (NumberFormatException e) {
                LOGGER.warning("bad limit value: " + l);
                limit = 300;
            }
        }
        return limit;
    }

    protected String urlDecode(String encoded) throws UnsupportedEncodingException {
        return URLDecoder.decode(encoded, UTF_8);
    }
}

