/*
 * Decompiled with CFR 0.152.
 */
package net.fortytwo.sesametools.ldserver;

import info.aduna.iteration.CloseableIteration;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.fortytwo.sesametools.ldserver.LinkedDataServer;
import net.fortytwo.sesametools.ldserver.RDFMediaTypes;
import net.fortytwo.sesametools.ldserver.RDFRepresentation;
import org.openrdf.model.Namespace;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.model.vocabulary.RDFS;
import org.openrdf.rio.RDFFormat;
import org.openrdf.sail.Sail;
import org.openrdf.sail.SailConnection;
import org.openrdf.sail.SailException;
import org.restlet.data.MediaType;
import org.restlet.representation.Representation;
import org.restlet.representation.Variant;
import org.restlet.resource.Get;
import org.restlet.resource.ServerResource;

public class WebResource
extends ServerResource {
    private static final Logger LOGGER = Logger.getLogger(WebResource.class.getName());
    protected String selfURI;
    private String hostIdentifier;
    private String baseRef;
    private String subjectResourceURI;
    private String typeSpecificId;
    protected WebResourceCategory webResourceCategory;
    protected Sail sail;
    private RDFFormat format = null;
    private URI datasetURI;

    public WebResource() throws Exception {
        this.getVariants().addAll(RDFMediaTypes.getRDFVariants());
    }

    @Get
    public Representation get(Variant variant) {
        this.selfURI = this.getRequest().getResourceRef().toString();
        int i = this.selfURI.lastIndexOf(".");
        if (i > 0) {
            String suffix = this.selfURI.substring(i + 1);
            this.format = RDFMediaTypes.findFormat(suffix);
        }
        if (null == this.format) {
            this.webResourceCategory = WebResourceCategory.NonInformationResource;
            this.getVariants().addAll(RDFMediaTypes.getRDFVariants());
        } else {
            this.webResourceCategory = WebResourceCategory.InformationResource;
            this.getVariants().add(RDFMediaTypes.findVariant(this.format));
            this.hostIdentifier = this.getRequest().getResourceRef().getHostIdentifier();
            this.baseRef = this.getRequest().getResourceRef().getBaseRef().toString();
            this.subjectResourceURI = this.selfURI.substring(0, i);
            this.typeSpecificId = this.subjectResourceURI.substring(this.baseRef.length());
            this.datasetURI = LinkedDataServer.getInstance().getDatasetURI();
            this.sail = LinkedDataServer.getInstance().getSail();
        }
        MediaType type = variant.getMediaType();
        switch (this.webResourceCategory) {
            case InformationResource: {
                return this.representInformationResource();
            }
            case NonInformationResource: {
                return this.representNonInformationResource(type);
            }
        }
        throw new IllegalStateException("no such resource type: " + (Object)((Object)this.webResourceCategory));
    }

    private Representation representInformationResource() {
        try {
            URI subject = this.sail.getValueFactory().createURI(this.subjectResourceURI);
            return this.getRDFRepresentation(subject, this.format);
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    private Representation representNonInformationResource(MediaType type) {
        RDFFormat format = RDFMediaTypes.findRdfFormat(type);
        if (null == format) {
            throw new IllegalStateException("no RDF format for media type " + type);
        }
        String suffix = RDFMediaTypes.findSuffix(format);
        if (null == suffix) {
            throw new IllegalStateException("no suffix for RDF format " + type);
        }
        this.getResponse().redirectSeeOther(this.selfURI + "." + suffix);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addIncidentStatements(Resource vertex, Collection<Statement> statements, SailConnection c) throws SailException {
        Statement s;
        CloseableIteration stIter = c.getStatements(vertex, null, null, false, new Resource[0]);
        try {
            while (stIter.hasNext()) {
                s = (Statement)stIter.next();
                if (null != s.getContext()) continue;
                statements.add(s);
            }
        }
        finally {
            stIter.close();
        }
        stIter = c.getStatements(null, null, (Value)vertex, false, new Resource[0]);
        try {
            while (stIter.hasNext()) {
                s = (Statement)stIter.next();
                if (null != s.getContext()) continue;
                statements.add(s);
            }
        }
        finally {
            stIter.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSeeAlsoStatements(Resource subject, Collection<Statement> statements, SailConnection c, ValueFactory vf) throws SailException {
        Resource context;
        Statement st;
        HashSet<URI> contexts = new HashSet<URI>();
        CloseableIteration iter = c.getStatements(subject, null, null, false, new Resource[0]);
        try {
            while (iter.hasNext()) {
                st = (Statement)iter.next();
                context = st.getContext();
                if (null == context || !(context instanceof URI) || !context.toString().startsWith(this.hostIdentifier)) continue;
                contexts.add((URI)context);
            }
        }
        finally {
            iter.close();
        }
        iter = c.getStatements(null, null, (Value)subject, false, new Resource[0]);
        try {
            while (iter.hasNext()) {
                st = (Statement)iter.next();
                context = st.getContext();
                if (null == context || !(context instanceof URI) || !context.toString().startsWith(this.hostIdentifier)) continue;
                contexts.add((URI)context);
            }
        }
        finally {
            iter.close();
        }
        for (URI r : contexts) {
            statements.add(vf.createStatement(subject, RDFS.SEEALSO, (Value)r));
        }
    }

    private void addDocumentMetadata(Collection<Statement> statements, ValueFactory vf) throws SailException {
        URI docURI = vf.createURI(this.selfURI);
        statements.add(vf.createStatement((Resource)docURI, RDF.TYPE, (Value)vf.createURI("http://xmlns.com/foaf/0.1/Document")));
        statements.add(vf.createStatement((Resource)docURI, RDFS.LABEL, (Value)vf.createLiteral("" + this.format.getName() + " description of " + this.resourceDescriptor() + " '" + this.typeSpecificId + "'")));
        if (null != this.datasetURI) {
            statements.add(vf.createStatement((Resource)docURI, RDFS.SEEALSO, (Value)this.datasetURI));
        }
    }

    private String resourceDescriptor() {
        return "resource";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Representation getRDFRepresentation(URI subject, RDFFormat format) {
        try {
            LinkedList<Namespace> namespaces = new LinkedList<Namespace>();
            LinkedList<Statement> statements = new LinkedList<Statement>();
            SailConnection c = this.sail.getConnection();
            try {
                this.addIncidentStatements((Resource)subject, statements, c);
                this.addSeeAlsoStatements((Resource)subject, statements, c, this.sail.getValueFactory());
                this.addDocumentMetadata(statements, this.sail.getValueFactory());
                CloseableIteration nsIter = c.getNamespaces();
                try {
                    while (nsIter.hasNext()) {
                        namespaces.add((Namespace)nsIter.next());
                    }
                }
                finally {
                    nsIter.close();
                }
            }
            finally {
                c.close();
            }
            return new RDFRepresentation(statements, namespaces, format);
        }
        catch (Throwable t) {
            t.printStackTrace();
            LOGGER.log(Level.WARNING, "failed to create RDF representation", t);
            return null;
        }
    }

    static enum WebResourceCategory {
        InformationResource,
        NonInformationResource;

    }
}

