/*
 * Decompiled with CFR 0.152.
 */
package net.fortytwo.sesametools;

import java.io.File;
import net.fortytwo.sesametools.SingleContextSailConnection;
import org.openrdf.model.Resource;
import org.openrdf.model.ValueFactory;
import org.openrdf.sail.Sail;
import org.openrdf.sail.SailConnection;
import org.openrdf.sail.SailException;
import org.openrdf.sail.StackableSail;

public class SingleContextSail
implements StackableSail {
    private Sail baseSail;
    private Resource context;

    public SingleContextSail(Sail baseSail, Resource context) {
        this.baseSail = baseSail;
        this.context = context;
        if (null == context) {
            throw new IllegalArgumentException("context may not be null");
        }
    }

    public Sail getBaseSail() {
        return this.baseSail;
    }

    public void setBaseSail(Sail baseSail) {
        this.baseSail = baseSail;
    }

    public SailConnection getConnection() throws SailException {
        return new SingleContextSailConnection(this.baseSail, this.context);
    }

    public File getDataDir() {
        return this.baseSail.getDataDir();
    }

    public ValueFactory getValueFactory() {
        return this.baseSail.getValueFactory();
    }

    public void initialize() throws SailException {
        this.baseSail.initialize();
    }

    public boolean isWritable() throws SailException {
        return this.baseSail.isWritable();
    }

    public void setDataDir(File dir) {
        this.baseSail.setDataDir(dir);
    }

    public void shutDown() throws SailException {
        this.baseSail.shutDown();
    }
}

