/*
 * Decompiled with CFR 0.152.
 */
package net.fortytwo.sesametools;

import info.aduna.iteration.CloseableIteration;
import net.fortytwo.sesametools.EmptyCloseableIteration;
import net.fortytwo.sesametools.QueryEvaluationIteration;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.algebra.evaluation.TripleSource;
import org.openrdf.sail.SailConnection;
import org.openrdf.sail.SailException;

public class SailConnectionTripleSource
implements TripleSource {
    private SailConnection baseConnection;
    private ValueFactory valueFactory;
    private boolean includeInferred;

    public SailConnectionTripleSource(SailConnection conn, ValueFactory valueFactory, boolean includeInferred) {
        this.baseConnection = conn;
        this.valueFactory = valueFactory;
        this.includeInferred = includeInferred;
    }

    public CloseableIteration<? extends Statement, QueryEvaluationException> getStatements(Resource subj, URI pred, Value obj, Resource ... contexts) {
        try {
            return new QueryEvaluationIteration((CloseableIteration<? extends Statement, SailException>)this.baseConnection.getStatements(subj, pred, obj, this.includeInferred, contexts));
        }
        catch (SailException e) {
            return new EmptyCloseableIteration();
        }
    }

    public ValueFactory getValueFactory() {
        return this.valueFactory;
    }
}

