/*
 * Decompiled with CFR 0.152.
 */
package net.fortytwo.extendo.monitron.listeners;

import com.illposed.osc.OSCListener;
import com.illposed.osc.OSCMessage;
import java.util.Date;
import net.fortytwo.extendo.monitron.Context;
import net.fortytwo.extendo.monitron.EventHandler;
import net.fortytwo.extendo.monitron.events.Event;

public abstract class MonitronListener
implements OSCListener {
    protected final Context context;

    protected MonitronListener(Context context) {
        this.context = context;
    }

    protected abstract Event handleMessage(OSCMessage var1) throws MessageParseException;

    public void acceptMessage(Date date, OSCMessage m) {
        try {
            Event event = this.handleMessage(m);
            if (null != event) {
                this.context.handleEvent(event);
            }
        }
        catch (MessageParseException e) {
            this.handleParseError(e);
        }
        catch (EventHandler.EventHandlingException e) {
            this.handleEventHandlingError(e);
        }
    }

    protected String arg(OSCMessage m, int index) throws MessageParseException {
        if (index < 0) {
            throw new IllegalArgumentException();
        }
        Object[] args = m.getArguments();
        if (index >= args.length) {
            throw new MessageParseException("not enough arguments");
        }
        Object a = args[index];
        if (!(a instanceof String)) {
            throw new MessageParseException("string-typed arguments expected");
        }
        return (String)a;
    }

    protected double doubleArg(OSCMessage m, int index) throws MessageParseException {
        String a = this.arg(m, index);
        try {
            return Double.valueOf(a);
        }
        catch (NumberFormatException e) {
            throw new MessageParseException("invalid floating-point number: " + a);
        }
    }

    protected long longArg(OSCMessage m, int index) throws MessageParseException {
        String a = this.arg(m, index);
        try {
            return Long.valueOf(a);
        }
        catch (NumberFormatException e) {
            throw new MessageParseException("invalid long integer: " + a);
        }
    }

    protected long hexLongArg(OSCMessage m, int index) throws MessageParseException {
        String a = this.arg(m, index);
        try {
            return Long.parseLong(a.toLowerCase(), 16);
        }
        catch (NumberFormatException e) {
            throw new MessageParseException("invalid hexadecimal long integer: " + a);
        }
    }

    protected long timeArg(OSCMessage m, int index) throws MessageParseException {
        long l = this.hexLongArg(m, index);
        return this.context.getTimerStart() + l;
    }

    protected boolean booleanArg(OSCMessage m, int index) throws MessageParseException {
        long b = this.longArg(m, index);
        if (1L == b) {
            return true;
        }
        if (0L == b) {
            return false;
        }
        throw new MessageParseException("boolean value should be equal to 0 or 1: " + b);
    }

    protected void handleParseError(MessageParseException e) {
        this.context.handleException(e);
    }

    protected void handleEventHandlingError(EventHandler.EventHandlingException e) {
        this.context.handleException(e);
    }

    public static class MessageParseException
    extends Exception {
        public MessageParseException(String message) {
            super(message);
        }
    }
}

