/*
 * Decompiled with CFR 0.152.
 */
package net.fortytwo.extendo.monitron.events;

import java.util.Date;
import net.fortytwo.extendo.monitron.Context;
import net.fortytwo.extendo.monitron.data.Data;
import net.fortytwo.extendo.monitron.events.Event;
import net.fortytwo.extendo.monitron.ontologies.OMOntology;
import net.fortytwo.extendo.monitron.ontologies.OWLTime;
import net.fortytwo.extendo.monitron.ontologies.Universe;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.vocabulary.RDF;

public abstract class Observation
extends Event {
    protected final URI event;
    protected final Resource samplingTime;
    protected final Resource beginning;
    protected final Resource end;
    protected final URI sensor;
    protected final Resource result;

    public Observation(Context context, URI sensor, Data data) {
        super(context);
        this.sensor = sensor;
        this.event = this.coinEventURI();
        this.addStatement(this.d, (Resource)this.event, OMOntology.OBSERVATION_LOCATION, (Value)Universe.ROOM_1);
        this.addStatement(this.d, (Resource)this.event, OMOntology.FEATURE_OF_INTEREST, (Value)Universe.ROOM_1);
        this.addStatement(this.d, (Resource)this.event, OMOntology.PROCEDURE, (Value)sensor);
        this.samplingTime = this.vf.createBNode();
        this.addStatement(this.d, this.samplingTime, RDF.TYPE, (Value)OWLTime.INTERVAL);
        this.addStatement(this.d, (Resource)this.event, OMOntology.SAMPLING_TIME, (Value)this.samplingTime);
        this.beginning = this.vf.createBNode();
        this.addStatement(this.d, this.beginning, RDF.TYPE, (Value)OWLTime.INSTANT);
        this.end = this.vf.createBNode();
        this.addStatement(this.d, this.end, RDF.TYPE, (Value)OWLTime.INSTANT);
        this.addStatement(this.d, this.beginning, OWLTime.IN_XSD_DATE_TIME, (Value)this.toLiteral(new Date(data.getSampleIntervalBeginning())));
        this.addStatement(this.d, this.end, OWLTime.IN_XSD_DATE_TIME, (Value)this.toLiteral(new Date(data.getSampleIntervalEnd())));
        this.addStatement(this.d, this.samplingTime, OWLTime.HAS_BEGINNING, (Value)this.beginning);
        this.addStatement(this.d, this.samplingTime, OWLTime.HAS_END, (Value)this.end);
        this.result = this.vf.createBNode();
        this.addStatement(this.d, this.result, RDF.TYPE, (Value)OMOntology.RESULT_DATA);
        this.addStatement(this.d, (Resource)this.event, OMOntology.RESULT, (Value)this.result);
    }
}

