/*
 * Decompiled with CFR 0.152.
 */
package net.fortytwo.extendo.monitron.events;

import java.util.Date;
import java.util.GregorianCalendar;
import java.util.LinkedList;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import net.fortytwo.extendo.Extendo;
import net.fortytwo.extendo.monitron.Context;
import net.fortytwo.rdfagents.model.Dataset;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;

public abstract class Event {
    private static final DatatypeFactory DATATYPE_FACTORY;
    protected final Context context;
    protected final ValueFactory vf;
    protected final Dataset d;

    public Event(Context context) {
        this.context = context;
        this.vf = context.getValueFactory();
        this.d = new Dataset(new LinkedList());
    }

    public Dataset getDataset() {
        return this.d;
    }

    protected URI coinEventURI() {
        return this.vf.createURI("http://fortytwo.net/2012/08/universe#event-" + Extendo.createRandomKey());
    }

    protected Literal toLiteral(Date d) {
        GregorianCalendar c = new GregorianCalendar();
        c.setTime(d);
        return this.vf.createLiteral(DATATYPE_FACTORY.newXMLGregorianCalendar(c));
    }

    protected void addStatement(Dataset d, Resource subject, URI predicate, Value object) {
        d.getStatements().add(this.vf.createStatement(subject, predicate, object));
    }

    static {
        try {
            DATATYPE_FACTORY = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

