/*
 * Decompiled with CFR 0.152.
 */
package net.fortytwo.extendo.monitron;

import com.illposed.osc.OSCListener;
import com.illposed.osc.OSCMessage;
import com.illposed.osc.OSCPacket;
import com.illposed.osc.utility.OSCPacketDispatcher;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import net.fortytwo.extendo.monitron.Context;
import net.fortytwo.extendo.monitron.EventHandler;
import net.fortytwo.extendo.monitron.listeners.SystemErrorListener;
import net.fortytwo.extendo.monitron.listeners.SystemTimerListener;
import net.fortytwo.extendo.monitron.listeners.sensors.BarometerListener;
import net.fortytwo.extendo.monitron.listeners.sensors.ColorLightLevelSensorListener;
import net.fortytwo.extendo.monitron.listeners.sensors.HygrometerListener;
import net.fortytwo.extendo.monitron.listeners.sensors.LightLevelSensorListener;
import net.fortytwo.extendo.monitron.listeners.sensors.OpticalDustSensorListener;
import net.fortytwo.extendo.monitron.listeners.sensors.PassiveInfraredSensorListener;
import net.fortytwo.extendo.monitron.listeners.sensors.SoundLevelSensorListener;
import net.fortytwo.extendo.monitron.listeners.sensors.ThermometerListener;
import net.fortytwo.extendo.monitron.listeners.sensors.VibrationLevelSensorListener;
import net.fortytwo.extendo.monitron.ontologies.MonitronOntology;
import net.fortytwo.extendo.monitron.ontologies.Universe;

public class MonitronService {
    private final InputStream input;
    private final OSCPacketDispatcher dispatcher;
    private boolean stopped = false;

    public MonitronService(InputStream input, EventHandler handler) {
        this.input = input;
        this.dispatcher = new OSCPacketDispatcher();
        Context c = new Context(handler);
        SystemErrorListener errorListener = new SystemErrorListener(c);
        this.dispatcher.addListener("/om/sensor/7bb206l0/vibr", (OSCListener)new VibrationLevelSensorListener(c, Universe.MURATA_7BB_20_6L0_1));
        this.dispatcher.addListener("/om/sensor/adjds311cr999/blue", (OSCListener)new ColorLightLevelSensorListener(c, Universe.AVAGO_ADJD_S311_CR999_1, MonitronOntology.BLUE_LIGHT_LEVEL));
        this.dispatcher.addListener("/om/sensor/adjds311cr999/green", (OSCListener)new ColorLightLevelSensorListener(c, Universe.AVAGO_ADJD_S311_CR999_1, MonitronOntology.GREEN_LIGHT_LEVEL));
        this.dispatcher.addListener("/om/sensor/adjds311cr999/red", (OSCListener)new ColorLightLevelSensorListener(c, Universe.AVAGO_ADJD_S311_CR999_1, MonitronOntology.RED_LIGHT_LEVEL));
        this.dispatcher.addListener("/om/sensor/bmp085/press", (OSCListener)new BarometerListener(c, Universe.BOSCH_BMP085_1_BAROMETER));
        this.dispatcher.addListener("/om/sensor/bmp085/temp", (OSCListener)new ThermometerListener(c, Universe.BOSCH_BMP085_1_THERMOMETER));
        this.dispatcher.addListener("/om/sensor/gp2y1010au0f/dust", (OSCListener)new OpticalDustSensorListener(c, Universe.SHARP_GP2Y101AU0F_1));
        this.dispatcher.addListener("/om/sensor/md9745apzf/sound", (OSCListener)new SoundLevelSensorListener(c, Universe.KNOWLES_MD9745APZ_F_1));
        this.dispatcher.addListener("/om/sensor/photo/light", (OSCListener)new LightLevelSensorListener(c, Universe.GENERIC_PHOTORESISTOR_1));
        this.dispatcher.addListener("/om/sensor/rht03/error", (OSCListener)errorListener);
        this.dispatcher.addListener("/om/sensor/rht03/humid", (OSCListener)new HygrometerListener(c, Universe.MAXDETECT_RHT03_1_HYGROMETER));
        this.dispatcher.addListener("/om/sensor/rht03/temp", (OSCListener)new ThermometerListener(c, Universe.MAXDETECT_RHT03_1_THERMOMETER));
        this.dispatcher.addListener("/om/sensor/se10/motion", (OSCListener)new PassiveInfraredSensorListener(c, Universe.HANSE_SE10_1));
        this.dispatcher.addListener("/om/system/error", (OSCListener)errorListener);
        this.dispatcher.addListener("/om/system/time", (OSCListener)new SystemTimerListener(c));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws IOException {
        this.stopped = false;
        BufferedReader br = new BufferedReader(new InputStreamReader(this.input));
        try {
            String line;
            while (!this.stopped && null != (line = br.readLine())) {
                OSCMessage m = this.parsePseudoOSCMessage(line.trim());
                if (null == m) continue;
                this.dispatcher.dispatchPacket((OSCPacket)m);
            }
        }
        finally {
            this.input.close();
        }
    }

    public void stop() {
        this.stopped = true;
    }

    private OSCMessage parsePseudoOSCMessage(String s) {
        if (!s.startsWith("/")) {
            return null;
        }
        String[] parts = s.split(" ");
        String address = parts[0];
        if (parts.length > 1) {
            return new OSCMessage(address, (Object[])Arrays.copyOfRange(parts, 1, parts.length));
        }
        return new OSCMessage(address);
    }
}

