/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.timeseries.models.parametric;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.finmath.optimizer.LevenbergMarquardt;
import net.finmath.optimizer.SolverException;
import net.finmath.timeseries.HistoricalSimulationModel;
import org.apache.commons.math3.analysis.MultivariateFunction;
import org.apache.commons.math3.exception.MathIllegalStateException;
import org.apache.commons.math3.optimization.GoalType;
import org.apache.commons.math3.optimization.PointValuePair;
import org.apache.commons.math3.optimization.direct.CMAESOptimizer;

public class GARCH
implements HistoricalSimulationModel {
    private double[] values;
    private int windowIndexStart;
    private int windowIndexEnd;
    private int maxIterations = 1000000;

    public GARCH(double[] values) {
        this.values = values;
        this.windowIndexStart = 0;
        this.windowIndexEnd = values.length - 1;
    }

    public GARCH(double[] values, int windowIndexStart, int windowIndexEnd) {
        this.values = values;
        this.windowIndexStart = windowIndexStart;
        this.windowIndexEnd = windowIndexEnd;
    }

    @Override
    public GARCH getCloneWithWindow(int windowIndexStart, int windowIndexEnd) {
        return new GARCH(this.values, windowIndexStart, windowIndexEnd);
    }

    public double getLogLikelihoodForParameters(double omega, double alpha, double beta) {
        double logLikelihood = 0.0;
        double volScaling = 1.0;
        double h = omega / (1.0 - alpha - beta);
        for (int i = this.windowIndexStart + 1; i <= this.windowIndexEnd - 1; ++i) {
            double eval = volScaling * Math.log(this.values[i] / this.values[i - 1]);
            h = omega + alpha * eval * eval + beta * h;
            double evalNext = volScaling * Math.log(this.values[i + 1] / this.values[i]);
            logLikelihood += -Math.log(h) - evalNext * evalNext / h;
        }
        logLikelihood += -Math.log(Math.PI * 2) * (double)(this.windowIndexEnd - this.windowIndexStart);
        return logLikelihood *= 0.5;
    }

    public double getLastResidualForParameters(double omega, double alpha, double beta) {
        double volScaling = 1.0;
        double h = omega / (1.0 - alpha - beta);
        for (int i = this.windowIndexStart + 1; i <= this.windowIndexEnd; ++i) {
            double eval = volScaling * Math.log(this.values[i] / this.values[i - 1]);
            h = omega + alpha * eval * eval + beta * h;
        }
        return h;
    }

    public double[] getSzenarios(double omega, double alpha, double beta) {
        double[] szenarios = new double[this.windowIndexEnd - this.windowIndexStart + 1 - 1];
        double volScaling = 1.0;
        double h = omega / (1.0 - alpha - beta);
        double vol = Math.sqrt(h) * volScaling;
        for (int i = this.windowIndexStart + 1; i <= this.windowIndexEnd; ++i) {
            szenarios[i - this.windowIndexStart - 1] = Math.log(this.values[i] / this.values[i - 1]) / vol;
            double eval = volScaling * Math.log(this.values[i] / this.values[i - 1]);
            h = omega + alpha * eval * eval + beta * h;
            vol = Math.sqrt(h) * volScaling;
        }
        Arrays.sort(szenarios);
        return szenarios;
    }

    public double[] getQuantilPredictionsForParameters(double omega, double alpha, double beta, double[] quantiles) {
        double[] szenarios = this.getSzenarios(omega, alpha, beta);
        double volScaling = 1.0;
        double h = omega / (1.0 - alpha - beta);
        double vol = Math.sqrt(h) * volScaling;
        double[] quantileValues = new double[quantiles.length];
        for (int i = 0; i < quantiles.length; ++i) {
            double quantileValue;
            double quantile = quantiles[i];
            double quantileIndex = (double)szenarios.length * quantile - 1.0;
            int quantileIndexLo = (int)quantileIndex;
            int quantileIndexHi = quantileIndexLo + 1;
            double szenarioRelativeChange = ((double)quantileIndexHi - quantileIndex) * Math.exp(szenarios[Math.max(quantileIndexLo, 0)] * vol) + (quantileIndex - (double)quantileIndexLo) * Math.exp(szenarios[Math.min(quantileIndexHi, szenarios.length)] * vol);
            quantileValues[i] = quantileValue = this.values[this.windowIndexEnd] * szenarioRelativeChange;
        }
        return quantileValues;
    }

    @Override
    public Map<String, Object> getBestParameters() {
        return this.getBestParameters(null);
    }

    @Override
    public Map<String, Object> getBestParameters(Map<String, Object> guess) {
        class GARCHMaxLikelihoodFunction
        implements MultivariateFunction,
        Serializable {
            private static final long serialVersionUID = 7072187082052755854L;

            GARCHMaxLikelihoodFunction() {
            }

            public double value(double[] variables) {
                double omega = Math.exp(variables[0]);
                double mucorr = Math.exp(-Math.exp(-variables[1]));
                double muema = Math.exp(-Math.exp(-variables[2]));
                double beta = mucorr * muema;
                double alpha = mucorr - beta;
                double logLikelihood = GARCH.this.getLogLikelihoodForParameters(omega, alpha, beta);
                logLikelihood -= Math.max(1.0E-30 - omega, 0.0) / 1.0E-30;
                logLikelihood -= Math.max(1.0E-30 - alpha, 0.0) / 1.0E-30;
                logLikelihood -= Math.max(alpha - 1.0 + 1.0E-30, 0.0) / 1.0E-30;
                logLikelihood -= Math.max(1.0E-30 - beta, 0.0) / 1.0E-30;
                return logLikelihood -= Math.max(beta - 1.0 + 1.0E-30, 0.0) / 1.0E-30;
            }
        }
        final GARCHMaxLikelihoodFunction objectiveFunction = new GARCHMaxLikelihoodFunction();
        double guessOmega = 1.0;
        double guessAlpha = 0.2;
        double guessBeta = 0.2;
        if (guess != null) {
            guessOmega = (Double)guess.get("Omega");
            guessAlpha = (Double)guess.get("Alpha");
            guessBeta = (Double)guess.get("Beta");
        }
        guessOmega = GARCH.restrictToOpenSet(guessOmega, 0.0, Double.MAX_VALUE);
        guessAlpha = GARCH.restrictToOpenSet(guessAlpha, 0.0, 1.0);
        guessBeta = GARCH.restrictToOpenSet(guessBeta, 0.0, 1.0 - guessAlpha);
        double guessMucorr = guessAlpha + guessBeta;
        double guessMuema = guessBeta / (guessAlpha + guessBeta);
        double[] guessParameters = new double[]{Math.log(guessOmega), -Math.log(-Math.log(guessMucorr)), -Math.log(-Math.log(guessMuema))};
        LevenbergMarquardt lm = new LevenbergMarquardt(guessParameters, new double[]{1000.0}, this.maxIterations, 2){
            private static final long serialVersionUID = 611999941537812214L;
            {
                super(initialParameters, targetValues, maxIteration, numberOfThreads);
            }

            @Override
            public void setValues(double[] arg0, double[] arg1) throws SolverException {
                arg1[0] = objectiveFunction.value(arg0);
            }
        };
        double[] bestParameters = null;
        boolean isUseLM = false;
        if (isUseLM) {
            try {
                lm.run();
            }
            catch (SolverException e1) {
                e1.printStackTrace();
            }
            bestParameters = lm.getBestFitParameters();
        } else {
            CMAESOptimizer optimizer2 = new CMAESOptimizer();
            try {
                PointValuePair result = optimizer2.optimize(this.maxIterations, (MultivariateFunction)objectiveFunction, GoalType.MAXIMIZE, guessParameters);
                bestParameters = result.getPoint();
            }
            catch (MathIllegalStateException e) {
                System.out.println("Solver failed");
                bestParameters = guessParameters;
            }
        }
        double omega = Math.exp(bestParameters[0]);
        double mucorr = Math.exp(-Math.exp(-bestParameters[1]));
        double muema = Math.exp(-Math.exp(-bestParameters[2]));
        double beta = mucorr * muema;
        double alpha = mucorr - beta;
        double[] quantiles = new double[]{0.01, 0.05, 0.5};
        double[] quantileValues = this.getQuantilPredictionsForParameters(omega, alpha, beta, quantiles);
        HashMap<String, Object> results = new HashMap<String, Object>();
        results.put("Omega", omega);
        results.put("Alpha", alpha);
        results.put("Beta", beta);
        results.put("Szenarios", this.getSzenarios(omega, alpha, beta));
        results.put("Likelihood", this.getLogLikelihoodForParameters(omega, alpha, beta));
        results.put("Vol", Math.sqrt(this.getLastResidualForParameters(omega, alpha, beta)));
        results.put("Quantile=1%", quantileValues[0]);
        results.put("Quantile=5%", quantileValues[1]);
        results.put("Quantile=50%", quantileValues[2]);
        return results;
    }

    private static double restrictToOpenSet(double value, double lowerBond, double upperBound) {
        value = Math.max(value, lowerBond * (1.0 + Math.signum(lowerBond) * 1.0E-15) + 1.0E-15);
        value = Math.min(value, upperBound * (1.0 - Math.signum(upperBound) * 1.0E-15) - 1.0E-15);
        return value;
    }
}

