/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.rootfinder;

import net.finmath.rootfinder.NewtonsMethod;
import net.finmath.rootfinder.RootFinder;

public class SecantMethod
extends NewtonsMethod
implements RootFinder {
    private final double secondGuess;
    private double currentPoint;
    private double lastPoint;
    private double lastValue;

    public SecantMethod(double firstGuess, double secondGuess) {
        super(firstGuess);
        this.secondGuess = secondGuess;
    }

    @Override
    public double getNextPoint() {
        this.currentPoint = super.getNextPoint();
        return this.currentPoint;
    }

    @Override
    public void setValue(double value) {
        double derivative = this.getNumberOfIterations() == 0 ? value / (this.secondGuess - this.currentPoint) : (value - this.lastValue) / (this.currentPoint - this.lastPoint);
        this.lastPoint = this.currentPoint;
        this.lastValue = value;
        super.setValueAndDerivative(value, derivative);
    }

    @Override
    public void setValueAndDerivative(double value, double derivative) {
        this.lastPoint = super.getNextPoint();
        this.lastValue = value;
        super.setValueAndDerivative(value, derivative);
    }
}

