/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.products.indices;

import java.util.Set;
import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.interestrate.LIBORModelMonteCarloSimulationInterface;
import net.finmath.montecarlo.interestrate.products.components.AbstractProductComponent;
import net.finmath.montecarlo.interestrate.products.indices.AbstractIndex;
import net.finmath.stochastic.RandomVariableInterface;

public class PowIndex
extends AbstractIndex {
    private static final long serialVersionUID = -1512137372132830198L;
    private final AbstractProductComponent index;
    private final double exponent;

    public PowIndex(AbstractProductComponent index, double exponent) {
        this.index = index;
        this.exponent = exponent;
    }

    @Override
    public RandomVariableInterface getValue(double evaluationTime, LIBORModelMonteCarloSimulationInterface model) throws CalculationException {
        return this.index.getValue(evaluationTime, model).pow(this.exponent);
    }

    @Override
    public Set<String> queryUnderlyings() {
        return this.index.queryUnderlyings();
    }

    @Override
    public String toString() {
        return "PowIndex [index=" + this.index + ", exponent=" + this.exponent + "]";
    }
}

